/*
 * Decompiled with CFR 0.152.
 */
package jEditInterface;

import CopyFile.CopyFile;
import GKnowledgeBase.GKnowledgeBase;
import GLanguage.GLanguage;
import GModel.GModel;
import GObjectInformation.GObjectInformation;
import GWindow.GWindow;
import GWindow.GWindowAbout;
import GWindow.GWindowFaultTree;
import GWindow.GWindowGenerateFig0;
import GWindow.GWindowMain;
import GWindow.GWindowModel;
import GWindow.GWindowNewObject;
import GWindow.GWindowOpenModel;
import GWindow.GWindowWizard;
import GXMLLoader.GXMLLoader;
import GXMLLoader.GXMLLoaderDefaultFiles;
import GXMLLoader.GXMLLoaderFigaro;
import figaroInterface.FigaroTree;
import figaroInterface.GCell;
import figaroInterface.GTree;
import jEditInterface.VisualFigaroActions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.DOMBuilder;
import org.jdom.input.SAXBuilder;

public class VisualFigaro
extends JPanel
implements EBComponent,
VisualFigaroActions,
DefaultFocusComponent {
    private static final long serialVersionUID = 1L;
    private View view;
    private boolean floating;
    private JButton translateButton;
    private JPanel userInterface;
    private JComboBox comboTree;
    private FigaroTree figTree;
    private JMenuBar menuBar;
    private Vector<GKnowledgeBase> knowledgedBasesVector;
    private Vector<GModel> modelsVector;
    private String currentFile;
    private boolean isOpening = false;
    private String osname;
    private String languageName;
    private JMenuItem menuPrevKBFileItem;
    private JMenu menu;

    public VisualFigaro(View viewArg, String position) {
        super(new BorderLayout());
        this.view = viewArg;
        this.floating = position.equals("floating");
        this.knowledgedBasesVector = new Vector();
        this.modelsVector = new Vector();
        this.osname = System.getProperty("os.name");
        this.initializeUserInterface();
        this.add((Component)this.userInterface, "North");
        this.figTree = new FigaroTree(this);
        this.add("Center", this.figTree);
        this.view.getEditPane().getTextArea().getPainter().addMouseListener(new MouseListener(){

            @Override
            public void mousePressed(MouseEvent me) {
                if (VisualFigaro.this.comboTree.getComponentCount() > 0 && VisualFigaro.this.comboTree.getSelectedItem() != null && VisualFigaro.this.comboTree.getSelectedItem().toString().equals(VisualFigaro.this.currentFile)) {
                    VisualFigaro.this.figTree.mouseClicked();
                }
            }

            @Override
            public void mouseReleased(MouseEvent me) {
            }

            @Override
            public void mouseEntered(MouseEvent me) {
            }

            @Override
            public void mouseExited(MouseEvent me) {
            }

            @Override
            public void mouseClicked(MouseEvent me) {
            }
        });
        this.initializeTranslateButton();
        this.add((Component)this.translateButton, "East");
        if (this.floating) {
            this.setPreferredSize(new Dimension(500, 250));
        }
    }

    private void initializeUserInterface() {
        this.userInterface = new JPanel(new BorderLayout());
        this.initializeMenuBar();
        this.userInterface.add((Component)this.menuBar, "North");
        this.initializeFileCombo();
        this.userInterface.add((Component)this.comboTree, "South");
    }

    private void initializeMenuBar() {
        this.menuBar = new JMenuBar();
        this.menu = new JMenu("KB Management");
        JMenuItem menuItem = new JMenuItem("New KB");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualFigaro.this.createKB();
            }
        });
        this.menu.add(menuItem);
        menuItem = new JMenuItem("Open KB");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VisualFigaro.this.openKB();
            }
        });
        this.menu.add(menuItem);
        menuItem = new JMenuItem("Close KB");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VisualFigaro.this.closeKB();
            }
        });
        this.menu.add(menuItem);
        this.menu.addSeparator();
        menuItem = new JMenuItem("Translate KB");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    VisualFigaro.this.translateKB();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        this.menu.add(menuItem);
        this.menu.addSeparator();
        this.menuPrevKBFileItem = new JMenuItem(this.getPrevKBFile());
        this.menuPrevKBFileItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                File f = new File(VisualFigaro.this.getPrevKBFile());
                File directory = new File(f.getParent());
                VisualFigaro.this.openKB(directory, f);
            }
        });
        this.menu.add(this.menuPrevKBFileItem);
        this.menu.addSeparator();
        menuItem = new JMenuItem("Edit XML File");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualFigaro.this.editXMLFile();
            }
        });
        this.menu.add(menuItem);
        this.menu.addSeparator();
        menuItem = new JMenuItem("Apply Inheritance");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualFigaro.this.applyInheritance();
            }
        });
        this.menu.add(menuItem);
        menuItem = new JMenuItem("Check KB");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualFigaro.this.checkKB();
            }
        });
        this.menu.add(menuItem);
        menuItem = new JMenuItem("Precompile KB");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualFigaro.this.precompileKB();
            }
        });
        this.menu.add(menuItem);
        menuItem = new JMenuItem("Class Hierarchy");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualFigaro.this.classHierarchy();
            }
        });
        this.menu.add(menuItem);
        menuItem = new JMenuItem("XML Squeleton");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualFigaro.this.xmlSqueleton();
            }
        });
        this.menu.add(menuItem);
        this.menu.addSeparator();
        menuItem = new JMenuItem("About Visual Figaro");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VisualFigaro.this.aboutVisualFigaro();
            }
        });
        this.menu.add(menuItem);
        this.menuBar.add(this.menu);
        this.menu = new JMenu("Object Management");
        menuItem = new JMenuItem("New Model");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualFigaro.this.createModel();
            }
        });
        this.menu.add(menuItem);
        menuItem = new JMenuItem("Open Model");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualFigaro.this.openModel();
            }
        });
        this.menu.add(menuItem);
        menuItem = new JMenuItem("Close Model");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualFigaro.this.closeModel();
            }
        });
        this.menu.add(menuItem);
        this.menu.addSeparator();
        menuItem = new JMenuItem("New Object");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualFigaro.this.createObject();
            }
        });
        this.menu.add(menuItem);
        this.menu.addSeparator();
        menuItem = new JMenuItem("Check Model");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualFigaro.this.checkModel();
            }
        });
        this.menu.add(menuItem);
        this.menu.addSeparator();
        menuItem = new JMenuItem("Generate Figaro 0");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualFigaro.this.generateFig0(0);
            }
        });
        this.menu.add(menuItem);
        menuItem = new JMenuItem("Run Fig0debug");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualFigaro.this.runFig0debug();
            }
        });
        this.menu.add(menuItem);
        menuItem = new JMenuItem("Run Figseq");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualFigaro.this.runFigseq();
            }
        });
        this.menu.add(menuItem);
        menuItem = new JMenuItem("Run Yams");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualFigaro.this.runYams();
            }
        });
        this.menu.add(menuItem);
        menuItem = new JMenuItem("Generate Fault Tree");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualFigaro.this.generateFaultTree();
            }
        });
        this.menu.add(menuItem);
        this.menuBar.add(this.menu);
    }

    private void initializeFileCombo() {
        this.comboTree = new JComboBox();
        this.comboTree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (VisualFigaro.this.comboTree.getSelectedIndex() < 0) {
                    VisualFigaro.this.figTree.loadSpecificGTree(null);
                } else {
                    int pos = 0;
                    VisualFigaro.this.currentFile = VisualFigaro.this.comboTree.getSelectedItem().toString();
                    pos = 0;
                    while (pos < VisualFigaro.this.view.getEditPane().getBufferSwitcher().getItemCount()) {
                        if (((Buffer)VisualFigaro.this.view.getEditPane().getBufferSwitcher().getItemAt(pos)).getPath().equals(VisualFigaro.this.currentFile)) break;
                        ++pos;
                    }
                    VisualFigaro.this.view.getEditPane().getBufferSwitcher().setSelectedIndex(pos);
                    VisualFigaro.this.view.getEditPane().getBufferSwitcher().updateBufferList();
                    if (VisualFigaro.this.findKnowledgeBaseFromName(VisualFigaro.this.currentFile) == null) {
                        if (VisualFigaro.this.findModelFromName(VisualFigaro.this.currentFile) == null) {
                            VisualFigaro.this.figTree.loadSpecificGTree(null);
                        } else {
                            VisualFigaro.this.figTree.loadSpecificGTree(VisualFigaro.this.findModelFromName(VisualFigaro.this.currentFile).getKnowledgeBase().getKnowledgeBaseTree());
                            if (VisualFigaro.this.findModelFromName(VisualFigaro.this.currentFile).isKBModify()) {
                                JOptionPane.showMessageDialog(VisualFigaro.this, "The knowledge base associated to the model has been modified !");
                                VisualFigaro.this.findModelFromName(VisualFigaro.this.currentFile).setKBModify(false);
                            }
                        }
                    } else {
                        VisualFigaro.this.figTree.loadSpecificGTree(VisualFigaro.this.findKnowledgeBaseFromName(VisualFigaro.this.currentFile).getKnowledgeBaseTree());
                    }
                }
            }
        });
    }

    private void initializeTranslateButton() {
        this.translateButton = new JButton("<=");
        this.translateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualFigaro.this.view.getBuffer().save(VisualFigaro.this.view, VisualFigaro.this.currentFile);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e1) {
                    System.err.println("Sleep()");
                }
                GKnowledgeBase knowledgeBase = VisualFigaro.this.findKnowledgeBaseFromName(VisualFigaro.this.currentFile);
                if (knowledgeBase != null) {
                    VisualFigaro.this.comboTree.setSelectedItem(VisualFigaro.this.currentFile);
                    String path = "";
                    path = VisualFigaro.this.isOSWindows() ? String.valueOf(System.getenv("TMP")) + "\\test1_fi.xml" : String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/test1_fi.xml";
                    if (VisualFigaro.this.precompileXML()) {
                        VisualFigaro.this.figTree.loadTreeFromXML(path, VisualFigaro.this.view.getEditPane().getTextArea().getText(), knowledgeBase.getKnowledgeBaseLanguage());
                        knowledgeBase.setKnowledgeBaseTree(VisualFigaro.this.figTree.getGTree().clone());
                    }
                    VisualFigaro.this.setIconsUpToDate();
                }
            }
        });
    }

    public String getOsName() {
        return this.osname;
    }

    public boolean isOSWindows() {
        return this.osname.contains("Windows");
    }

    private void createKB() {
        GWindowWizard window = new GWindowWizard(this);
        window.setVisible(true);
        window.setAlwaysOnTop(true);
    }

    private void openKB() {
        JFileChooser chooser = new JFileChooser(this.getPrevKBFile());
        class MyFilter
        extends FileFilter {
            MyFilter() {
            }

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String filename = file.getName();
                return filename.endsWith(".fi");
            }

            @Override
            public String getDescription() {
                return "*.fi";
            }
        }
        chooser.addChoosableFileFilter(new MyFilter());
        chooser.setAcceptAllFileFilterUsed(false);
        int returnValue = chooser.showOpenDialog(null);
        if (returnValue == 0) {
            File selectedFile = chooser.getSelectedFile();
            System.out.println(selectedFile.getPath());
            File f = null;
            File directory = null;
            try {
                f = new File(selectedFile.getCanonicalPath());
                directory = new File(selectedFile.getParent());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            chooser.setSelectedFile(f);
            this.openKB(directory, f);
        }
    }

    public void openKB(File directory) {
        System.err.println("Open KB : " + directory);
        boolean integrityCheckResult = this.checkIntegrity(directory.getAbsolutePath());
        String[] filesName = directory.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String filename) {
                return filename.toLowerCase().endsWith(".fi");
            }
        });
        if (integrityCheckResult) {
            String figaroFileName = this.isOSWindows() ? String.valueOf(directory.getAbsolutePath()) + "\\" + filesName[0] : String.valueOf(directory.getAbsolutePath()) + "/" + filesName[0];
            if (this.findKnowledgeBaseFromName(figaroFileName) != null) {
                JOptionPane.showMessageDialog(this, "The Knowledge Base is already opened.");
                return;
            }
            System.err.println("Open Before : File : " + this.view.getBuffer().getDirectory() + this.view.getBuffer().getName());
            this.isOpening = true;
            jEdit.openFile((View)this.view, (String)figaroFileName);
            VFSManager.waitForRequests();
            this.isOpening = false;
            this.currentFile = figaroFileName;
            String path = "";
            path = this.isOSWindows() ? String.valueOf(System.getenv("TMP")) + "\\test1_fi.xml" : String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/test1_fi.xml";
            if (this.precompileXML()) {
                System.err.println("Precompile OK");
                this.languageName = this.findKnowledgeBaseLanguage(directory.getAbsolutePath());
                GLanguage language = new GLanguage();
                language.setLanguage(this.languageName);
                this.figTree.newGTree();
                this.figTree.loadTreeFromXML(path, this.view.getEditPane().getTextArea().getText(), language);
                GKnowledgeBase knowledgeBase = new GKnowledgeBase(figaroFileName, language, this.figTree.getGTree().clone());
                this.knowledgedBasesVector.add(knowledgeBase);
                this.comboTree.addItem(figaroFileName);
                this.comboTree.setSelectedItem(figaroFileName);
                this.setIconsUpToDate();
                this.linkToModel(knowledgeBase);
            } else {
                System.err.println("Precompile Failed");
            }
        }
    }

    public void openKB(File directory, File file) {
        boolean integrityCheckResult = this.checkIntegrity(directory.getAbsolutePath());
        if (integrityCheckResult) {
            String figaroFileName = file.getAbsolutePath();
            if (this.findKnowledgeBaseFromName(figaroFileName) != null) {
                JOptionPane.showMessageDialog(this, "The Knowledge Base is already opened.");
                return;
            }
            System.err.println("Open Before : File : " + this.view.getBuffer().getDirectory() + this.view.getBuffer().getName());
            this.isOpening = true;
            jEdit.openFile((View)this.view, (String)figaroFileName);
            VFSManager.waitForRequests();
            this.isOpening = false;
            this.currentFile = figaroFileName;
            String path = "";
            path = this.isOSWindows() ? String.valueOf(System.getenv("TMP")) + "\\test1_fi.xml" : String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/test1_fi.xml";
            if (this.precompileXML()) {
                System.err.println("Precompile OK");
                this.languageName = this.findKnowledgeBaseLanguage(directory.getAbsolutePath());
                GLanguage language = new GLanguage();
                language.setLanguage(this.languageName);
                this.figTree.newGTree();
                this.figTree.loadTreeFromXML(path, this.view.getEditPane().getTextArea().getText(), language);
                GKnowledgeBase knowledgeBase = new GKnowledgeBase(figaroFileName, language, this.figTree.getGTree().clone());
                this.knowledgedBasesVector.add(knowledgeBase);
                this.comboTree.addItem(figaroFileName);
                this.comboTree.setSelectedItem(figaroFileName);
                this.setIconsUpToDate();
                this.linkToModel(knowledgeBase);
            } else {
                JOptionPane.showMessageDialog(this, "Precompile Failed");
                System.err.println("Precompile Failed");
            }
        }
    }

    private void linkToModel(GKnowledgeBase knowledgeBase) {
        for (GModel m : this.modelsVector) {
            if (!m.getKnowledgeBase().getKnowledgeBaseName().equals(knowledgeBase.getKnowledgeBaseName())) continue;
            m.setModelKnowledgeBase(knowledgeBase);
            m.setKBModify(true);
        }
    }

    private void applyInheritance() {
        if (this.knowledgedBasesVector.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Open a Knowledge Base first !");
        } else if (this.findKnowledgeBaseFromName(this.currentFile) != null) {
            String figpPath = String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/figp.exe";
            GKnowledgeBase knowledgeBase = this.findKnowledgeBaseFromName(this.currentFile);
            String knowledgeBaseName = knowledgeBase.getKnowledgeBaseName();
            String langOption = "french";
            if (knowledgeBase.getKnowledgeBaseLanguage().getLanguage().equals("English")) {
                langOption = "english";
            }
            String[] cmd = this.isOSWindows() ? new String[]{figpPath, "-lang", langOption, knowledgeBaseName, "-wie3"} : new String[]{"figp", "-lang", langOption, knowledgeBaseName, "-wie3"};
            this.executeCommand(cmd, "Apply Inheritance", true, true, true, false);
        } else {
            JOptionPane.showMessageDialog(this, "The current File is not a knowledgebase");
        }
    }

    private void checkKB() {
        if (this.knowledgedBasesVector.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Open a Knowledge Base first !");
        } else if (this.findKnowledgeBaseFromName(this.currentFile) != null) {
            String figpPath = String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/figp.exe";
            GKnowledgeBase knowledgeBase = this.findKnowledgeBaseFromName(this.currentFile);
            String knowledgeBaseName = knowledgeBase.getKnowledgeBaseName();
            String langOption = "french";
            if (knowledgeBase.getKnowledgeBaseLanguage().getLanguage().equals("English")) {
                langOption = "english";
            }
            String[] cmd = this.isOSWindows() ? new String[]{figpPath, "-lang", langOption, knowledgeBaseName} : new String[]{"figp", "-lang", langOption, knowledgeBaseName};
            this.executeCommand(cmd, "Check KnowledgeBase", true, true, true, false);
        } else {
            JOptionPane.showMessageDialog(this, "The current File is not a knowledgebase");
        }
    }

    private void precompileKB() {
        if (this.knowledgedBasesVector.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Open a Knowledge Base first !");
        } else if (this.findKnowledgeBaseFromName(this.currentFile) != null) {
            String figpPath = String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/cpp_st.exe";
            GKnowledgeBase knowledgeBase = this.findKnowledgeBaseFromName(this.currentFile);
            String knowledgeBaseName = knowledgeBase.getKnowledgeBaseName();
            String[] cmd = this.isOSWindows() ? new String[]{figpPath, "-traditional", knowledgeBaseName} : new String[]{figpPath, "-traditional", knowledgeBaseName};
            this.executeCommand(cmd, "Check KnowledgeBase", true, true, true, false);
        } else {
            JOptionPane.showMessageDialog(this, "The current File is not a knowledgebase");
        }
    }

    private void classHierarchy() {
        if (this.knowledgedBasesVector.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Open a Knowledge Base first !");
        } else if (this.findKnowledgeBaseFromName(this.currentFile) != null) {
            String figpPath = String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/figp.exe";
            GKnowledgeBase knowledgeBase = this.findKnowledgeBaseFromName(this.currentFile);
            String knowledgeBaseName = knowledgeBase.getKnowledgeBaseName();
            String langOption = "french";
            if (knowledgeBase.getKnowledgeBaseLanguage().getLanguage().equals("English")) {
                langOption = "english";
            }
            String[] cmd = this.isOSWindows() ? new String[]{figpPath, "-lang", langOption, knowledgeBaseName, "-whe3"} : new String[]{"figp", "-lang", langOption, knowledgeBaseName, "-whe3"};
            this.executeCommand(cmd, "Class Hierarchy", true, true, true, false);
        } else {
            JOptionPane.showMessageDialog(this, "The current File is not a knowledgebase");
        }
    }

    private void xmlSqueleton() {
        if (this.knowledgedBasesVector.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Open a Knowledge Base first !");
        } else if (this.findKnowledgeBaseFromName(this.currentFile) != null) {
            String figpPath = String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/figp.exe";
            GKnowledgeBase knowledgeBase = this.findKnowledgeBaseFromName(this.currentFile);
            String knowledgeBaseName = knowledgeBase.getKnowledgeBaseName();
            String langOption = "french";
            if (knowledgeBase.getKnowledgeBaseLanguage().getLanguage().equals("English")) {
                langOption = "english";
            }
            String[] cmd = this.isOSWindows() ? new String[]{figpPath, "-lang", langOption, knowledgeBaseName, "-wse3"} : new String[]{"figp", "-lang", langOption, knowledgeBaseName, "-wse3"};
            this.executeCommand(cmd, "Xml Squeleton", true, true, true, false);
        } else {
            JOptionPane.showMessageDialog(this, "The current File is not a knowledgebase");
        }
    }

    private void createModel() {
        if (this.knowledgedBasesVector.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Open a Knowledge Base first");
            return;
        }
        GWindowModel window = new GWindowModel(this, this.knowledgedBasesVector);
        window.setVisible(true);
        window.setAlwaysOnTop(true);
    }

    private void openModel() {
        if (this.knowledgedBasesVector.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Open a Knowledge Base first");
            return;
        }
        GWindowOpenModel window = new GWindowOpenModel(this, this.knowledgedBasesVector);
        window.setVisible(true);
        window.setAlwaysOnTop(true);
    }

    public void openModel(File file, GKnowledgeBase kb) {
        boolean modelExist = this.checkMdlExist(file);
        if (modelExist) {
            String figaroFileName = file.getAbsolutePath();
            if (this.findModelFromName(figaroFileName) != null) {
                JOptionPane.showMessageDialog(this, "The Model is already opened.");
                return;
            }
            System.err.println("Open Before : File : " + this.view.getBuffer().getDirectory() + this.view.getBuffer().getName());
            this.isOpening = true;
            jEdit.openFile((View)this.view, (String)figaroFileName);
            this.isOpening = false;
            this.currentFile = figaroFileName;
            GModel model = new GModel(figaroFileName, kb);
            this.modelsVector.add(model);
            this.comboTree.addItem(figaroFileName);
            this.comboTree.setSelectedItem(figaroFileName);
            this.figTree.loadSpecificGTree(kb.getKnowledgeBaseTree());
        }
    }

    private boolean checkMdlExist(File file) {
        boolean mdlexist = true;
        String errorMessage = "";
        if (!file.exists() && !file.getName().toLowerCase().endsWith(".fi")) {
            errorMessage = String.valueOf(errorMessage) + "The Model does not exist.\n";
            mdlexist = false;
        }
        if (!mdlexist) {
            JOptionPane.showMessageDialog(this, errorMessage, "Model loading error", 0);
        }
        return mdlexist;
    }

    private void closeModel() {
        this.currentFile = this.view.getBuffer().getPath();
        GKnowledgeBase knowledgeBase = this.findKnowledgeBaseFromName(this.currentFile);
        GModel model = this.findModelFromName(this.currentFile);
        if (model != null) {
            try {
                this.saveToIniFile(this.currentFile, 1);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Buffer save = this.view.getBuffer();
            this.comboTree.removeItem(this.currentFile);
            jEdit.closeBuffer((View)this.view, (Buffer)save);
            this.modelsVector.remove(model);
        } else if (knowledgeBase != null) {
            Object[] options = new Object[]{"Close", "Cancel"};
            int choix = JOptionPane.showOptionDialog(this, "The current open file is a Knowledge Base, do you want to close it ?", "Current File not a Knowledge Base", 2, 2, null, options, options[1]);
            if (choix == 0) {
                this.closeKB();
            }
        } else {
            this.comboTree.setSelectedIndex(-1);
            jEdit.closeAllBuffers((View)this.view);
        }
        this.currentFile = this.view.getBuffer().getPath();
    }

    private void createObject() {
        if (this.findModelFromName(this.currentFile) == null) {
            JOptionPane.showMessageDialog(this, "Select a model before !");
            return;
        }
        GModel model = this.findModelFromName(this.currentFile);
        GKnowledgeBase knowledgeBase = model.getKnowledgeBase();
        String knowledgeBaseFileName = knowledgeBase.getKnowledgeBaseName();
        DOMBuilder builder = new DOMBuilder();
        GObjectInformation info = new GObjectInformation();
        info.setLanguage(knowledgeBase.getKnowledgeBaseLanguage());
        if (this.isOSWindows()) {
            info.setKnowledgeBasePath(knowledgeBaseFileName.substring(0, knowledgeBaseFileName.lastIndexOf("\\")));
        } else {
            info.setKnowledgeBasePath(knowledgeBaseFileName.substring(0, knowledgeBaseFileName.lastIndexOf("/")));
        }
        GXMLLoader xmlLoader = new GXMLLoader(info.getLanguage());
        xmlLoader.loadXmlFile(knowledgeBaseFileName.substring(0, knowledgeBaseFileName.length() - 2).concat("bdc"));
        GWindow.setXmlLoader(xmlLoader);
        GXMLLoaderFigaro figaroLoader = new GXMLLoaderFigaro();
        figaroLoader.setXmlFile(builder.build(this.figTree.getGTree().getDocument()));
        GWindow.setFigaroLoader(figaroLoader);
        GWindowNewObject window = new GWindowNewObject(this, null, info, model);
        window.setVisible(true);
        window.setAlwaysOnTop(true);
    }

    /*
     * Exception decompiling
     */
    private void executeCommand(String[] command, String title, Boolean block, Boolean erroroutput, Boolean fileoutput, Boolean model_treatment) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkModel() {
        if (this.modelsVector.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Open a Model first !");
        } else if (this.findModelFromName(this.currentFile) != null) {
            String figpPath = String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/figp.exe";
            GModel model = this.findModelFromName(this.currentFile);
            GKnowledgeBase knowledgeBase = model.getKnowledgeBase();
            String modelName = model.getModelName();
            String knowledgeBaseName = knowledgeBase.getKnowledgeBaseName();
            String langOption = "french";
            if (model.getModelLanguage().getLanguage().equals("English")) {
                langOption = "english";
            }
            String[] cmd = this.isOSWindows() ? new String[]{figpPath, "-lang", langOption, knowledgeBaseName, "-bdf", modelName} : new String[]{"figp", "-lang", langOption, knowledgeBaseName, "-bdf", modelName};
            this.executeCommand(cmd, "Check Model", true, true, false, true);
        } else {
            JOptionPane.showMessageDialog(this, "The current File is not a model");
        }
    }

    private void generateFig0(int postTreatment) {
        if (this.modelsVector.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Open a Model first !");
        } else {
            GModel model = this.findModelFromName(this.currentFile);
            if (model != null) {
                GKnowledgeBase knowledgeBase = model.getKnowledgeBase();
                String knowledgeBaseFileName = knowledgeBase.getKnowledgeBaseName();
                DOMBuilder builder = new DOMBuilder();
                GObjectInformation info = new GObjectInformation();
                info.setLanguage(knowledgeBase.getKnowledgeBaseLanguage());
                if (this.isOSWindows()) {
                    info.setKnowledgeBasePath(knowledgeBaseFileName.substring(0, knowledgeBaseFileName.lastIndexOf("\\")));
                } else {
                    info.setKnowledgeBasePath(knowledgeBaseFileName.substring(0, knowledgeBaseFileName.lastIndexOf("/")));
                }
                GXMLLoader xmlLoader = new GXMLLoader(info.getLanguage());
                xmlLoader.loadXmlFile(knowledgeBaseFileName.substring(0, knowledgeBaseFileName.length() - 2).concat("bdc"));
                GWindow.setXmlLoader(xmlLoader);
                GXMLLoaderFigaro figaroLoader = new GXMLLoaderFigaro();
                figaroLoader.setXmlFile(builder.build(this.figTree.getGTree().getDocument()));
                GWindow.setFigaroLoader(figaroLoader);
                GWindowGenerateFig0 window = new GWindowGenerateFig0(this, null, info, model, postTreatment);
                window.setVisible(true);
                window.setAlwaysOnTop(true);
            } else {
                JOptionPane.showMessageDialog(this, "The current File is not a model");
            }
        }
    }

    public void cmdFig0(String fig0FileName, int postTreatment) {
        File commands = new File(String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/figp_commands.xml");
        File fig0File = new File(fig0FileName);
        if (commands.exists()) {
            String TempFile = "";
            TempFile = this.isOSWindows() ? String.valueOf(System.getenv("TMP")) + "\\fig0_temp.fi" : String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/fig0_temp.fi";
            if (fig0FileName.equals(TempFile)) {
                fig0File.delete();
            }
            if (fig0File.exists()) {
                Object[] options = new Object[]{"Cancel", "Overwrite"};
                int choix = JOptionPane.showOptionDialog(this, "The output file " + fig0FileName + " already exist, overwrite ?", "Figaro 0 file already exist", 2, 2, null, options, options[1]);
                if (choix == 0) {
                    return;
                }
                fig0File.delete();
            }
            String appli = String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/figp.exe";
            String commandsFile = String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/figp_commands.xml";
            String[] cmd = this.isOSWindows() ? new String[]{appli, "-testxml", commandsFile} : new String[]{"figp", "-testxml", commandsFile};
            this.executeCommand(cmd, "Generate Figaro 0", true, true, false, true);
            if (fig0File.exists()) {
                this.findModelFromName(this.currentFile).setModelModify(false);
                this.isOpening = true;
                jEdit.openFile((View)this.view, (String)fig0FileName);
                this.isOpening = false;
                this.currentFile = fig0FileName;
                this.comboTree.setSelectedIndex(-1);
                switch (postTreatment) {
                    case 1: {
                        this.runFig0debug();
                        break;
                    }
                    case 2: {
                        this.runFigseq();
                        break;
                    }
                    case 3: {
                        this.runYams();
                        break;
                    }
                }
            } else {
                JOptionPane.showMessageDialog(this, "No file has been written");
            }
        } else {
            JOptionPane.showMessageDialog(this, "The commands file does not exist ! Abort.");
        }
    }

    private void runFig0debug() {
        if (this.currentFile == null) {
            JOptionPane.showMessageDialog(this, "Open a valid file first !");
            return;
        }
        if (this.findModelFromName(this.currentFile) == null && this.findKnowledgeBaseFromName(this.currentFile) == null && this.currentFile.endsWith(".fi")) {
            String figpPath = String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/Fig0Debug.exe";
            String[] cmd = this.isOSWindows() ? new String[]{figpPath, this.currentFile} : new String[]{"fig0debug", this.currentFile};
            this.executeCommand(cmd, "Run Fig0debug", false, false, false, true);
        } else if (this.findModelFromName(this.currentFile) != null) {
            GModel model = this.findModelFromName(this.currentFile);
            if (!(model.isModelModify() || model.getFigaro0Settings().getFileName().equals("") || model.getFigaro0Settings().getFileName().equals("fig0_temp.fi"))) {
                String filename = model.getFigaro0Settings().getFileName();
                File figaro0 = new File(filename);
                if (figaro0.exists()) {
                    Object[] options = new Object[]{"Ok", "Cancel"};
                    int choix = JOptionPane.showOptionDialog(this, "A figaro 0 file exists for the current model, load " + filename + " ?", "Use previous figaro 0 file ?", 2, 2, null, options, options[1]);
                    if (choix == 1) {
                        this.generateFig0(1);
                    } else {
                        String figpPath = String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/Fig0Debug.exe";
                        String[] cmd = this.isOSWindows() ? new String[]{figpPath, this.currentFile} : new String[]{"fig0debug", this.currentFile};
                        this.executeCommand(cmd, "Run Fig0debug", false, false, false, true);
                    }
                }
            } else {
                Object[] options = new Object[]{"Ok", "Cancel"};
                int choix = JOptionPane.showOptionDialog(this, "Generate a new figaro 0 file for the current model ?", "A model is selected", 2, 2, null, options, options[1]);
                if (choix == 1) {
                    return;
                }
                this.generateFig0(1);
            }
        } else {
            JOptionPane.showMessageDialog(this, "The current file is neither a figaro 0 file nor a model, please select a valid input");
        }
    }

    private void runFigseq() {
        if (this.currentFile == null) {
            JOptionPane.showMessageDialog(this, "Open a valid file first !");
            return;
        }
        String figPath = this.getPathConfiguration("FIGSEQ");
        if (figPath.equals("")) {
            return;
        }
        if (this.findModelFromName(this.currentFile) == null && this.findKnowledgeBaseFromName(this.currentFile) == null && this.currentFile.endsWith(".fi")) {
            String[] cmd = this.isOSWindows() ? new String[]{figPath, this.currentFile} : new String[]{figPath, this.currentFile};
            this.executeCommand(cmd, "Run Figseq", false, false, false, true);
        } else {
            GModel model = this.findModelFromName(this.currentFile);
            if (!(model.isModelModify() || model.getFigaro0Settings().getFileName().equals("") || model.getFigaro0Settings().getFileName().equals("fig0_temp.fi"))) {
                String filename = model.getFigaro0Settings().getFileName();
                File figaro0 = new File(filename);
                if (figaro0.exists()) {
                    Object[] options = new Object[]{"Ok", "Cancel"};
                    int choix = JOptionPane.showOptionDialog(this, "A figaro 0 file exists for the current model, load " + filename + " ?", "Use previous figaro 0 file ?", 2, 2, null, options, options[1]);
                    if (choix == 1) {
                        this.generateFig0(2);
                    } else {
                        String[] cmd = this.isOSWindows() ? new String[]{figPath, this.currentFile} : new String[]{figPath, this.currentFile};
                        this.executeCommand(cmd, "Run Figseq", false, false, false, true);
                    }
                }
            } else if (this.findModelFromName(this.currentFile) != null) {
                Object[] options = new Object[]{"Ok", "Cancel"};
                int choix = JOptionPane.showOptionDialog(this, "Generate a new figaro 0 file for the current model ?", "A model is selected", 2, 2, null, options, options[1]);
                if (choix == 1) {
                    return;
                }
                this.generateFig0(2);
            } else {
                JOptionPane.showMessageDialog(this, "The current file is neither a figaro 0 file nor a model, please select a valid input");
            }
        }
    }

    private void runYams() {
        if (this.currentFile == null) {
            JOptionPane.showMessageDialog(this, "Open a valid file first !");
            return;
        }
        String figPath = this.getPathConfiguration("YAMS");
        if (figPath.equals("")) {
            return;
        }
        if (this.findModelFromName(this.currentFile) == null && this.findKnowledgeBaseFromName(this.currentFile) == null && this.currentFile.endsWith(".fi")) {
            String[] cmd = this.isOSWindows() ? new String[]{figPath, this.currentFile} : new String[]{figPath, this.currentFile};
            this.executeCommand(cmd, "Run Yams", false, false, false, true);
        } else if (this.findModelFromName(this.currentFile) != null) {
            GModel model = this.findModelFromName(this.currentFile);
            if (!(model.isModelModify() || model.getFigaro0Settings().getFileName().equals("") || model.getFigaro0Settings().getFileName().equals("fig0_temp.fi"))) {
                String filename = model.getFigaro0Settings().getFileName();
                File figaro0 = new File(filename);
                if (figaro0.exists()) {
                    Object[] options = new Object[]{"Ok", "Cancel"};
                    int choix = JOptionPane.showOptionDialog(this, "A figaro 0 file exists for the current model, load " + filename + " ?", "Use previous figaro 0 file ?", 2, 2, null, options, options[1]);
                    if (choix == 1) {
                        this.generateFig0(3);
                    } else {
                        String[] cmd = this.isOSWindows() ? new String[]{figPath, this.currentFile} : new String[]{figPath, this.currentFile};
                        this.executeCommand(cmd, "Run Yams", false, false, false, true);
                    }
                }
            } else {
                Object[] options = new Object[]{"Ok", "Cancel"};
                int choix = JOptionPane.showOptionDialog(this, "Generate a new figaro 0 file for the current model ?", "A model is selected", 2, 2, null, options, options[1]);
                if (choix == 1) {
                    return;
                }
                this.generateFig0(3);
            }
        } else {
            JOptionPane.showMessageDialog(this, "The current file is neither a figaro 0 file nor a model, please select a valid input");
        }
    }

    private String getPathConfiguration(String Appl) {
        File figPathFile;
        String path = "";
        String path1 = "";
        if (!this.isOSWindows()) {
            File fileVisual;
            if (Appl.equals("FIGSEQ")) {
                JOptionPane.showMessageDialog(this, String.valueOf(Appl) + " not found");
                return "";
            }
            if (Appl.equals("YAMS") && (fileVisual = new File(path = "/usr/bin/yams-gui")).exists()) {
                return "yams-gui";
            }
            JOptionPane.showMessageDialog(this, String.valueOf(Appl) + " not found");
            return "";
        }
        if (Appl.equals("FIGSEQ")) {
            path = String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/FIGSEQ/figseq-gui_p.exe";
            File fileVisual = new File(path);
            if (fileVisual.exists()) {
                return path;
            }
            path = String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/FIGSEQ/figseq-gui.exe";
            fileVisual = new File(path);
            if (fileVisual.exists()) {
                return path;
            }
        } else if (Appl.equals("YAMS")) {
            path = String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/YAMS/yams-gui.exe";
            File fileVisual = new File(path);
            if (fileVisual.exists()) {
                return path;
            }
            path = String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/YAMS/MC_IHM.exe";
            fileVisual = new File(path);
            if (fileVisual.exists()) {
                return path;
            }
        }
        String userpath = String.valueOf(System.getenv("APPDATA")) + "\\EDF MRI TOOLS\\KB3Configuration.xml";
        String alluserpath = String.valueOf(System.getenv("ALLUSERSPROFILE")) + "\\EDF MRI TOOLS\\KB3Configuration.xml";
        File userp = new File(userpath);
        File alluserp = new File(alluserpath);
        Boolean foundPath = false;
        if (userp.exists() && !(path1 = this.getPathFromFile(userpath, Appl)).equals("") && (figPathFile = new File(path1)).exists()) {
            path = path1;
            foundPath = true;
        }
        if (!foundPath.booleanValue() && alluserp.exists()) {
            path = this.getPathFromFile(alluserpath, Appl);
            if (path.equals("")) {
                if (path1.equals("")) {
                    JOptionPane.showMessageDialog(this, String.valueOf(Appl) + " not found");
                } else {
                    JOptionPane.showMessageDialog(this, "Invalid path, " + Appl + " was not found at " + path1);
                }
                return "";
            }
            figPathFile = new File(path);
            if (!figPathFile.exists()) {
                JOptionPane.showMessageDialog(this, "Invalid path, " + Appl + " was not found at " + path);
                return "";
            }
        } else if (!foundPath.booleanValue()) {
            JOptionPane.showMessageDialog(this, "KB3Configuration.xml file missing");
        }
        return path;
    }

    private String getPathFromFile(String filename, String appl) {
        String path = "";
        SAXBuilder sxb = new SAXBuilder();
        try {
            Document document = sxb.build(new File(filename));
            Element root = document.getRootElement();
            List code = root.getChildren("code");
            for (Element e : code) {
                if (!e.getChildText("nom").equals(appl)) continue;
                path = e.getChildText("chemin_IHM");
            }
        }
        catch (Exception e) {
            System.out.println("Erreur lors du chargement du fichier suivant : " + path);
            JOptionPane.showMessageDialog(this, "An error occurs during the load of the file : " + path + " " + e.toString());
        }
        return path;
    }

    private void generateFaultTree() {
        if (this.modelsVector.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Open a Model first !");
        } else {
            GModel model = this.findModelFromName(this.currentFile);
            if (model != null) {
                GKnowledgeBase knowledgeBase = model.getKnowledgeBase();
                String knowledgeBaseFileName = knowledgeBase.getKnowledgeBaseName();
                DOMBuilder builder = new DOMBuilder();
                GObjectInformation info = new GObjectInformation();
                info.setLanguage(knowledgeBase.getKnowledgeBaseLanguage());
                if (this.isOSWindows()) {
                    info.setKnowledgeBasePath(knowledgeBaseFileName.substring(0, knowledgeBaseFileName.lastIndexOf("\\")));
                } else {
                    info.setKnowledgeBasePath(knowledgeBaseFileName.substring(0, knowledgeBaseFileName.lastIndexOf("/")));
                }
                GXMLLoader xmlLoader = new GXMLLoader(info.getLanguage());
                xmlLoader.loadXmlFile(knowledgeBaseFileName.substring(0, knowledgeBaseFileName.length() - 2).concat("bdc"));
                GWindow.setXmlLoader(xmlLoader);
                GXMLLoaderFigaro figaroLoader = new GXMLLoaderFigaro();
                figaroLoader.setXmlFile(builder.build(this.figTree.getGTree().getDocument()));
                GWindow.setFigaroLoader(figaroLoader);
                GWindowFaultTree window = new GWindowFaultTree(this, null, info, model);
                window.setVisible(true);
                window.setAlwaysOnTop(true);
            } else {
                JOptionPane.showMessageDialog(this, "The current File is not a model");
            }
        }
    }

    public void generateFT(String ftFileName) {
        File commands = new File(String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/figp_commands.xml");
        File ftFile = new File(ftFileName);
        if (commands.exists()) {
            String TempFile = "";
            TempFile = this.isOSWindows() ? String.valueOf(System.getenv("TMP")) + "\\faulttree_temp.xml" : String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/faulttree_temp.xml";
            if (ftFileName.equals(TempFile)) {
                ftFile.delete();
            }
            if (ftFile.exists()) {
                Object[] options = new Object[]{"Cancel", "Overwrite"};
                int choix = JOptionPane.showOptionDialog(this, "The output file " + ftFileName + " already exist, overwrite ?", "Figaro 0 file already exist", 2, 2, null, options, options[1]);
                if (choix == 0) {
                    return;
                }
                ftFile.delete();
            }
            String appli = String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/figp.exe";
            String commandsFile = String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/figp_commands.xml";
            String[] cmd = this.isOSWindows() ? new String[]{appli, "-testxml", commandsFile} : new String[]{"figp", "-testxml", commandsFile};
            this.executeCommand(cmd, "Generate FT", true, true, false, true);
            if (ftFile.exists()) {
                JOptionPane.showMessageDialog(this, "File : " + ftFileName + " has been written");
            } else {
                JOptionPane.showMessageDialog(this, "No file has been written");
            }
        } else {
            JOptionPane.showMessageDialog(this, "The commands file does not exist ! Abort.");
        }
    }

    private void saveToIniFile(String filePath, int type) throws IOException {
        String VFIniFilePath = "";
        String VFTempFilePath = "";
        String AppliDataPath = "";
        if (this.isOSWindows()) {
            AppliDataPath = System.getenv("AppData");
            VFIniFilePath = String.valueOf(AppliDataPath) + "\\EDF MRI TOOLS\\VisualFigaro.ini";
            VFTempFilePath = String.valueOf(AppliDataPath) + "\\EDF MRI TOOLS\\temp.ini";
        } else {
            AppliDataPath = jEdit.getJEditHome();
            VFIniFilePath = String.valueOf(AppliDataPath) + "/VisualFigaro/VisualFigaro.ini";
            VFTempFilePath = String.valueOf(AppliDataPath) + "/VisualFigaro/temp.ini";
        }
        File inputFile = new File(VFIniFilePath);
        BufferedReader br = new BufferedReader(new FileReader(inputFile));
        File outputFile = new File(VFTempFilePath);
        Charset charset = Charset.forName("UTF-8");
        OutputStreamWriter bw = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), charset);
        String kbPath = "";
        String modelPath = "";
        switch (type) {
            case 0: {
                kbPath = filePath;
                modelPath = this.getPrevModelFile();
                break;
            }
            case 1: {
                kbPath = this.getPrevKBFile();
                modelPath = filePath;
                break;
            }
        }
        bw.write("<PREV_PATH_KB>" + kbPath + "</PREV_PATH_KB>" + "\n");
        bw.write("<PREV_PATH_MD>" + modelPath + "</PREV_PATH_MD>" + "\n");
        br.close();
        ((Writer)bw).flush();
        ((Writer)bw).close();
        inputFile.delete();
        outputFile.renameTo(new File(VFIniFilePath));
    }

    private String getPrevKBFile() {
        String VFIniFilePath = "";
        String AppliDataPath = "";
        if (this.isOSWindows()) {
            AppliDataPath = System.getenv("AppData");
            VFIniFilePath = String.valueOf(AppliDataPath) + "\\EDF MRI TOOLS\\VisualFigaro.ini";
        } else {
            AppliDataPath = jEdit.getJEditHome();
            VFIniFilePath = String.valueOf(AppliDataPath) + "/VisualFigaro/VisualFigaro.ini";
        }
        String ligne = "";
        String result = "";
        File inputFile = new File(VFIniFilePath);
        if (!inputFile.getParentFile().exists() && !inputFile.getParentFile().mkdir()) {
            return result;
        }
        if (!inputFile.exists()) {
            try {
                inputFile.createNewFile();
                this.saveToIniFile("", -1);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputFile), "UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            while ((ligne = br.readLine()) != null) {
                if (!ligne.startsWith("<PREV_PATH_KB>")) continue;
                int end = ligne.lastIndexOf("</PREV_PATH_KB>");
                result = ligne.substring(14, end);
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public String getPrevModelFile() {
        String VFIniFilePath = "";
        String AppliDataPath = "";
        if (this.isOSWindows()) {
            AppliDataPath = System.getenv("AppData");
            VFIniFilePath = String.valueOf(AppliDataPath) + "\\EDF MRI TOOLS\\VisualFigaro.ini";
        } else {
            AppliDataPath = jEdit.getJEditHome();
            VFIniFilePath = String.valueOf(AppliDataPath) + "/VisualFigaro/VisualFigaro.ini";
        }
        String ligne = "";
        String result = "";
        File inputFile = new File(VFIniFilePath);
        if (!inputFile.getParentFile().exists() && !inputFile.getParentFile().mkdir()) {
            return result;
        }
        if (!inputFile.exists()) {
            try {
                inputFile.createNewFile();
                this.saveToIniFile("", -1);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputFile), "UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            while ((ligne = br.readLine()) != null) {
                if (!ligne.startsWith("<PREV_PATH_MD>")) continue;
                int end = ligne.lastIndexOf("</PREV_PATH_MD>");
                result = ligne.substring(14, end);
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private void closeKB() {
        this.currentFile = this.view.getBuffer().getPath();
        GKnowledgeBase knowledgeBase = this.findKnowledgeBaseFromName(this.currentFile);
        GModel model = this.findModelFromName(this.currentFile);
        if (knowledgeBase != null) {
            JMenuItem item = this.menuBar.getMenu(0).getItem(6);
            item.setText(this.currentFile);
            try {
                this.saveToIniFile(this.currentFile, 0);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Buffer save = this.view.getBuffer();
            this.comboTree.removeItem(this.currentFile);
            jEdit.closeBuffer((View)this.view, (Buffer)save);
            this.knowledgedBasesVector.remove(knowledgeBase);
        } else if (model != null) {
            Object[] options = new Object[]{"Close", "Cancel"};
            int choix = JOptionPane.showOptionDialog(this, "The current open file is a model, do you want to close it ?", "Current File not a Knowledge Base", 2, 2, null, options, options[1]);
            if (choix == 0) {
                this.closeModel();
            }
        } else {
            this.comboTree.setSelectedIndex(-1);
            jEdit.closeAllBuffers((View)this.view);
        }
        this.currentFile = this.view.getBuffer().getPath();
    }

    private void translateKB() throws IOException {
        if (this.findKnowledgeBaseFromName(this.currentFile) != null) {
            String[] cmd;
            String BdCPath = String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/TradBDC/";
            File tradKB = new File(String.valueOf(BdCPath) + "MotsClesBdCKB3V3.xml");
            if (!tradKB.exists()) {
                JOptionPane.showMessageDialog(this, "MotsClesBdCKB3V3.xml is missing");
                return;
            }
            Charset charset = Charset.forName("UTF-8");
            String transType = "fe";
            String destDir = "English\\";
            String origDir = "Francais\\";
            String currentFilePath = "";
            String destFilePath = "";
            String TransFileName = "";
            String xsdFileName = "bdceng.xsd";
            if (this.languageName.equals("English")) {
                transType = "ef";
                destDir = "Francais\\";
                origDir = "English\\";
                xsdFileName = "bdcfr.xsd";
            }
            int index = this.isOSWindows() ? this.currentFile.lastIndexOf("\\") : this.currentFile.lastIndexOf("/");
            currentFilePath = this.currentFile.substring(0, index);
            String currentFileName = this.currentFile.substring(index + 1);
            index = currentFileName.lastIndexOf(".");
            TransFileName = "Translation_" + currentFileName.substring(0, index) + ".xml";
            index = this.isOSWindows() ? currentFilePath.lastIndexOf("\\") : currentFilePath.lastIndexOf("/");
            if (!currentFilePath.substring(index + 1).equals(origDir.substring(0, origDir.length() - 1))) {
                JOptionPane.showMessageDialog(this, "Invalid source directory (neither '[...]\\Francais' nor '[...]\\English')");
                return;
            }
            currentFilePath = currentFilePath.substring(0, index + 1);
            destFilePath = String.valueOf(currentFilePath) + destDir;
            File destFile = new File(destFilePath);
            File xmlFile = new File(String.valueOf(currentFilePath) + TransFileName);
            if (!xmlFile.exists()) {
                xmlFile.createNewFile();
                OutputStreamWriter xw = new OutputStreamWriter((OutputStream)new FileOutputStream(xmlFile), charset);
                xw.write("<TRADUCTIONS_BDC>\n");
                xw.write(" <TRADUCTIONS_FIGARO></TRADUCTIONS_FIGARO>\n");
                xw.write(" <TRADUCTIONS_VALEURS_XML></TRADUCTIONS_VALEURS_XML>\n");
                xw.write("</TRADUCTIONS_BDC>\n");
                ((Writer)xw).close();
            }
            if (!destFile.exists()) {
                destFile.mkdir();
            }
            CopyFile.copy(new File(String.valueOf(currentFilePath) + origDir + "icons"), new File(String.valueOf(destFilePath) + "icons"), false);
            CopyFile.copyFile(new File(String.valueOf(BdCPath) + xsdFileName), new File(String.valueOf(destFilePath) + xsdFileName), true);
            if (this.isOSWindows()) {
                String prg = String.valueOf(BdCPath) + "TradBDC.exe";
                String kBFile = this.currentFile;
                String keyWordFile = String.valueOf(BdCPath) + "MotsClesBdCKB3V3.xml";
                String keyWordBdC = String.valueOf(currentFilePath) + TransFileName;
                String destKBFile = destFilePath;
                index = this.currentFile.lastIndexOf("\\");
                destKBFile = String.valueOf(destKBFile) + this.currentFile.substring(index + 1, this.currentFile.length());
                cmd = new String[]{prg, kBFile, "-lang", "en", "-tf", transType, "-tx", transType, "-tb", transType, "-ki", keyWordFile, "-bi", keyWordBdC, "-o", destKBFile};
            } else {
                String prg = String.valueOf(BdCPath) + "TradBDC.exe";
                String kBFile = this.currentFile;
                String keyWordFile = String.valueOf(BdCPath) + "MotsClesBdCKB3V3.xml";
                String keyWordBdC = String.valueOf(currentFilePath) + TransFileName;
                String destKBFile = destFilePath;
                index = this.currentFile.lastIndexOf("/");
                destKBFile = String.valueOf(destKBFile) + this.currentFile.substring(index + 1, this.currentFile.length());
                cmd = new String[]{prg, kBFile, "-lang", "en", "-tf", transType, "-tx", transType, "-tb", transType, "-ki", keyWordFile, "-bi", keyWordBdC, "-o", destKBFile};
            }
            this.executeCommand(cmd, "Run TradBDC", false, false, false, true);
        } else {
            JOptionPane.showMessageDialog(this, "The selected file is not a knowledge base");
        }
    }

    private void aboutVisualFigaro() {
        GWindowAbout window = new GWindowAbout(this);
        window.setVisible(true);
        window.setLocationRelativeTo(null);
    }

    private void editXMLFile() {
        block23: {
            int type = -1;
            if (this.findKnowledgeBaseFromName(this.currentFile) == null) {
                JOptionPane.showMessageDialog(this, "There is no opened Knowledge Base. Open or select one before editing XML.");
                return;
            }
            String bdcFilename = String.valueOf(this.currentFile.substring(0, this.currentFile.length() - 2)) + "bdc";
            File bdcFile = new File(bdcFilename);
            if (!bdcFile.exists()) {
                String phrase = "The BDC file associated with " + this.view.getBuffer().getName() + " does not exist.\nDo you want to create a file containing default information?";
                Object[] options = new Object[]{"Create Default File", "Start From Scratch", "Cancel"};
                type = JOptionPane.showOptionDialog((Component)this.getView(), phrase, "No BDC File", 1, 3, null, options, options[0]);
                String data = "";
                switch (type) {
                    case 0: {
                        String figpPath = String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/figp.exe";
                        String[] command = this.isOSWindows() ? new String[]{figpPath, this.currentFile, "-wse3"} : new String[]{"figp", this.currentFile, "-wse3"};
                        System.err.println("Command : " + command);
                        System.err.println("Avant");
                        data = this.executeServerWithResultIntoFile(command);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        return;
                    }
                }
                Charset charset = Charset.forName("ISO-8859-1");
                OutputStreamWriter writer = null;
                try {
                    try {
                        writer = new OutputStreamWriter((OutputStream)new FileOutputStream(bdcFile), charset);
                        writer.write(data);
                    }
                    catch (Exception e) {
                        System.err.println("VisualFigaro : VisualFigaro : BDC file cannot be created : " + e);
                        JOptionPane.showMessageDialog(this, "VisualFigaro : VisualFigaro : BDC file cannot be created : " + e);
                        if (writer != null) {
                            try {
                                writer.close();
                            }
                            catch (Exception e2) {
                                System.err.println("VisualFigaro : VisualFigaro : Exception while closing the BDC file : " + e2);
                            }
                        }
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Exception e) {
                            System.err.println("VisualFigaro : VisualFigaro : Exception while closing the BDC file : " + e);
                        }
                    }
                    throw throwable;
                }
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Exception e) {
                        System.err.println("VisualFigaro : VisualFigaro : Exception while closing the BDC file : " + e);
                    }
                }
            }
        }
        DOMBuilder builder = new DOMBuilder();
        GObjectInformation info = new GObjectInformation();
        info.setLanguage(this.findKnowledgeBaseFromName(this.currentFile).getKnowledgeBaseLanguage());
        if (this.isOSWindows()) {
            info.setKnowledgeBasePath(this.currentFile.substring(0, this.currentFile.lastIndexOf("\\")));
            System.err.println("Current File" + this.currentFile.substring(0, this.currentFile.lastIndexOf("\\")));
        } else {
            info.setKnowledgeBasePath(this.currentFile.substring(0, this.currentFile.lastIndexOf("/")));
            System.err.println("Current File" + this.currentFile.substring(0, this.currentFile.lastIndexOf("/")));
        }
        GXMLLoader xmlLoader = new GXMLLoader(info.getLanguage());
        xmlLoader.loadXmlFile(this.currentFile.substring(0, this.currentFile.length() - 2).concat("bdc"));
        GWindow.setXmlLoader(xmlLoader);
        GXMLLoaderFigaro figaroLoader = new GXMLLoaderFigaro();
        figaroLoader.setXmlFile(builder.build(this.figTree.getGTree().getDocument()));
        GWindow.setFigaroLoader(figaroLoader);
        GWindowMain mainWindow = new GWindowMain(this, null, info, -1);
        mainWindow.setVisible(true);
        mainWindow.setAlwaysOnTop(true);
    }

    private String findKnowledgeBaseLanguage(String path) {
        File directory = new File(path);
        if (!directory.exists() || !directory.isDirectory()) {
            return "";
        }
        String[] filesName = directory.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String filename) {
                return filename.toLowerCase().endsWith(".xsd");
            }
        });
        if (filesName.length <= 0 || filesName.length > 1) {
            return "";
        }
        GXMLLoaderDefaultFiles xl = new GXMLLoaderDefaultFiles();
        return xl.getLanguageForSchemaFile(filesName[0]);
    }

    private String findModelLanguage(GModel model) {
        return model.getModelLanguage().getLanguage();
    }

    private boolean checkIntegrity(String path) {
        File iconsDirectory;
        String[] schemaFilesName;
        boolean errorOccured = false;
        String errorMessage = "";
        File directory = new File(path);
        if (!directory.exists() || !directory.isDirectory()) {
            errorMessage = String.valueOf(errorMessage) + "The Knowledge Base directory does not exist.\n";
            return false;
        }
        String[] figaroFilesName = directory.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String filename) {
                return filename.toLowerCase().endsWith(".fi");
            }
        });
        String[] bdcFilesName = directory.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String filename) {
                return filename.toLowerCase().endsWith(".bdc");
            }
        });
        if (bdcFilesName.length > 0 && !bdcFilesName[0].substring(0, bdcFilesName[0].indexOf(".bdc")).equals(figaroFilesName[0].substring(0, figaroFilesName[0].indexOf(".fi")))) {
            errorMessage = String.valueOf(errorMessage) + "The Figaro file and the BDC file don't have the same name.\n";
            errorOccured = true;
        }
        if ((schemaFilesName = directory.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String filename) {
                return filename.toLowerCase().endsWith(".xsd");
            }
        })).length <= 0 || schemaFilesName.length > 1) {
            errorMessage = String.valueOf(errorMessage) + "There is no or more than one schema file in the Knowledge Base.\n";
            errorOccured = true;
        }
        if (!(iconsDirectory = new File(String.valueOf(directory.getAbsolutePath()) + "/icons")).exists()) {
            errorMessage = String.valueOf(errorMessage) + "The icons folder does not exist.\n";
            errorOccured = true;
        }
        if (errorOccured) {
            JOptionPane.showMessageDialog(this, errorMessage, "KB loading error", 0);
        }
        return !errorOccured;
    }

    public Vector<GCell> getTypes() {
        if (this.figTree == null) {
            return null;
        }
        return this.figTree.getTypes();
    }

    public GTree getGTree() {
        return this.figTree.getGTree();
    }

    public String getCurrentSelectedTree() {
        return this.comboTree.getSelectedItem().toString();
    }

    public String getCurrentFile() {
        return this.currentFile;
    }

    public View getView() {
        return this.view;
    }

    public GLanguage getLanguage() {
        GKnowledgeBase knowledgeBase = this.findKnowledgeBaseFromName(this.currentFile);
        if (knowledgeBase == null) {
            return null;
        }
        return knowledgeBase.getKnowledgeBaseLanguage();
    }

    private GKnowledgeBase findKnowledgeBaseFromName(String name) {
        for (GKnowledgeBase knowledgeBase : this.knowledgedBasesVector) {
            if (!knowledgeBase.getKnowledgeBaseName().equals(name)) continue;
            return knowledgeBase;
        }
        return null;
    }

    private GModel findModelFromName(String name) {
        for (GModel model : this.modelsVector) {
            if (!model.getModelName().equals(name)) continue;
            return model;
        }
        return null;
    }

    public String getTextFromFile(File file) {
        String result = "";
        if (!file.exists()) {
            return result;
        }
        try {
            int readCharacter;
            FileReader reader = new FileReader(file);
            do {
                if ((readCharacter = reader.read()) == -1) continue;
                result = String.valueOf(result) + (char)readCharacter;
            } while (readCharacter != -1);
            reader.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("Visual Figaro : VisualFigaro : The file cannot be written : " + e);
        }
        catch (IOException e) {
            System.err.println("Visual Figaro : VisualFigaro : The file cannot be written : " + e);
        }
        return result;
    }

    private boolean precompileXML() {
        String pathToTempFileXml;
        String pathToTempFile;
        block30: {
            pathToTempFile = "";
            pathToTempFileXml = "";
            if (this.isOSWindows()) {
                pathToTempFile = String.valueOf(System.getenv("TMP")) + "\\test1.fi";
                pathToTempFileXml = String.valueOf(System.getenv("TMP")) + "\\test1_fi.xml";
            } else {
                pathToTempFile = String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/test1.fi";
                pathToTempFileXml = String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/test1_fi.xml";
            }
            File tempFile = new File(pathToTempFile);
            if (tempFile.exists()) {
                System.err.println("Exist");
            } else {
                System.err.println("Not exist");
            }
            GModel model = this.findModelFromName(this.currentFile);
            String fileName = this.currentFile;
            if (model != null) {
                fileName = model.getKnowledgeBase().getKnowledgeBaseName();
            }
            System.err.println("Voici le fichier a traiter : " + fileName);
            System.err.println("Voici la file dans le buffer : " + this.view.getBuffer().getDirectory() + this.view.getBuffer().getName());
            if (this.currentFile.equals(String.valueOf(this.view.getBuffer().getDirectory()) + this.view.getBuffer().getName())) {
                FileChannel inputFile = null;
                AbstractInterruptibleChannel outputFile = null;
                try {
                    try {
                        inputFile = new FileInputStream(fileName).getChannel();
                        outputFile = new FileOutputStream(pathToTempFile).getChannel();
                        inputFile.transferTo(0L, inputFile.size(), (WritableByteChannel)((Object)outputFile));
                    }
                    catch (Exception e) {
                        System.err.println("VisualFigaro : VisualFigaro : Exception during the transfer of file : " + fileName + " : " + e);
                        if (inputFile != null) {
                            try {
                                inputFile.close();
                            }
                            catch (Exception ex) {
                                System.err.println("VisualFigaro : VisualFigaro : Exception while closing the file : " + fileName + " : " + ex);
                            }
                        }
                        if (outputFile != null) {
                            try {
                                outputFile.close();
                            }
                            catch (Exception ex) {
                                System.err.println("VisualFigaro : VisualFigaro : Exception while closing the file : " + pathToTempFile);
                            }
                        }
                        break block30;
                    }
                }
                catch (Throwable throwable) {
                    if (inputFile != null) {
                        try {
                            inputFile.close();
                        }
                        catch (Exception ex) {
                            System.err.println("VisualFigaro : VisualFigaro : Exception while closing the file : " + fileName + " : " + ex);
                        }
                    }
                    if (outputFile != null) {
                        try {
                            outputFile.close();
                        }
                        catch (Exception ex) {
                            System.err.println("VisualFigaro : VisualFigaro : Exception while closing the file : " + pathToTempFile);
                        }
                    }
                    throw throwable;
                }
                if (inputFile != null) {
                    try {
                        inputFile.close();
                    }
                    catch (Exception ex) {
                        System.err.println("VisualFigaro : VisualFigaro : Exception while closing the file : " + fileName + " : " + ex);
                    }
                }
                if (outputFile != null) {
                    try {
                        outputFile.close();
                    }
                    catch (Exception ex) {
                        System.err.println("VisualFigaro : VisualFigaro : Exception while closing the file : " + pathToTempFile);
                    }
                }
            } else {
                return false;
            }
        }
        String[] command = this.isOSWindows() ? new String[]{String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/figp.exe", pathToTempFile, "-wXe3", pathToTempFileXml} : new String[]{"figp", pathToTempFile, "-wXe3", pathToTempFileXml};
        this.executeServerWithResultIntoFile(command);
        return true;
    }

    /*
     * Exception decompiling
     */
    private String executeServerWithResultIntoFile(String[] command) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void focusOnDefaultComponent() {
    }

    public void handleMessage(EBMessage message) {
        System.err.println("Handle message");
        if (this.isOpening) {
            System.err.println("Handle message cancel");
            return;
        }
        System.err.println("Handle message continue");
        if (message instanceof EditPaneUpdate && ((EditPaneUpdate)message).getWhat().equals(EditPaneUpdate.BUFFER_CHANGED)) {
            this.currentFile = ((EditPane)message.getSource()).getBuffer().getPath();
            String directory = ((EditPane)message.getSource()).getBuffer().getDirectory();
            System.err.println("buffer changed : " + this.currentFile);
            GKnowledgeBase knowledgeBase = this.findKnowledgeBaseFromName(this.currentFile);
            GModel model = this.findModelFromName(this.currentFile);
            if (knowledgeBase != null || model != null) {
                this.comboTree.setSelectedItem(this.currentFile);
            } else {
                this.comboTree.setSelectedIndex(-1);
            }
            this.languageName = model != null ? this.findModelLanguage(model) : this.findKnowledgeBaseLanguage(directory);
            GLanguage language = new GLanguage();
            language.setLanguage(this.languageName);
        }
        if (message instanceof BufferUpdate) {
            if (((BufferUpdate)message).getWhat().equals(BufferUpdate.CLOSED)) {
                System.err.println("CLOSED");
                GKnowledgeBase knowledgeBase = this.findKnowledgeBaseFromName(((Buffer)message.getSource()).getPath());
                if (knowledgeBase != null) {
                    this.knowledgedBasesVector.remove(knowledgeBase);
                    this.comboTree.removeItem(knowledgeBase.getKnowledgeBaseName());
                } else {
                    GModel model = this.findModelFromName(((Buffer)message.getSource()).getPath());
                    if (model != null) {
                        this.modelsVector.remove(model);
                        this.comboTree.removeItem(model.getModelName());
                    }
                }
            }
            if (((BufferUpdate)message).getWhat().equals(BufferUpdate.CREATED)) {
                this.currentFile = ((Buffer)message.getSource()).getPath();
                System.err.println("CREATED : " + this.currentFile);
            }
            if (((BufferUpdate)message).getWhat().equals(BufferUpdate.SAVED)) {
                System.err.println("SAVED : " + this.currentFile);
                if (this.findKnowledgeBaseFromName(this.currentFile) != null) {
                    for (GModel m : this.modelsVector) {
                        if (!m.getKnowledgeBase().getKnowledgeBaseName().equals(this.currentFile)) continue;
                        m.setKBModify(true);
                    }
                }
                if (this.findModelFromName(this.currentFile) != null) {
                    this.findModelFromName(this.currentFile).setModelModify(true);
                }
            }
        }
    }

    public void setIconsUpToDate() {
        File bdcFile = new File(String.valueOf(this.currentFile.substring(0, this.currentFile.length() - 2)) + "bdc");
        if (!bdcFile.exists()) {
            return;
        }
        Hashtable<String, String> typeIconPathTable = new Hashtable<String, String>();
        Vector<String> typesName = new Vector<String>();
        Vector<GCell> types = this.figTree.getTypes();
        for (GCell c : types) {
            if (c.getChild(0) == null || c.getChild(0).getChild(0) == null) continue;
            typesName.add((String)c.getChild(0).getChild(0).getValue(1));
        }
        GXMLLoader xl = new GXMLLoader(null);
        Element root = xl.loadXmlFileJDOM(String.valueOf(this.currentFile.substring(0, this.currentFile.length() - 2)) + "bdc").getRootElement();
        GKnowledgeBase knowledgeBase = this.findKnowledgeBaseFromName(this.currentFile);
        Vector<Element> varianteGraphiqueDefautVect = xl.findElementWithSubBalise(root, 2, knowledgeBase.getKnowledgeBaseLanguage().getBDCTranslation("VARIANTE_GRAPHIQUE_DEFAUT"), knowledgeBase.getKnowledgeBaseLanguage().getBDCTranslation("ICONE"));
        if (this.isOSWindows()) {
            for (Element e : varianteGraphiqueDefautVect) {
                if (e.getChild(knowledgeBase.getKnowledgeBaseLanguage().getBDCTranslation("ICONE")).getChild(knowledgeBase.getKnowledgeBaseLanguage().getBDCTranslation("FICHIER")) == null) continue;
                typeIconPathTable.put(((Element)e.getParent()).getChildText(knowledgeBase.getKnowledgeBaseLanguage().getBDCTranslation("NOM")), String.valueOf(this.view.getBuffer().getDirectory()) + "icons\\" + e.getChild(knowledgeBase.getKnowledgeBaseLanguage().getBDCTranslation("ICONE")).getChildText(knowledgeBase.getKnowledgeBaseLanguage().getBDCTranslation("FICHIER")) + ".ico");
            }
        } else {
            for (Element e : varianteGraphiqueDefautVect) {
                if (e.getChild(knowledgeBase.getKnowledgeBaseLanguage().getBDCTranslation("ICONE")).getChild(knowledgeBase.getKnowledgeBaseLanguage().getBDCTranslation("FICHIER")) == null) continue;
                typeIconPathTable.put(((Element)e.getParent()).getChildText(knowledgeBase.getKnowledgeBaseLanguage().getBDCTranslation("NOM")), String.valueOf(this.view.getBuffer().getDirectory()) + "icons/" + e.getChild(knowledgeBase.getKnowledgeBaseLanguage().getBDCTranslation("ICONE")).getChildText(knowledgeBase.getKnowledgeBaseLanguage().getBDCTranslation("FICHIER")) + ".ico");
            }
        }
        if (knowledgeBase == null) {
            return;
        }
        knowledgeBase.setTypeIconPathTable(typeIconPathTable);
    }

    public String getIcon(String type) {
        GModel model;
        GKnowledgeBase knowledgeBase = this.findKnowledgeBaseFromName(this.currentFile);
        if (knowledgeBase == null && (model = this.findModelFromName(this.currentFile)) != null) {
            knowledgeBase = model.getKnowledgeBase();
        }
        if (knowledgeBase == null) {
            return null;
        }
        if (knowledgeBase.getTypeIconPathTable() != null) {
            return knowledgeBase.getTypeIconPathTable().get(type);
        }
        return null;
    }

    public void repaintFigTree() {
        this.figTree.repaint();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        EditBus.addToBus((EBComponent)this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        EditBus.removeFromBus((EBComponent)this);
    }
}

