/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.lang.reflect.InvocationTargetException;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.bsh.BshClassManager;
import org.gjt.sp.jedit.bsh.BshMethod;
import org.gjt.sp.jedit.bsh.CallStack;
import org.gjt.sp.jedit.bsh.Interpreter;
import org.gjt.sp.jedit.bsh.NameSpace;
import org.gjt.sp.jedit.bsh.Primitive;
import org.gjt.sp.jedit.bsh.TargetError;
import org.gjt.sp.jedit.bsh.UtilEvalError;
import org.gjt.sp.jedit.bsh.classpath.ClassManagerImpl;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.util.Log;

public abstract class BeanShellFacade<T> {
    protected NameSpace global;
    protected BshClassManager classManager = new ClassManagerImpl();
    private static Interpreter interpForMethods;
    private static final Object[] NO_ARGS;

    protected BeanShellFacade() {
        this.global = new NameSpace(this.classManager, "jEdit embedded BeanShell interpreter");
        interpForMethods = BeanShellFacade.createInterpreter(this.global);
        this.init();
    }

    protected void init() {
        this.global.importPackage("org.gjt.sp.jedit");
        this.global.importPackage("org.gjt.sp.jedit.buffer");
        this.global.importPackage("org.gjt.sp.jedit.syntax");
        this.global.importPackage("org.gjt.sp.jedit.textarea");
        this.global.importPackage("org.gjt.sp.util");
    }

    public void evalSelection(T t, TextArea textArea) {
        String string = textArea.getSelectedText();
        if (string == null) {
            textArea.getToolkit().beep();
            return;
        }
        Object object = this.eval(t, this.global, string);
        if (object != null) {
            textArea.setSelectedText(object.toString());
        }
    }

    public Object eval(T t, String string) {
        return this.eval(t, this.global, string);
    }

    public Object eval(T t, NameSpace nameSpace, String string) {
        try {
            return this._eval(t, nameSpace, string);
        }
        catch (Throwable throwable) {
            Log.log(9, BeanShellFacade.class, throwable);
            this.handleException(t, null, throwable);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object _eval(T t, NameSpace nameSpace, String string) throws Exception {
        Interpreter interpreter = BeanShellFacade.createInterpreter(nameSpace);
        try {
            this.setupDefaultVariables(nameSpace, t);
            if (Debug.BEANSHELL_DEBUG) {
                Log.log(1, BeanShellFacade.class, string);
            }
            Object object = interpreter.eval(string);
            return object;
        }
        catch (Exception exception) {
            BeanShellFacade.unwrapException(exception);
            Object var6_8 = null;
            return var6_8;
        }
        finally {
            try {
                this.resetDefaultVariables(nameSpace);
            }
            catch (UtilEvalError utilEvalError) {}
        }
    }

    public BshMethod cacheBlock(String string, String string2, boolean bl) throws Exception {
        NameSpace nameSpace = new NameSpace(this.global, "__internal_" + string);
        String string3 = "__runCachedMethod";
        if (bl) {
            this._eval(null, nameSpace, string3 + "(ns) {\nthis.callstack.set(0,ns);\n" + string2 + "\n}");
            return nameSpace.getMethod(string3, new Class[]{NameSpace.class});
        }
        this._eval(null, nameSpace, string3 + "() {\n" + string2 + "\n}");
        return nameSpace.getMethod(string3, new Class[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object runCachedBlock(BshMethod bshMethod, T t, NameSpace nameSpace) throws Exception {
        boolean bl;
        if (nameSpace == null) {
            bl = false;
            nameSpace = this.global;
        } else {
            bl = true;
        }
        try {
            Object[] objectArray;
            this.setupDefaultVariables(nameSpace, t);
            if (bl) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = nameSpace;
            } else {
                objectArray = NO_ARGS;
            }
            Object object = bshMethod.invoke(objectArray, interpForMethods, new CallStack(), null);
            if (object instanceof Primitive) {
                if (object == Primitive.VOID) {
                    Object var6_7 = null;
                    return var6_7;
                }
                Object object2 = ((Primitive)object).getValue();
                return object2;
            }
            Object object3 = object;
            return object3;
        }
        catch (Exception exception) {
            BeanShellFacade.unwrapException(exception);
            Object var6_10 = null;
            return var6_10;
        }
        finally {
            this.resetDefaultVariables(nameSpace);
        }
    }

    public NameSpace getNameSpace() {
        return this.global;
    }

    void resetClassManager() {
        this.classManager.reset();
    }

    protected void setVariable(NameSpace nameSpace, String string, Object object) throws UtilEvalError {
        if (nameSpace.getVariable(string) == Primitive.VOID) {
            nameSpace.setVariable(string, object, false);
        }
    }

    protected abstract void setupDefaultVariables(NameSpace var1, T var2) throws UtilEvalError;

    protected abstract void resetDefaultVariables(NameSpace var1) throws UtilEvalError;

    protected abstract void handleException(T var1, String var2, Throwable var3);

    protected static Interpreter createInterpreter(NameSpace nameSpace) {
        return new Interpreter(null, System.out, System.err, false, nameSpace);
    }

    protected static void unwrapException(Exception exception) throws Exception {
        Throwable throwable;
        if (exception instanceof TargetError) {
            throwable = ((TargetError)exception).getTarget();
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
        }
        if (exception instanceof InvocationTargetException) {
            throwable = ((InvocationTargetException)exception).getTargetException();
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
        }
        throw exception;
    }

    static {
        NO_ARGS = new Object[0];
    }
}

