/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.gjt.sp.jedit.io.FileVFS;
import org.gjt.sp.jedit.io.VFSFile;

public class ListVFSFileTransferable
implements Transferable {
    public static final DataFlavor jEditFileList = new DataFlavor(List.class, "application/x-java-jEdit-list-vfsfile");
    public static final DataFlavor[] supported = new DataFlavor[]{jEditFileList, DataFlavor.stringFlavor, DataFlavor.javaFileListFlavor};
    private final List<VFSFile> files;

    public ListVFSFileTransferable(VFSFile[] vFSFileArray) {
        this.files = Collections.unmodifiableList(Arrays.asList(vFSFileArray));
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return supported;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return jEditFileList.equals(dataFlavor) || DataFlavor.stringFlavor.equals(dataFlavor);
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (jEditFileList.equals(dataFlavor)) {
            return this.files;
        }
        if (DataFlavor.stringFlavor.equals(dataFlavor)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.files.size(); ++i) {
                VFSFile vFSFile = this.files.get(i);
                if (i != 0) {
                    stringBuilder.append('\n');
                }
                stringBuilder.append(vFSFile);
            }
            return stringBuilder.toString();
        }
        if (DataFlavor.javaFileListFlavor.equals(dataFlavor)) {
            ArrayList<File> arrayList = new ArrayList<File>(this.files.size());
            for (VFSFile vFSFile : this.files) {
                if (!(vFSFile.getVFS() instanceof FileVFS)) continue;
                arrayList.add(new File(vFSFile.getPath()));
            }
            return arrayList;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }
}

