/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.io.FavoritesVFS;
import org.gjt.sp.jedit.io.FileVFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.StandardUtilities;

public class FilePropertiesDialog
extends EnhancedDialog {
    private final VFSBrowser browser;
    private final VFSFile[] selectedFiles;
    private final VFSFile local;
    private JButton okButton;
    private JButton cancelButton;
    private JTextField nameTextField;
    private JLabel infoIcon;
    private JCheckBox readable;
    private JCheckBox write;

    public FilePropertiesDialog(View view, VFSBrowser vFSBrowser, VFSFile[] vFSFileArray) {
        super(view, jEdit.getProperty("vfs.browser.properties.title"), true);
        GUIUtilities.loadGeometry(this, "propdialog");
        this.browser = vFSBrowser;
        this.selectedFiles = vFSFileArray.length > 0 ? vFSFileArray : vFSBrowser.getSelectedFiles();
        this.local = this.selectedFiles[0];
        this.createAndShowGUI();
    }

    public void addComponentsToPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(12, 5, 0, 5));
        this.setContentPane(jPanel);
        if (this.selectedFiles.length == 1) {
            jPanel.add("North", this.createNorthPanel());
            jPanel.add("Center", this.createCenterPanel());
            jPanel.add("South", this.createSouthPanel());
        } else if (this.selectedFiles.length > 1) {
            jPanel.add("North", this.createNorthPanelAll());
            jPanel.add("Center", this.createCenterPanelAll());
            jPanel.add("South", this.createSouthPanelAll());
        }
    }

    public JPanel createNorthPanelAll() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.infoIcon = new JLabel();
        this.infoIcon.setIcon(UIManager.getIcon("OptionPane.informationIcon"));
        jPanel.add("West", this.infoIcon);
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.selectedFiles.length; ++i) {
            if (this.selectedFiles[i].getType() == 1) {
                ++n2;
                continue;
            }
            if (this.selectedFiles[i].getType() != 0) continue;
            ++n;
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JLabel(jEdit.getProperty("fileprop.selectedFiles") + ": " + n + ", " + jEdit.getProperty("fileprop.selectedDirectories") + ": " + n2));
        jPanel.add("Center", jPanel2);
        jPanel.add("South", new JPanel());
        return jPanel;
    }

    public JPanel createCenterPanelAll() {
        Object object;
        long l = 0L;
        JPanel jPanel = new JPanel(new BorderLayout());
        for (int i = 0; i < this.selectedFiles.length; ++i) {
            if (this.selectedFiles[i].getType() == 1) {
                object = new File(this.selectedFiles[i].getPath());
                l += IOUtilities.fileLength((File)object);
                continue;
            }
            if (this.selectedFiles[i].getType() != 0) continue;
            l += this.selectedFiles[i].getLength();
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 1));
        object = this.local.getPath();
        object = OperatingSystem.isWindows() || OperatingSystem.isWindows9x() || OperatingSystem.isWindowsNT() ? ((String)object).substring(0, ((String)object).lastIndexOf(92)) : ((String)object).substring(0, ((String)object).lastIndexOf(47));
        jPanel2.add(new JLabel(jEdit.getProperty("fileprop.path") + ": " + (String)object));
        jPanel2.add(new JLabel(jEdit.getProperty("fileprop.size") + ": " + StandardUtilities.formatFileSize(l)));
        Border border = BorderFactory.createEtchedBorder();
        jPanel2.setBorder(BorderFactory.createTitledBorder(border, jEdit.getProperty("fileprop.properties")));
        jPanel.add("Center", jPanel2);
        return jPanel;
    }

    public JPanel createSouthPanelAll() {
        ButtonActionHandler buttonActionHandler = new ButtonActionHandler();
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        this.okButton = new JButton(jEdit.getProperty("fileprop.okBtn"));
        jPanel2.add(this.okButton);
        this.okButton.addActionListener(buttonActionHandler);
        this.cancelButton = new JButton(jEdit.getProperty("fileprop.cancelBtn"));
        jPanel2.add(this.cancelButton);
        this.cancelButton.addActionListener(buttonActionHandler);
        jPanel.add("East", jPanel2);
        return jPanel;
    }

    public JPanel createNorthPanel() {
        String string;
        JPanel jPanel = new JPanel(new BorderLayout());
        this.infoIcon = new JLabel();
        this.infoIcon.setIcon(UIManager.getIcon("OptionPane.informationIcon"));
        jPanel.add("West", this.infoIcon);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JLabel(jEdit.getProperty("fileprop.name") + ": "));
        if (this.local instanceof FavoritesVFS.Favorite) {
            FavoritesVFS.Favorite favorite = (FavoritesVFS.Favorite)this.local;
            string = favorite.getLabel();
        } else {
            string = this.local.getName();
        }
        this.nameTextField = new JTextField(string, 20);
        if ((this.local.getVFS().getCapabilities() & 0x10) == 0) {
            this.nameTextField.setEditable(false);
        }
        jPanel2.add(this.nameTextField);
        jPanel.add("Center", jPanel2);
        jPanel.add("South", new JPanel());
        return jPanel;
    }

    public JPanel createCenterPanel() {
        Object object;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(4, 1));
        jPanel2.add(new JLabel(jEdit.getProperty("fileprop.name") + ": " + this.local.getName()));
        jPanel2.add(new JLabel(jEdit.getProperty("fileprop.path") + ": " + this.local.getPath()));
        if (this.local instanceof FileVFS.LocalFile) {
            jPanel2.add(new JLabel(jEdit.getProperty("fileprop.lastmod") + ": " + simpleDateFormat.format(new Date(((FileVFS.LocalFile)this.local).getModified()))));
        }
        if (this.local.getType() == 1) {
            object = new File(this.local.getPath());
            jPanel2.add(new JLabel(jEdit.getProperty("fileprop.size") + ": " + StandardUtilities.formatFileSize(IOUtilities.fileLength((File)object))));
        } else {
            jPanel2.add(new JLabel(jEdit.getProperty("fileprop.size") + ": " + StandardUtilities.formatFileSize(this.local.getLength())));
        }
        object = BorderFactory.createEtchedBorder();
        jPanel2.setBorder(BorderFactory.createTitledBorder((Border)object, jEdit.getProperty("fileprop.properties")));
        jPanel.add("Center", jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(1, 2));
        this.readable = new JCheckBox(jEdit.getProperty("fileprop.readable"));
        this.readable.setSelected(this.local.isReadable());
        this.readable.setEnabled(false);
        jPanel3.add(this.readable);
        this.write = new JCheckBox(jEdit.getProperty("fileprop.writeable"));
        this.write.setSelected(this.local.isWriteable());
        this.write.setEnabled(false);
        jPanel3.add(this.write);
        jPanel3.setBorder(BorderFactory.createTitledBorder((Border)object, jEdit.getProperty("fileprop.attribute")));
        jPanel.add("South", jPanel3);
        return jPanel;
    }

    public JPanel createSouthPanel() {
        ButtonActionHandler buttonActionHandler = new ButtonActionHandler();
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        this.okButton = new JButton(jEdit.getProperty("fileprop.okBtn"));
        jPanel2.add(this.okButton);
        this.okButton.addActionListener(buttonActionHandler);
        this.cancelButton = new JButton(jEdit.getProperty("fileprop.cancelBtn"));
        jPanel2.add(this.cancelButton);
        this.cancelButton.addActionListener(buttonActionHandler);
        jPanel.add("East", jPanel2);
        return jPanel;
    }

    @Override
    public void ok() {
        VFSFile vFSFile;
        if (this.nameTextField != null && ((vFSFile = this.browser.getSelectedFiles()[0]).getVFS().getCapabilities() & 0x10) != 0) {
            this.browser.rename(vFSFile, this.nameTextField.getText());
        }
        GUIUtilities.saveGeometry(this, "propdialog");
        this.setVisible(false);
    }

    @Override
    public void cancel() {
        GUIUtilities.saveGeometry(this, "propdialog");
        this.setVisible(false);
    }

    private void createAndShowGUI() {
        this.addComponentsToPane();
        this.pack();
        this.setDefaultCloseOperation(2);
        this.setFocusable(true);
        this.toFront();
        this.requestFocus();
        this.setResizable(false);
        this.setVisible(true);
    }

    private class ButtonActionHandler
    implements ActionListener {
        private ButtonActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == FilePropertiesDialog.this.okButton) {
                FilePropertiesDialog.this.ok();
            } else if (object == FilePropertiesDialog.this.cancelButton) {
                FilePropertiesDialog.this.cancel();
            }
        }
    }
}

