/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.MouseInputAdapter;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.gui.HistoryText;

public class HistoryTextField
extends JTextField {
    private HistoryText controller = new HistoryText(this, null){

        @Override
        public void fireActionPerformed() {
            HistoryTextField.this.fireActionPerformed();
        }
    };
    private boolean enterAddsToHistory;
    private boolean selectAllOnFocus;

    public HistoryTextField() {
        this(null);
    }

    public HistoryTextField(String string) {
        this(string, false, true);
    }

    public HistoryTextField(String string, boolean bl) {
        this(string, bl, true);
    }

    public HistoryTextField(String string, boolean bl, boolean bl2) {
        super(4);
        this.setModel(string);
        MouseHandler mouseHandler = new MouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
        this.setInstantPopups(bl);
        this.setEnterAddsToHistory(bl2);
    }

    public void setInstantPopups(boolean bl) {
        this.controller.setInstantPopups(bl);
    }

    public boolean getInstantPopups() {
        return this.controller.getInstantPopups();
    }

    public void setEnterAddsToHistory(boolean bl) {
        this.enterAddsToHistory = bl;
    }

    public boolean setEnterAddsToHistory() {
        return this.enterAddsToHistory;
    }

    public void setSelectAllOnFocus(boolean bl) {
        this.selectAllOnFocus = bl;
    }

    public boolean setSelectAllOnFocus() {
        return this.selectAllOnFocus;
    }

    public HistoryModel getModel() {
        return this.controller.getModel();
    }

    public void setModel(String string) {
        this.controller.setModel(string);
        if (string != null) {
            this.setBorder(new CompoundBorder(this.getBorder(), new HistoryBorder()));
        }
        this.repaint();
    }

    public void addCurrentToHistory() {
        this.controller.addCurrentToHistory();
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        this.controller.setIndex(-1);
    }

    @Override
    public void fireActionPerformed() {
        super.fireActionPerformed();
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (keyEvent.getID() == 401) {
            switch (keyEvent.getKeyCode()) {
                case 10: {
                    if (this.enterAddsToHistory) {
                        this.addCurrentToHistory();
                    }
                    if (keyEvent.getModifiers() != 0) break;
                    this.fireActionPerformed();
                    keyEvent.consume();
                    break;
                }
                case 38: {
                    if (keyEvent.isShiftDown()) {
                        this.controller.doBackwardSearch();
                    } else {
                        this.controller.historyPrevious();
                    }
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    if (keyEvent.isShiftDown()) {
                        this.controller.doForwardSearch();
                    } else if (keyEvent.isAltDown()) {
                        this.controller.showPopupMenu(keyEvent.isShiftDown());
                    } else {
                        this.controller.historyNext();
                    }
                    keyEvent.consume();
                    break;
                }
                case 9: {
                    if (!keyEvent.isControlDown()) break;
                    this.controller.doBackwardSearch();
                    keyEvent.consume();
                }
            }
        }
        if (!keyEvent.isConsumed()) {
            super.processKeyEvent(keyEvent);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        switch (mouseEvent.getID()) {
            case 501: {
                Border border = this.getBorder();
                Insets insets = border.getBorderInsets(this);
                if (mouseEvent.getX() >= this.getWidth() - insets.right || GUIUtilities.isPopupTrigger(mouseEvent)) {
                    this.controller.showPopupMenu(mouseEvent.isShiftDown());
                    break;
                }
                super.processMouseEvent(mouseEvent);
                break;
            }
            case 505: {
                this.setCursor(Cursor.getDefaultCursor());
                super.processMouseEvent(mouseEvent);
                break;
            }
            default: {
                super.processMouseEvent(mouseEvent);
            }
        }
    }

    static class HistoryBorder
    extends AbstractBorder {
        static final int WIDTH = 16;

        HistoryBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n + n3 - 16, n2 - 1);
            int n5 = 8;
            int n6 = n4 / 2;
            graphics.setColor(UIManager.getColor(component.isEnabled() && ((HistoryTextField)component).getModel() != null ? "TextField.foreground" : "TextField.disabledForeground"));
            graphics.drawLine(n5 - 5, n6 - 2, n5 + 4, n6 - 2);
            graphics.drawLine(n5 - 4, n6 - 1, n5 + 3, n6 - 1);
            graphics.drawLine(n5 - 3, n6, n5 + 2, n6);
            graphics.drawLine(n5 - 2, n6 + 1, n5 + 1, n6 + 1);
            graphics.drawLine(n5 - 1, n6 + 2, n5, n6 + 2);
            graphics.translate(-(n + n3 - 16), -(n2 - 1));
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(0, 0, 0, 16);
        }
    }

    class MouseHandler
    extends MouseInputAdapter {
        boolean selectAll;

        MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.selectAll = !HistoryTextField.this.hasFocus() && HistoryTextField.this.selectAllOnFocus;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (MouseHandler.this.selectAll) {
                        HistoryTextField.this.selectAll();
                    }
                }
            });
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            Border border = HistoryTextField.this.getBorder();
            Insets insets = border.getBorderInsets(HistoryTextField.this);
            if (mouseEvent.getX() >= HistoryTextField.this.getWidth() - insets.right) {
                HistoryTextField.this.setCursor(Cursor.getDefaultCursor());
            } else {
                HistoryTextField.this.setCursor(Cursor.getPredefinedCursor(2));
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.selectAll = false;
        }
    }
}

