/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Marker;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.jedit.textarea.JEditTextArea;

public class MarkerViewer
extends JPanel
implements ActionListener {
    private JList markerList;
    private View view;
    private RolloverButton previous;
    private RolloverButton next;
    private RolloverButton clear;

    public MarkerViewer(View view) {
        super(new BorderLayout());
        this.view = view;
        Box box = new Box(0);
        box.add(new JLabel(GUIUtilities.prettifyMenuLabel(jEdit.getProperty("markers.label"))));
        box.add(Box.createGlue());
        RolloverButton rolloverButton = new RolloverButton(GUIUtilities.loadIcon("Plus.png"));
        rolloverButton.setToolTipText(GUIUtilities.prettifyMenuLabel(jEdit.getProperty("add-marker.label")));
        rolloverButton.addActionListener(this);
        rolloverButton.setActionCommand("add-marker");
        box.add(rolloverButton);
        this.previous = new RolloverButton(GUIUtilities.loadIcon("ArrowL.png"));
        this.previous.setToolTipText(GUIUtilities.prettifyMenuLabel(jEdit.getProperty("prev-marker.label")));
        this.previous.addActionListener(this);
        this.previous.setActionCommand("prev-marker");
        box.add(this.previous);
        this.next = new RolloverButton(GUIUtilities.loadIcon("ArrowR.png"));
        this.next.setToolTipText(GUIUtilities.prettifyMenuLabel(jEdit.getProperty("next-marker.label")));
        this.next.addActionListener(this);
        this.next.setActionCommand("next-marker");
        box.add(this.next);
        this.clear = new RolloverButton(GUIUtilities.loadIcon("Clear.png"));
        this.clear.setToolTipText(GUIUtilities.prettifyMenuLabel(jEdit.getProperty("remove-all-markers.label")));
        this.clear.addActionListener(this);
        this.clear.setActionCommand("clear");
        box.add(this.clear);
        this.add("North", box);
        this.markerList = new JList();
        this.markerList.setSelectionMode(0);
        this.markerList.setCellRenderer(new Renderer());
        this.markerList.addMouseListener(new MouseHandler());
        this.add("Center", new JScrollPane(this.markerList));
        this.refreshList();
    }

    @Override
    public boolean requestDefaultFocus() {
        this.markerList.requestFocus();
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("clear")) {
            this.view.getBuffer().removeAllMarkers();
        } else if (string.equals("add-marker")) {
            this.view.getEditPane().addMarker();
        } else if (string.equals("next-marker")) {
            this.view.getEditPane().goToNextMarker(false);
            this.updateSelection();
        } else if (string.equals("prev-marker")) {
            this.view.getEditPane().goToPrevMarker(false);
            this.updateSelection();
        }
    }

    @EditBus.EBHandler
    public void handleEditPaneUpdate(EditPaneUpdate editPaneUpdate) {
        if (editPaneUpdate.getEditPane().getView().equals(this.view) && editPaneUpdate.getWhat().equals(EditPaneUpdate.BUFFER_CHANGED)) {
            this.refreshList();
        }
    }

    @EditBus.EBHandler
    public void handleViewUpdate(ViewUpdate viewUpdate) {
        if (viewUpdate.getView().equals(this.view) && viewUpdate.getWhat().equals(ViewUpdate.EDIT_PANE_CHANGED)) {
            this.refreshList();
        }
    }

    @EditBus.EBHandler
    public void handleBufferUpdate(BufferUpdate bufferUpdate) {
        if (this.view.getBuffer().equals(bufferUpdate.getBuffer()) && (bufferUpdate.getWhat().equals(BufferUpdate.MARKERS_CHANGED) || bufferUpdate.getWhat().equals(BufferUpdate.LOADED))) {
            this.refreshList();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        EditBus.addToBus(this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        EditBus.removeFromBus(this);
    }

    private void refreshList() {
        Vector<Marker> vector = this.view.getBuffer().getMarkers();
        if (vector.size() > 0) {
            this.markerList.setListData(vector);
            this.markerList.setEnabled(true);
            this.next.setEnabled(true);
            this.previous.setEnabled(true);
            this.clear.setEnabled(true);
        } else {
            this.markerList.setListData(new Object[]{jEdit.getProperty("no-markers.label")});
            this.markerList.setEnabled(false);
            this.next.setEnabled(false);
            this.previous.setEnabled(false);
            this.clear.setEnabled(false);
        }
    }

    private void goToSelectedMarker() {
        Object e = this.markerList.getSelectedValue();
        if (!(e instanceof Marker)) {
            return;
        }
        Marker marker = (Marker)e;
        this.view.getTextArea().setCaretPosition(marker.getPosition());
        this.view.toFront();
        this.view.requestFocus();
        this.view.getTextArea().requestFocus();
    }

    private void updateSelection() {
        ListModel listModel = this.markerList.getModel();
        int n = this.view.getTextArea().getCaretLine();
        Buffer buffer = this.view.getBuffer();
        for (int i = 0; i < listModel.getSize(); ++i) {
            Marker marker;
            Object e = listModel.getElementAt(i);
            if (!(e instanceof Marker) || buffer.getLineOfOffset((marker = (Marker)listModel.getElementAt(i)).getPosition()) != n) continue;
            this.markerList.setSelectedIndex(i);
            break;
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            int n = MarkerViewer.this.markerList.locationToIndex(mouseEvent.getPoint());
            MarkerViewer.this.markerList.setSelectedIndex(n);
            MarkerViewer.this.goToSelectedMarker();
        }
    }

    class Renderer
    extends DefaultListCellRenderer {
        Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof Marker) {
                Marker marker = (Marker)object;
                JEditTextArea jEditTextArea = MarkerViewer.this.view.getTextArea();
                int n2 = jEditTextArea.getLineOfOffset(marker.getPosition());
                String string = MarkerViewer.this.view.getTextArea().getLineText(n2);
                if (string.equals("")) {
                    string = jEdit.getProperty("markers.blank-line");
                }
                char c = marker.getShortcut();
                String string2 = "";
                if (c > '\u0000') {
                    string2 = "[" + c + "]";
                }
                this.setText(n2 + 1 + " " + string2 + ": " + string);
            }
            return this;
        }
    }
}

