/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.awt.Component;
import java.io.IOException;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.Task;

public class CopyFileWorker
extends Task {
    private final Component comp;
    private final String source;
    private final String target;

    public CopyFileWorker(Component component, String string, String string2) {
        if (string == null || string2 == null) {
            throw new NullPointerException("The source and target cannot be null");
        }
        if (string.equals(string2)) {
            throw new IllegalArgumentException("The source and target must not be the same");
        }
        this.comp = component;
        this.source = string;
        this.target = string2;
        this.setLabel("Copy " + string + " to " + string2);
    }

    @Override
    public void _run() {
        Log.log(1, this, this + ".run()");
        try {
            VFS.copy(this, this.source, this.target, this.comp, true);
        }
        catch (IOException iOException) {
            Log.log(9, this, iOException, iOException);
        }
    }

    @Override
    public String toString() {
        return "CopyFileWorker[" + this.source + ',' + this.target + ']';
    }
}

