/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.awt.Color;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bufferio.BufferInsertRequest;
import org.gjt.sp.jedit.bufferio.BufferLoadRequest;
import org.gjt.sp.jedit.bufferio.BufferSaveRequest;
import org.gjt.sp.jedit.io.GlobVFSFileFilter;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSFileFilter;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ProgressObserver;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.WorkThread;

public abstract class VFS {
    public static final int READ_CAP = 1;
    public static final int WRITE_CAP = 2;
    public static final int BROWSE_CAP = 4;
    public static final int DELETE_CAP = 8;
    public static final int RENAME_CAP = 16;
    public static final int MKDIR_CAP = 32;
    public static final int LOW_LATENCY_CAP = 64;
    public static final int CASE_INSENSITIVE_CAP = 128;
    public static final String EA_TYPE = "type";
    public static final String EA_STATUS = "status";
    public static final String EA_SIZE = "size";
    public static final String EA_MODIFIED = "modified";
    public static int IOBUFSIZE = 32678;
    private String name;
    private int caps;
    private String[] extAttrs;
    private static List<ColorEntry> colors;
    private static final Object lock;

    protected VFS(String string, int n) {
        this.name = string;
        this.caps = n;
        this.extAttrs = new String[]{EA_SIZE, EA_TYPE};
    }

    protected VFS(String string, int n, String[] stringArray) {
        this.name = string;
        this.caps = n;
        this.extAttrs = stringArray;
    }

    public String getName() {
        return this.name;
    }

    public int getCapabilities() {
        return this.caps;
    }

    public boolean isMarkersFileSupported() {
        return true;
    }

    public String[] getExtendedAttributes() {
        return this.extAttrs;
    }

    public String getFileName(String string) {
        if (string.equals("/")) {
            return string;
        }
        while (string.endsWith("/") || string.endsWith(File.separator)) {
            string = string.substring(0, string.length() - 1);
        }
        int n = Math.max(string.lastIndexOf(47), string.lastIndexOf(File.separatorChar));
        if (n == -1) {
            n = string.indexOf(58);
        }
        if (n == -1 || n == string.length() - 1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public String getFilePath(String string) {
        if (!MiscUtilities.isURL(string)) {
            return string;
        }
        String string2 = string.substring(MiscUtilities.getProtocolOfURL(string).length() + 1);
        return VFSManager.getVFSForPath(string2).getFilePath(string2);
    }

    public String getParentOfPath(String string) {
        int n;
        for (n = string.length() - 1; n > 0 && (string.charAt(n) == File.separatorChar || string.charAt(n) == '/'); --n) {
        }
        int n2 = Math.max(0, n);
        int n3 = string.lastIndexOf(File.separatorChar, n2);
        if (n3 == -1) {
            n3 = string.lastIndexOf(47, n2);
        }
        if (n3 == -1) {
            n3 = string.lastIndexOf(58);
        }
        return string.substring(0, n3 + 1);
    }

    public String constructPath(String string, String string2) {
        return string + string2;
    }

    public char getFileSeparator() {
        return '/';
    }

    public String getTwoStageSaveName(String string) {
        return MiscUtilities.constructPath(this.getParentOfPath(string), '#' + this.getFileName(string) + "#save#");
    }

    public void reloadDirectory(String string) {
    }

    public Object createVFSSession(String string, Component component) {
        return new Object();
    }

    public boolean load(View view, Buffer buffer, String string) {
        if ((this.getCapabilities() & 1) == 0) {
            VFSManager.error(view, string, "vfs.not-supported.load", new String[]{this.name});
            return false;
        }
        Object object = this.createVFSSession(string, view);
        if (object == null) {
            return false;
        }
        if ((this.getCapabilities() & 2) == 0) {
            buffer.setReadOnly(true);
        }
        BufferLoadRequest bufferLoadRequest = new BufferLoadRequest(view, buffer, object, this, string);
        if (buffer.isTemporary()) {
            bufferLoadRequest.run();
        } else {
            VFSManager.runInWorkThread(bufferLoadRequest);
        }
        return true;
    }

    public boolean save(View view, Buffer buffer, String string) {
        if ((this.getCapabilities() & 2) == 0) {
            VFSManager.error(view, string, "vfs.not-supported.save", new String[]{this.name});
            return false;
        }
        Object object = this.createVFSSession(string, view);
        if (object == null) {
            return false;
        }
        if (!string.equals(buffer.getPath())) {
            buffer.unsetProperty("Buffer__backedUp");
        }
        VFSManager.runInWorkThread(new BufferSaveRequest(view, buffer, object, this, string));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static boolean copy(ProgressObserver var0, VFS var1_1, Object var2_2, String var3_3, VFS var4_4, Object var5_5, String var6_6, Component var7_7, boolean var8_8) throws IOException {
        block7: {
            if (var0 != null) {
                var0.setStatus("Initializing");
            }
            var9_9 = null;
            var10_10 = null;
            try {
                block8: {
                    block9: {
                        var11_11 = var1_1._getFile(var2_2, var3_3, var7_7);
                        if (var11_11 == null) {
                            throw new FileNotFoundException("source path " + var3_3 + " doesn't exists");
                        }
                        if (var0 != null) {
                            var0.setMaximum(var11_11.getLength());
                        }
                        if ((var12_12 = var4_4._getFile(var5_5, var6_6, var7_7)) != null) break block8;
                        var13_13 = MiscUtilities.getParentOfPath(var6_6);
                        var14_16 = var4_4._getFile(var5_5, var13_13, var7_7);
                        if (var14_16 == null) {
                            throw new FileNotFoundException("target path " + var13_13 + " doesn't exists");
                        }
                        if (var14_16.getType() != 1) break block9;
                        var15_18 = MiscUtilities.getFileName(var6_6);
                        var6_6 = MiscUtilities.constructPath(var13_13, var15_18);
                        ** GOTO lbl36
                    }
                    throw new IOException("The parent of target path is a file");
                }
                if (var12_12.getType() != 1) ** GOTO lbl36
                if (!var12_12.getPath().equals(var11_11.getPath())) break block7;
                var13_14 = false;
            }
            catch (Throwable var16_19) {
                IOUtilities.closeQuietly(var9_9);
                IOUtilities.closeQuietly(var10_10);
                throw var16_19;
            }
            IOUtilities.closeQuietly(var9_9);
            IOUtilities.closeQuietly(var10_10);
            return var13_14;
        }
        var6_6 = MiscUtilities.constructPath(var6_6, var11_11.getName());
lbl36:
        // 3 sources

        var9_9 = new BufferedInputStream(var1_1._createInputStream(var2_2, var3_3, false, var7_7));
        var10_10 = new BufferedOutputStream(var4_4._createOutputStream(var5_5, var6_6, var7_7));
        var13_15 = IOUtilities.copyStream(VFS.IOBUFSIZE, var0, var9_9, var10_10, var8_8);
        VFSManager.sendVFSUpdate(var4_4, var6_6, true);
        var14_17 = var13_15;
        IOUtilities.closeQuietly(var9_9);
        IOUtilities.closeQuietly(var10_10);
        return var14_17;
    }

    public static boolean copy(ProgressObserver progressObserver, String string, String string2, Component component, boolean bl) throws IOException {
        VFS vFS = VFSManager.getVFSForPath(string);
        Object object = vFS.createVFSSession(string, component);
        if (object == null) {
            Log.log(7, VFS.class, "Unable to get a valid session from " + vFS + " for path " + string);
            return false;
        }
        VFS vFS2 = VFSManager.getVFSForPath(string2);
        Object object2 = vFS2.createVFSSession(string2, component);
        if (object2 == null) {
            Log.log(7, VFS.class, "Unable to get a valid session from " + vFS2 + " for path " + string2);
            return false;
        }
        return VFS.copy(progressObserver, vFS, object, string, vFS2, object2, string2, component, bl);
    }

    public boolean insert(View view, Buffer buffer, String string) {
        if ((this.getCapabilities() & 1) == 0) {
            VFSManager.error(view, string, "vfs.not-supported.load", new String[]{this.name});
            return false;
        }
        Object object = this.createVFSSession(string, view);
        if (object == null) {
            return false;
        }
        VFSManager.runInWorkThread(new BufferInsertRequest(view, buffer, object, this, string));
        return true;
    }

    public String _canonPath(Object object, String string, Component component) throws IOException {
        return string;
    }

    public String[] _listDirectory(Object object, String string, String string2, boolean bl, Component component) throws IOException {
        String[] stringArray = this._listDirectory(object, string, string2, bl, component, true, false);
        return stringArray;
    }

    public String[] _listDirectory(Object object, String string, String string2, boolean bl, Component component, boolean bl2, boolean bl3) throws IOException {
        GlobVFSFileFilter globVFSFileFilter = new GlobVFSFileFilter(string2);
        return this._listDirectory(object, string, globVFSFileFilter, bl, component, bl2, bl3);
    }

    public String[] _listDirectory(Object object, String string, VFSFileFilter vFSFileFilter, boolean bl, Component component, boolean bl2, boolean bl3) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>(100);
        this.listFiles(object, new HashSet<String>(), arrayList, string, vFSFileFilter, bl, component, bl2, bl3);
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        Arrays.sort(stringArray, new StandardUtilities.StringCompare(true));
        return stringArray;
    }

    public VFSFile[] _listFiles(Object object, String string, Component component) throws IOException {
        VFSManager.error(component, string, "vfs.not-supported.list", new String[]{this.name});
        return null;
    }

    public VFSFile _getFile(Object object, String string, Component component) throws IOException {
        return null;
    }

    public boolean _delete(Object object, String string, Component component) throws IOException {
        return false;
    }

    public boolean _rename(Object object, String string, String string2, Component component) throws IOException {
        return false;
    }

    public boolean _mkdir(Object object, String string, Component component) throws IOException {
        return false;
    }

    public void _backup(Object object, String string, Component component) throws IOException {
    }

    public InputStream _createInputStream(Object object, String string, boolean bl, Component component) throws IOException {
        VFSManager.error(component, string, "vfs.not-supported.load", new String[]{this.name});
        return null;
    }

    public OutputStream _createOutputStream(Object object, String string, Component component) throws IOException {
        VFSManager.error(component, string, "vfs.not-supported.save", new String[]{this.name});
        return null;
    }

    public void _saveComplete(Object object, Buffer buffer, String string, Component component) throws IOException {
    }

    public void _finishTwoStageSave(Object object, Buffer buffer, String string, Component component) throws IOException {
    }

    public void _endVFSSession(Object object, Component component) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Color getDefaultColorFor(String string) {
        Object object = lock;
        synchronized (object) {
            if (colors == null) {
                VFS.loadColors();
            }
            for (int i = 0; i < colors.size(); ++i) {
                ColorEntry colorEntry = colors.get(i);
                if (!colorEntry.re.matcher(string).matches()) continue;
                return colorEntry.color;
            }
            return null;
        }
    }

    private void listFiles(Object object, Collection<String> collection, List<String> list, String string, VFSFileFilter vFSFileFilter, boolean bl, Component component, boolean bl2, boolean bl3) throws IOException {
        VFSFile[] vFSFileArray;
        String string2 = string;
        if (bl && !MiscUtilities.isURL(string) && !string.equals(string2 = MiscUtilities.resolveSymlinks(string))) {
            if (collection.contains(string2)) {
                Log.log(9, this, "Recursion in listFiles(): " + string);
                return;
            }
            collection.add(string2);
        }
        Thread thread = Thread.currentThread();
        WorkThread workThread = null;
        if (thread instanceof WorkThread) {
            workThread = (WorkThread)thread;
        }
        if ((vFSFileArray = this._listFiles(object, string, component)) == null || vFSFileArray.length == 0) {
            return;
        }
        for (int i = 0; !(i >= vFSFileArray.length || workThread != null && workThread.isAborted() || thread.isInterrupted()); ++i) {
            VFSFile vFSFile = vFSFileArray[i];
            if (bl3 && (vFSFile.isHidden() || MiscUtilities.isBackup(vFSFile.getName())) || !vFSFileFilter.accept(vFSFile)) continue;
            if (vFSFile.getType() == 1 || vFSFile.getType() == 2) {
                if (!bl) continue;
                String string3 = this._canonPath(object, vFSFile.getPath(), component);
                this.listFiles(object, collection, list, string3, vFSFileFilter, bl, component, bl2, bl3);
                continue;
            }
            if (bl2) {
                try {
                    if (vFSFile.isBinary(object)) {
                        Log.log(5, this, vFSFile.getPath() + ": skipped as a binary file");
                        continue;
                    }
                }
                catch (IOException iOException) {
                    Log.log(9, this, iOException);
                }
            }
            list.add(vFSFile.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadColors() {
        Object object = lock;
        synchronized (object) {
            String string;
            colors = new ArrayList<ColorEntry>();
            if (!jEdit.getBooleanProperty("vfs.browser.colorize")) {
                return;
            }
            int n = 0;
            while ((string = jEdit.getProperty("vfs.browser.colors." + n + ".glob")) != null) {
                try {
                    colors.add(new ColorEntry(Pattern.compile(StandardUtilities.globToRE(string)), jEdit.getColorProperty("vfs.browser.colors." + n + ".color", Color.black)));
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    Log.log(9, VFS.class, "Invalid regular expression: " + string);
                    Log.log(9, VFS.class, patternSyntaxException);
                }
                ++n;
            }
        }
    }

    static {
        lock = new Object();
        EditBus.addToBus(new EBComponent(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleMessage(EBMessage eBMessage) {
                if (eBMessage instanceof PropertiesChanged) {
                    Object object = lock;
                    synchronized (object) {
                        colors = null;
                    }
                }
            }
        });
    }

    private static class ColorEntry {
        Pattern re;
        Color color;

        ColorEntry(Pattern pattern, Color color) {
            this.re = pattern;
            this.color = color;
        }
    }

    public static class DirectoryEntryCompare
    implements Comparator<VFSFile> {
        private boolean sortIgnoreCase;
        private boolean sortMixFilesAndDirs;

        public DirectoryEntryCompare(boolean bl, boolean bl2) {
            this.sortMixFilesAndDirs = bl;
            this.sortIgnoreCase = bl2;
        }

        @Override
        public int compare(VFSFile vFSFile, VFSFile vFSFile2) {
            if (!this.sortMixFilesAndDirs && vFSFile.getType() != vFSFile2.getType()) {
                return vFSFile2.getType() - vFSFile.getType();
            }
            return StandardUtilities.compareStrings(vFSFile.getName(), vFSFile2.getName(), this.sortIgnoreCase);
        }
    }
}

