/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.WindowTableModel;

public class DockingOptionPane
extends AbstractOptionPane {
    private JTable windowTable;
    private WindowTableModel windowModel;
    private JCheckBox autoLoadModeLayout;
    private JCheckBox autoSaveModeLayout;
    private JComboBox dockableSetSelection;
    private static final String DOCKING_OPTIONS_PREFIX = "options.docking.";
    public static final String AUTO_LOAD_MODE_LAYOUT_PROP = "options.docking.autoLoadModeLayout";
    private static final String AUTO_LOAD_MODE_LAYOUT_LABEL = "options.docking.autoLoadModeLayout.label";
    public static final String AUTO_SAVE_MODE_LAYOUT_PROP = "options.docking.autoSaveModeLayout";
    private static final String AUTO_SAVE_MODE_LAYOUT_LABEL = "options.docking.autoSaveModeLayout.label";

    public DockingOptionPane() {
        super("docking");
    }

    @Override
    public void _init() {
        this.setLayout(new BorderLayout());
        this.add("North", this.createDockingOptionsPanel());
        this.add("Center", this.createWindowTableScroller());
        this.dockableSetSelection.setModel(new DefaultComboBoxModel<String>(this.windowModel.getDockableSets()));
    }

    @Override
    public void _save() {
        jEdit.setBooleanProperty(AUTO_LOAD_MODE_LAYOUT_PROP, this.autoLoadModeLayout.isSelected());
        jEdit.setBooleanProperty(AUTO_SAVE_MODE_LAYOUT_PROP, this.autoSaveModeLayout.isSelected());
        this.windowModel.save();
    }

    private JPanel createDockingOptionsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        boolean bl = jEdit.getBooleanProperty(AUTO_LOAD_MODE_LAYOUT_PROP, false);
        this.autoLoadModeLayout = new JCheckBox(jEdit.getProperty(AUTO_LOAD_MODE_LAYOUT_LABEL), bl);
        jPanel.add(this.autoLoadModeLayout);
        this.autoSaveModeLayout = new JCheckBox(jEdit.getProperty(AUTO_SAVE_MODE_LAYOUT_LABEL), jEdit.getBooleanProperty(AUTO_SAVE_MODE_LAYOUT_PROP, false));
        jPanel.add(this.autoSaveModeLayout);
        this.autoSaveModeLayout.setEnabled(bl);
        this.autoLoadModeLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DockingOptionPane.this.autoSaveModeLayout.setEnabled(DockingOptionPane.this.autoLoadModeLayout.isSelected());
            }
        });
        Box box = Box.createVerticalBox();
        jPanel.add(box);
        Box box2 = Box.createHorizontalBox();
        box.add(box2);
        box2.add(Box.createHorizontalStrut(6));
        box2.add(new JLabel(jEdit.getProperty("options.docking.selectSet.label")));
        box2.add(Box.createHorizontalStrut(6));
        this.dockableSetSelection = new JComboBox();
        box2.add(this.dockableSetSelection);
        this.dockableSetSelection.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                DockingOptionPane.this.windowModel.showSet((String)DockingOptionPane.this.dockableSetSelection.getSelectedItem());
            }
        });
        box2.add(Box.createHorizontalStrut(6));
        box.add(Box.createVerticalStrut(6));
        return jPanel;
    }

    private JScrollPane createWindowTableScroller() {
        this.windowModel = DockingOptionPane.createWindowModel();
        this.windowTable = new JTable(this.windowModel);
        this.windowTable.getTableHeader().setReorderingAllowed(false);
        this.windowTable.setColumnSelectionAllowed(false);
        this.windowTable.setRowSelectionAllowed(false);
        this.windowTable.setCellSelectionEnabled(false);
        DockPositionCellRenderer dockPositionCellRenderer = new DockPositionCellRenderer();
        this.windowTable.setRowHeight(dockPositionCellRenderer.getPreferredSize().height);
        TableColumn tableColumn = this.windowTable.getColumnModel().getColumn(1);
        tableColumn.setCellRenderer(dockPositionCellRenderer);
        tableColumn.setCellEditor(new DefaultCellEditor(new DockPositionCellRenderer()));
        Dimension dimension = this.windowTable.getPreferredSize();
        dimension.height = Math.min(dimension.height, 50);
        JScrollPane jScrollPane = new JScrollPane(this.windowTable);
        jScrollPane.setPreferredSize(dimension);
        return jScrollPane;
    }

    private static WindowTableModel createWindowModel() {
        return new WindowTableModel();
    }

    static class DockPositionCellRenderer
    extends JComboBox
    implements TableCellRenderer {
        DockPositionCellRenderer() {
            super(new String[]{"floating", "top", "left", "bottom", "right"});
            this.setRequestFocusEnabled(false);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setSelectedItem(object);
            return this;
        }
    }
}

