/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.gui.ColorWellButton;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;

public class StatusBarOptionPane
extends AbstractOptionPane {
    private ColorWellButton foregroundColor;
    private ColorWellButton backgroundColor;
    private ColorWellButton memForegroundColor;
    private ColorWellButton memBackgroundColor;
    private JCheckBox showStatusbar;
    private JCheckBox showStatusbarPlain;
    private DefaultListModel listModel;
    private JLabel previewStatusBar;
    private JList list;
    private RolloverButton add;
    private RolloverButton remove;
    private RolloverButton moveUp;
    private RolloverButton moveDown;
    private RolloverButton edit;
    private JCheckBox showCaretLineNumber;
    private JCheckBox showCaretDot;
    private JCheckBox showCaretVirtual;
    private JCheckBox showCaretOffset;
    private JCheckBox showCaretBufferLength;

    public StatusBarOptionPane() {
        super("status");
    }

    @Override
    protected void _init() {
        Object object;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        this.showStatusbar = new JCheckBox(jEdit.getProperty("options.status.visible"));
        this.showStatusbar.setSelected(jEdit.getBooleanProperty("view.status.visible"));
        jPanel.add(this.showStatusbar);
        this.showStatusbarPlain = new JCheckBox(jEdit.getProperty("options.status.plainview.visible"));
        this.showStatusbarPlain.setSelected(jEdit.getBooleanProperty("view.status.plainview.visible"));
        jPanel.add(this.showStatusbarPlain);
        jPanel.add(new JLabel(jEdit.getProperty("options.status.caption")));
        JPanel jPanel2 = new JPanel();
        this.previewStatusBar = new JLabel();
        jPanel2.add(this.previewStatusBar);
        JPanel jPanel3 = new JPanel(new GridLayout(2, 1));
        jPanel3.add(jPanel);
        jPanel3.add(jPanel2);
        this.add((Component)jPanel3, "North");
        AbstractOptionPane abstractOptionPane = new AbstractOptionPane("Status Options");
        this.foregroundColor = new ColorWellButton(jEdit.getColorProperty("view.status.foreground"));
        abstractOptionPane.addComponent(jEdit.getProperty("options.status.foreground"), (Component)this.foregroundColor, 3);
        this.backgroundColor = new ColorWellButton(jEdit.getColorProperty("view.status.background"));
        abstractOptionPane.addComponent(jEdit.getProperty("options.status.background"), (Component)this.backgroundColor, 3);
        this.memForegroundColor = new ColorWellButton(jEdit.getColorProperty("view.status.memory.foreground"));
        abstractOptionPane.addComponent(jEdit.getProperty("options.status.memory.foreground"), (Component)this.memForegroundColor, 3);
        this.memBackgroundColor = new ColorWellButton(jEdit.getColorProperty("view.status.memory.background"));
        abstractOptionPane.addComponent(jEdit.getProperty("options.status.memory.background"), (Component)this.memBackgroundColor, 3);
        abstractOptionPane.addSeparator();
        abstractOptionPane.addComponent(new JLabel(jEdit.getProperty("options.status.caret.title", "Caret position display options:")));
        this.showCaretLineNumber = new JCheckBox(jEdit.getProperty("options.status.caret.linenumber", "Show caret line number"), jEdit.getBooleanProperty("view.status.show-caret-linenumber", true));
        this.showCaretLineNumber.setName("showCaretLineNumber");
        this.showCaretDot = new JCheckBox(jEdit.getProperty("options.status.caret.dot", "Show caret offset from start of line"), jEdit.getBooleanProperty("view.status.show-caret-dot", true));
        this.showCaretDot.setName("showCaretDot");
        this.showCaretVirtual = new JCheckBox(jEdit.getProperty("options.status.caret.virtual", "Show caret virtual offset from start of line"), jEdit.getBooleanProperty("view.status.show-caret-virtual", true));
        this.showCaretVirtual.setName("showCaretVirtual");
        this.showCaretOffset = new JCheckBox(jEdit.getProperty("options.status.caret.offset", "Show caret offset from start of file"), jEdit.getBooleanProperty("view.status.show-caret-offset", true));
        this.showCaretOffset.setName("showCaretOffset");
        this.showCaretBufferLength = new JCheckBox(jEdit.getProperty("options.status.caret.bufferlength", "Show length of file"), jEdit.getBooleanProperty("view.status.show-caret-bufferlength", true));
        this.showCaretBufferLength.setName("showCaretBufferLength");
        abstractOptionPane.addComponent(this.showCaretLineNumber);
        abstractOptionPane.addComponent(this.showCaretDot);
        abstractOptionPane.addComponent(this.showCaretVirtual);
        abstractOptionPane.addComponent(this.showCaretOffset);
        abstractOptionPane.addComponent(this.showCaretBufferLength);
        String string = jEdit.getProperty("view.status");
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        this.listModel = new DefaultListModel();
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            this.listModel.addElement(object);
        }
        this.list = new JList(this.listModel);
        this.list.setCellRenderer(new WidgetListCellRenderer());
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new ListHandler());
        object = new JPanel(new BorderLayout());
        ((Container)object).add((Component)new JScrollPane(this.list), "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(new EmptyBorder(3, 0, 0, 0));
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        ActionHandler actionHandler = new ActionHandler();
        this.add = new RolloverButton(GUIUtilities.loadIcon("Plus.png"));
        this.add.setToolTipText(jEdit.getProperty("options.status.add"));
        this.add.addActionListener(actionHandler);
        jPanel4.add(this.add);
        jPanel4.add(Box.createHorizontalStrut(6));
        this.remove = new RolloverButton(GUIUtilities.loadIcon("Minus.png"));
        this.remove.setToolTipText(jEdit.getProperty("options.status.remove"));
        this.remove.addActionListener(actionHandler);
        jPanel4.add(this.remove);
        jPanel4.add(Box.createHorizontalStrut(6));
        this.moveUp = new RolloverButton(GUIUtilities.loadIcon("ArrowU.png"));
        this.moveUp.setToolTipText(jEdit.getProperty("options.status.moveUp"));
        this.moveUp.addActionListener(actionHandler);
        jPanel4.add(this.moveUp);
        jPanel4.add(Box.createHorizontalStrut(6));
        this.moveDown = new RolloverButton(GUIUtilities.loadIcon("ArrowD.png"));
        this.moveDown.setToolTipText(jEdit.getProperty("options.status.moveDown"));
        this.moveDown.addActionListener(actionHandler);
        jPanel4.add(this.moveDown);
        jPanel4.add(Box.createHorizontalStrut(6));
        this.edit = new RolloverButton(GUIUtilities.loadIcon("ButtonProperties.png"));
        this.edit.setToolTipText(jEdit.getProperty("options.status.edit"));
        this.edit.addActionListener(actionHandler);
        jPanel4.add(this.edit);
        jPanel4.add(Box.createGlue());
        this.updateButtons();
        ((Container)object).add((Component)jPanel4, "South");
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab("Options", abstractOptionPane);
        jTabbedPane.add("Widgets", (Component)object);
        this.add((Component)jTabbedPane, "Center");
        this.updatePreview();
    }

    @Override
    protected void _save() {
        jEdit.setColorProperty("view.status.foreground", this.foregroundColor.getSelectedColor());
        jEdit.setColorProperty("view.status.background", this.backgroundColor.getSelectedColor());
        jEdit.setColorProperty("view.status.memory.foreground", this.memForegroundColor.getSelectedColor());
        jEdit.setColorProperty("view.status.memory.background", this.memBackgroundColor.getSelectedColor());
        jEdit.setBooleanProperty("view.status.visible", this.showStatusbar.isSelected());
        jEdit.setBooleanProperty("view.status.plainview.visible", this.showStatusbarPlain.isSelected());
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            if (i != 0) {
                stringBuilder.append(' ');
            }
            String string = (String)this.listModel.elementAt(i);
            stringBuilder.append(string);
        }
        jEdit.setProperty("view.status", stringBuilder.toString());
        jEdit.setBooleanProperty("view.status.show-caret-linenumber", this.showCaretLineNumber.isSelected());
        jEdit.setBooleanProperty("view.status.show-caret-dot", this.showCaretDot.isSelected());
        jEdit.setBooleanProperty("view.status.show-caret-virtual", this.showCaretVirtual.isSelected());
        jEdit.setBooleanProperty("view.status.show-caret-offset", this.showCaretOffset.isSelected());
        jEdit.setBooleanProperty("view.status.show-caret-bufferlength", this.showCaretBufferLength.isSelected());
    }

    private void updateButtons() {
        int n = this.list.getSelectedIndex();
        this.remove.setEnabled(n != -1 && this.listModel.getSize() != 0);
        this.moveUp.setEnabled(n > 0);
        this.moveDown.setEnabled(n != -1 && n != this.listModel.getSize() - 1);
        this.edit.setEnabled(n != -1);
    }

    private void updatePreview() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            if (i != 0) {
                stringBuilder.append(' ');
            }
            String string = (String)this.listModel.elementAt(i);
            String string2 = jEdit.getProperty("statusbar." + string + ".sample", string);
            stringBuilder.append(string2);
        }
        this.previewStatusBar.setText(stringBuilder.toString());
    }

    private class WidgetSelectionDialog
    extends EnhancedDialog {
        private JButton ok;
        private JButton cancel;
        private JTextField labelField;
        private JLabel labelLabel;
        private JRadioButton labelRadio;
        private JComboBox widgetCombo;
        private JLabel widgetLabel;
        private JRadioButton widgetRadio;
        private String value;

        /*
         * WARNING - void declaration
         */
        WidgetSelectionDialog(Component component) {
            void object3;
            super(GUIUtilities.getParentDialog(component), jEdit.getProperty("options.status.edit.title"), true);
            ButtonGroup buttonGroup = new ButtonGroup();
            this.labelRadio = new JRadioButton(jEdit.getProperty("options.status.edit.labelRadioButton"));
            this.widgetRadio = new JRadioButton(jEdit.getProperty("options.status.edit.widgetRadioButton"));
            buttonGroup.add(this.labelRadio);
            buttonGroup.add(this.widgetRadio);
            this.labelLabel = new JLabel(jEdit.getProperty("options.status.edit.labelLabel"));
            this.labelField = new JTextField();
            this.widgetLabel = new JLabel(jEdit.getProperty("options.status.edit.widgetLabel"));
            String[] stringArray = ServiceManager.getServiceNames("org.gjt.sp.jedit.gui.statusbar.StatusWidget");
            Vector<String> vector = new Vector<String>(stringArray.length);
            HashSet<String> hashSet = new HashSet<String>(StatusBarOptionPane.this.listModel.getSize());
            boolean i = false;
            while (object3 < StatusBarOptionPane.this.listModel.getSize()) {
                hashSet.add((String)StatusBarOptionPane.this.listModel.get((int)object3));
                ++object3;
            }
            for (String string : stringArray) {
                if (hashSet.contains(string)) continue;
                vector.add(string);
            }
            this.widgetCombo = new JComboBox(vector);
            this.widgetCombo.setRenderer(new WidgetListCellRenderer());
            ActionHandler actionHandler = new ActionHandler();
            this.labelRadio.addActionListener(actionHandler);
            this.widgetRadio.addActionListener(actionHandler);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.setBorder(new EmptyBorder(12, 0, 0, 0));
            jPanel.add(Box.createGlue());
            this.ok = new JButton(jEdit.getProperty("common.ok"));
            this.ok.addActionListener(actionHandler);
            this.getRootPane().setDefaultButton(this.ok);
            jPanel.add(this.ok);
            jPanel.add(Box.createHorizontalStrut(6));
            this.cancel = new JButton(jEdit.getProperty("common.cancel"));
            this.cancel.addActionListener(actionHandler);
            jPanel.add(this.cancel);
            jPanel.add(Box.createGlue());
            this.labelField.setEnabled(false);
            this.widgetRadio.setSelected(true);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setBorder(new EmptyBorder(12, 12, 12, 12));
            this.setContentPane(jPanel2);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 1));
            jPanel3.add(this.labelRadio);
            JPanel jPanel4 = new JPanel(new BorderLayout());
            jPanel4.add((Component)this.labelLabel, "West");
            jPanel4.add(this.labelField);
            jPanel3.add(jPanel4);
            jPanel3.add(this.widgetRadio);
            jPanel4 = new JPanel(new BorderLayout());
            jPanel4.add((Component)this.widgetLabel, "West");
            jPanel4.add(this.widgetCombo);
            if (vector.isEmpty()) {
                this.labelRadio.setSelected(true);
                this.widgetRadio.setEnabled(false);
                this.widgetLabel.setEnabled(false);
                this.widgetCombo.setEnabled(false);
            }
            jPanel3.add(jPanel4);
            this.getContentPane().add((Component)jPanel3, "Center");
            this.getContentPane().add((Component)jPanel, "South");
            this.pack();
            this.setLocationRelativeTo(GUIUtilities.getParentDialog(component));
            this.setVisible(true);
        }

        @Override
        public void ok() {
            this.value = this.widgetRadio.isSelected() ? (String)this.widgetCombo.getSelectedItem() : this.labelField.getText().trim();
            this.dispose();
        }

        @Override
        public void cancel() {
            this.value = null;
            this.dispose();
        }

        public String getValue() {
            return this.value;
        }

        private class ActionHandler
        implements ActionListener {
            private ActionHandler() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object == WidgetSelectionDialog.this.ok) {
                    WidgetSelectionDialog.this.ok();
                } else if (object == WidgetSelectionDialog.this.cancel) {
                    WidgetSelectionDialog.this.cancel();
                } else if (object == WidgetSelectionDialog.this.labelRadio) {
                    WidgetSelectionDialog.this.labelField.setEnabled(true);
                    WidgetSelectionDialog.this.widgetCombo.setEnabled(false);
                    WidgetSelectionDialog.this.validate();
                } else if (object == WidgetSelectionDialog.this.widgetRadio) {
                    WidgetSelectionDialog.this.labelField.setEnabled(false);
                    WidgetSelectionDialog.this.widgetCombo.setEnabled(true);
                    WidgetSelectionDialog.this.validate();
                }
            }
        }
    }

    private class WidgetListCellRenderer
    extends DefaultListCellRenderer {
        private WidgetListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object == null) {
                return this;
            }
            String string = String.valueOf(object);
            String string2 = jEdit.getProperty("statusbar." + string + ".label", string);
            this.setText(string2);
            return this;
        }
    }

    private class ListHandler
    implements ListSelectionListener {
        private ListHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            StatusBarOptionPane.this.updateButtons();
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == StatusBarOptionPane.this.add) {
                String string = this.selectWidget();
                if (string == null) {
                    return;
                }
                int n = StatusBarOptionPane.this.list.getSelectedIndex();
                n = n == -1 ? StatusBarOptionPane.this.listModel.getSize() : ++n;
                StatusBarOptionPane.this.listModel.insertElementAt(string, n);
                StatusBarOptionPane.this.list.setSelectedIndex(n);
                StatusBarOptionPane.this.list.ensureIndexIsVisible(n);
                StatusBarOptionPane.this.updatePreview();
            } else if (object == StatusBarOptionPane.this.remove) {
                int n = StatusBarOptionPane.this.list.getSelectedIndex();
                StatusBarOptionPane.this.listModel.removeElementAt(n);
                if (StatusBarOptionPane.this.listModel.getSize() != 0) {
                    if (StatusBarOptionPane.this.listModel.getSize() == n) {
                        StatusBarOptionPane.this.list.setSelectedIndex(n - 1);
                    } else {
                        StatusBarOptionPane.this.list.setSelectedIndex(n);
                    }
                }
                StatusBarOptionPane.this.updateButtons();
                StatusBarOptionPane.this.updatePreview();
            } else if (object == StatusBarOptionPane.this.moveUp) {
                int n = StatusBarOptionPane.this.list.getSelectedIndex();
                Object e = StatusBarOptionPane.this.list.getSelectedValue();
                StatusBarOptionPane.this.listModel.removeElementAt(n);
                StatusBarOptionPane.this.listModel.insertElementAt(e, n - 1);
                StatusBarOptionPane.this.list.setSelectedIndex(n - 1);
                StatusBarOptionPane.this.list.ensureIndexIsVisible(n - 1);
                StatusBarOptionPane.this.updatePreview();
            } else if (object == StatusBarOptionPane.this.moveDown) {
                int n = StatusBarOptionPane.this.list.getSelectedIndex();
                Object e = StatusBarOptionPane.this.list.getSelectedValue();
                StatusBarOptionPane.this.listModel.removeElementAt(n);
                StatusBarOptionPane.this.listModel.insertElementAt(e, n + 1);
                StatusBarOptionPane.this.list.setSelectedIndex(n + 1);
                StatusBarOptionPane.this.list.ensureIndexIsVisible(n + 1);
                StatusBarOptionPane.this.updatePreview();
            } else if (object == StatusBarOptionPane.this.edit) {
                String string = this.selectWidget();
                if (string == null) {
                    return;
                }
                int n = StatusBarOptionPane.this.list.getSelectedIndex();
                StatusBarOptionPane.this.listModel.insertElementAt(string, n);
                StatusBarOptionPane.this.list.setSelectedIndex(n);
                StatusBarOptionPane.this.list.ensureIndexIsVisible(n);
                StatusBarOptionPane.this.updatePreview();
            }
        }

        private String selectWidget() {
            WidgetSelectionDialog widgetSelectionDialog = new WidgetSelectionDialog(StatusBarOptionPane.this);
            String string = widgetSelectionDialog.getValue();
            if (string != null && string.length() == 0) {
                string = null;
            }
            return string;
        }
    }
}

