/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import java.awt.Component;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.search.BufferListSet;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public class AllBufferSet
extends BufferListSet {
    private String glob;

    public AllBufferSet(String string) {
        this.glob = string;
    }

    public String getFileFilter() {
        return this.glob;
    }

    @Override
    public String getCode() {
        return "new AllBufferSet(\"" + StandardUtilities.charsToEscapes(this.glob) + "\")";
    }

    @Override
    protected String[] _getFiles(Component component) {
        Pattern pattern;
        Buffer[] bufferArray = jEdit.getBuffers();
        ArrayList<String> arrayList = new ArrayList<String>(bufferArray.length);
        try {
            pattern = Pattern.compile(StandardUtilities.globToRE(this.glob), 2);
        }
        catch (Exception exception) {
            Log.log(9, this, exception);
            return null;
        }
        for (int i = 0; i < bufferArray.length; ++i) {
            Buffer buffer = bufferArray[i];
            if (!pattern.matcher(buffer.getName()).matches()) continue;
            arrayList.add(buffer.getPath());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

