/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.IPropertyManager;
import org.gjt.sp.jedit.syntax.ParserRuleSet;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.syntax.Token;

public class Chunk
extends Token {
    private static final char[] EMPTY_TEXT = new char[0];
    public boolean accessable;
    public boolean initialized;
    public SyntaxStyle style;
    public float width;
    private Color background;
    private String str;
    private List<GlyphVector> glyphs;
    private boolean visible;
    private static boolean fontSubstEnabled;
    private static Font[] preferredFonts;
    private static Font[] fontSubstList;

    public static float paintChunkList(Chunk chunk, Graphics2D graphics2D, float f, float f2, boolean bl) {
        Rectangle rectangle = graphics2D.getClipBounds();
        float f3 = 0.0f;
        while (chunk != null) {
            if (f + f3 + chunk.width > (float)rectangle.x && f + f3 < (float)(rectangle.x + rectangle.width)) {
                if (Debug.CHUNK_PAINT_DEBUG) {
                    graphics2D.draw(new Rectangle2D.Float(f + f3, f2 - 10.0f, chunk.width, 10.0f));
                }
                if (chunk.accessable && chunk.visible) {
                    graphics2D.setFont(chunk.style.getFont());
                    graphics2D.setColor(chunk.style.getForegroundColor());
                    if (bl && chunk.glyphs != null) {
                        chunk.drawGlyphs(graphics2D, f + f3, f2);
                    } else if (chunk.str != null) {
                        graphics2D.drawString(chunk.str, (int)(f + f3), (int)f2);
                    }
                }
            }
            f3 += chunk.width;
            chunk = (Chunk)chunk.next;
        }
        return f3;
    }

    public static float paintChunkBackgrounds(Chunk chunk, Graphics2D graphics2D, float f, float f2, int n) {
        Rectangle rectangle = graphics2D.getClipBounds();
        float f3 = 0.0f;
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n2 = fontMetrics.getAscent();
        int n3 = n;
        while (chunk != null) {
            Color color;
            if (f + f3 + chunk.width > (float)rectangle.x && f + f3 < (float)(rectangle.x + rectangle.width) && chunk.accessable && (color = chunk.background) != null) {
                graphics2D.setColor(color);
                graphics2D.fill(new Rectangle2D.Float(f + f3, f2 - (float)n2, f3 + chunk.width - f3, n3));
            }
            f3 += chunk.width;
            chunk = (Chunk)chunk.next;
        }
        return f3;
    }

    public static float offsetToX(Chunk chunk, int n) {
        if (chunk != null && n < chunk.offset) {
            throw new ArrayIndexOutOfBoundsException(n + " < " + chunk.offset);
        }
        float f = 0.0f;
        while (chunk != null) {
            if (chunk.accessable && n < chunk.offset + chunk.length) {
                return f + chunk.offsetToX(n - chunk.offset);
            }
            f += chunk.width;
            chunk = (Chunk)chunk.next;
        }
        return f;
    }

    public static int xToOffset(Chunk chunk, float f, boolean bl) {
        float f2 = 0.0f;
        while (chunk != null) {
            if (chunk.accessable && f < f2 + chunk.width) {
                return chunk.xToOffset(f - f2, bl);
            }
            f2 += chunk.width;
            chunk = (Chunk)chunk.next;
        }
        return -1;
    }

    public static void propertiesChanged(IPropertyManager iPropertyManager) {
        String string;
        fontSubstList = null;
        if (iPropertyManager == null) {
            fontSubstEnabled = false;
            preferredFonts = null;
        } else {
            fontSubstEnabled = Boolean.parseBoolean(iPropertyManager.getProperty("view.enableFontSubst"));
        }
        ArrayList<Font> arrayList = new ArrayList<Font>();
        int n = 0;
        while ((string = iPropertyManager.getProperty("view.fontSubstList." + n)) != null) {
            Font font = new Font(string, 0, 12);
            if (!"dialog".equalsIgnoreCase(font.getFamily()) || "dialog".equalsIgnoreCase(string)) {
                arrayList.add(font);
            }
            ++n;
        }
        preferredFonts = arrayList.toArray(new Font[arrayList.size()]);
    }

    public Chunk(float f, int n, ParserRuleSet parserRuleSet) {
        super((byte)0, n, 0, parserRuleSet);
        this.width = f;
    }

    public Chunk(byte by, int n, int n2, ParserRuleSet parserRuleSet, SyntaxStyle[] syntaxStyleArray, byte by2) {
        super(by, n, n2, parserRuleSet);
        this.accessable = true;
        this.style = syntaxStyleArray[by];
        this.background = this.style.getBackgroundColor();
        if (this.background == null) {
            this.background = syntaxStyleArray[by2].getBackgroundColor();
        }
    }

    public final float offsetToX(int n) {
        if (!this.visible || this.glyphs == null) {
            return 0.0f;
        }
        float f = 0.0f;
        for (GlyphVector glyphVector : this.glyphs) {
            if (n < glyphVector.getNumGlyphs()) {
                return f += (float)glyphVector.getGlyphPosition(n).getX();
            }
            f += (float)glyphVector.getLogicalBounds().getWidth();
            n -= glyphVector.getNumGlyphs();
        }
        assert (false) : "Shouldn't reach this.";
        return -1.0f;
    }

    public final int xToOffset(float f, boolean bl) {
        if (!this.visible || this.glyphs == null) {
            if (bl && this.width - f < f) {
                return this.offset + this.length;
            }
            return this.offset;
        }
        int n = this.offset;
        float f2 = 0.0f;
        for (GlyphVector glyphVector : this.glyphs) {
            float f3 = (float)glyphVector.getLogicalBounds().getWidth();
            if (f2 + f3 >= f) {
                float[] fArray = glyphVector.getGlyphPositions(0, glyphVector.getNumGlyphs(), null);
                for (int i = 0; i < glyphVector.getNumGlyphs(); ++i) {
                    float f4;
                    float f5 = f2 + fArray[i << 1];
                    float f6 = f4 = i == glyphVector.getNumGlyphs() - 1 ? this.width : f2 + fArray[(i << 1) + 2];
                    if (!(f4 > f)) continue;
                    if (!bl || f4 - f > f - f5) {
                        return n + i;
                    }
                    return n + i + 1;
                }
            }
            f2 += f3;
            n += glyphVector.getNumGlyphs();
        }
        assert (false) : "Shouldn't reach this.";
        return -1;
    }

    public void init(Segment segment, TabExpander tabExpander, float f, FontRenderContext fontRenderContext, int n) {
        this.initialized = true;
        if (this.accessable) {
            if (this.length == 1 && segment.array[segment.offset + this.offset] == '\t') {
                this.visible = false;
                float f2 = tabExpander.nextTabStop(f, n + this.offset);
                this.width = f2 - f;
            } else {
                this.visible = true;
                this.str = new String(segment.array, segment.offset + this.offset, this.length);
                char[] cArray = segment.array;
                int n2 = segment.offset + this.offset;
                this.width = this.layoutGlyphs(fontRenderContext, cArray, n2, n2 + this.length);
            }
        }
    }

    private static Font[] getFonts() {
        if (fontSubstList == null) {
            Font[] fontArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
            fontSubstList = new Font[preferredFonts.length + fontArray.length];
            System.arraycopy(preferredFonts, 0, fontSubstList, 0, preferredFonts.length);
            System.arraycopy(fontArray, 0, fontSubstList, preferredFonts.length, fontArray.length);
        }
        return fontSubstList;
    }

    private void drawGlyphs(Graphics2D graphics2D, float f, float f2) {
        for (GlyphVector glyphVector : this.glyphs) {
            graphics2D.drawGlyphVector(glyphVector, f, f2);
            f += (float)glyphVector.getLogicalBounds().getWidth();
        }
    }

    private float addGlyphVector(Font font, FontRenderContext fontRenderContext, char[] cArray, int n, int n2) {
        int n3 = 6;
        GlyphVector glyphVector = font.layoutGlyphVector(fontRenderContext, cArray, n, n2, n3);
        font.layoutGlyphVector(fontRenderContext, EMPTY_TEXT, 0, 0, n3);
        this.glyphs.add(glyphVector);
        return (float)glyphVector.getLogicalBounds().getWidth();
    }

    private float layoutGlyphs(FontRenderContext fontRenderContext, char[] cArray, int n, int n2) {
        float f = 0.0f;
        int n3 = 0;
        Font font = this.style.getFont();
        this.glyphs = new LinkedList<GlyphVector>();
        while (n3 != -1 && n < n2) {
            int n4 = n3 = fontSubstEnabled ? font.canDisplayUpTo(cArray, n, n2) : -1;
            if (n3 == -1) {
                f += this.addGlyphVector(font, fontRenderContext, cArray, n, n2);
                continue;
            }
            if (n3 > n) {
                f += this.addGlyphVector(font, fontRenderContext, cArray, n, n3);
                n = n3;
            }
            Font font2 = null;
            for (Font font3 : Chunk.getFonts()) {
                if (!font3.canDisplay(cArray[n])) continue;
                font2 = font3;
                break;
            }
            if (font2 != null) {
                int n5;
                font2 = font2.deriveFont(font.getStyle(), font.getSize());
                for (n5 = n; n5 < n2 && font2.canDisplay(cArray[n5]) && !font.canDisplay(cArray[n5]); ++n5) {
                }
                f += this.addGlyphVector(font2, fontRenderContext, cArray, n, n5);
                n = n5;
                continue;
            }
            f += this.addGlyphVector(font, fontRenderContext, cArray, n, n + 1);
            ++n;
        }
        return f;
    }
}

