/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.TabExpander;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.syntax.Chunk;
import org.gjt.sp.jedit.syntax.DisplayTokenHandler;
import org.gjt.sp.jedit.syntax.TokenMarker;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.jedit.textarea.TextAreaPainter;
import org.gjt.sp.util.Log;

class ChunkCache {
    private final TextArea textArea;
    private JEditBuffer buffer;
    private LineInfo[] lineInfo;
    private final List<Chunk> out;
    private int firstInvalidLine;
    private int lastScreenLineP;
    private int lastScreenLine;
    private boolean needFullRepaint;
    private final DisplayTokenHandler tokenHandler;

    ChunkCache(TextArea textArea) {
        this.textArea = textArea;
        this.out = new ArrayList<Chunk>();
        this.tokenHandler = new DisplayTokenHandler();
    }

    int getMaxHorizontalScrollWidth() {
        int n = 0;
        for (int i = 0; i < this.firstInvalidLine; ++i) {
            LineInfo lineInfo = this.lineInfo[i];
            if (lineInfo.width <= n) continue;
            n = lineInfo.width;
        }
        return n;
    }

    int getScreenLineOfOffset(int n, int n2) {
        if (this.lineInfo.length == 0) {
            return -1;
        }
        if (n < this.textArea.getFirstPhysicalLine()) {
            return -1;
        }
        if (n == this.textArea.getFirstPhysicalLine() && n2 < this.getLineInfo((int)0).offset) {
            return -1;
        }
        if (n > this.textArea.getLastPhysicalLine()) {
            return -1;
        }
        if (n == this.lastScreenLineP) {
            LineInfo lineInfo = this.getLineInfo(this.lastScreenLine);
            if (n2 >= lineInfo.offset && n2 < lineInfo.offset + lineInfo.length) {
                return this.lastScreenLine;
            }
        }
        int n3 = -1;
        for (int i = 0; i < this.textArea.getVisibleLines(); ++i) {
            LineInfo lineInfo = this.getLineInfo(i);
            if (lineInfo.physicalLine > n) {
                return i - 1;
            }
            if (lineInfo.physicalLine != n || n2 < lineInfo.offset || n2 >= lineInfo.offset + lineInfo.length) continue;
            n3 = i;
            break;
        }
        if (n3 == -1) {
            return -1;
        }
        this.lastScreenLineP = n;
        this.lastScreenLine = n3;
        return n3;
    }

    void recalculateVisibleLines() {
        int n;
        LineInfo[] lineInfoArray = new LineInfo[this.textArea.getVisibleLines()];
        if (this.lineInfo == null) {
            n = 0;
        } else {
            n = Math.min(this.lineInfo.length, lineInfoArray.length);
            System.arraycopy(this.lineInfo, 0, lineInfoArray, 0, n);
        }
        for (int i = n; i < lineInfoArray.length; ++i) {
            lineInfoArray[i] = new LineInfo();
        }
        this.lineInfo = lineInfoArray;
        this.lastScreenLineP = -1;
        this.lastScreenLine = -1;
    }

    void setBuffer(JEditBuffer jEditBuffer) {
        this.buffer = jEditBuffer;
        this.lastScreenLineP = -1;
        this.lastScreenLine = -1;
    }

    void scrollDown(int n) {
        int n2 = this.textArea.getVisibleLines();
        System.arraycopy(this.lineInfo, n, this.lineInfo, 0, n2 - n);
        for (int i = n2 - n; i < n2; ++i) {
            this.lineInfo[i] = new LineInfo();
        }
        this.firstInvalidLine -= n;
        if (this.firstInvalidLine < 0) {
            this.firstInvalidLine = 0;
        }
        if (Debug.CHUNK_CACHE_DEBUG) {
            System.err.println("f > t.f: only " + n + " need updates");
        }
        this.lastScreenLineP = -1;
        this.lastScreenLine = -1;
    }

    void scrollUp(int n) {
        int n2;
        System.arraycopy(this.lineInfo, 0, this.lineInfo, n, this.textArea.getVisibleLines() - n);
        for (n2 = 0; n2 < n; ++n2) {
            this.lineInfo[n2] = new LineInfo();
        }
        n2 = this.firstInvalidLine;
        this.firstInvalidLine = 0;
        this.updateChunksUpTo(n);
        this.firstInvalidLine = n2 + n;
        if (this.firstInvalidLine > this.textArea.getVisibleLines()) {
            this.firstInvalidLine = this.textArea.getVisibleLines();
        }
        if (Debug.CHUNK_CACHE_DEBUG) {
            Log.log(1, this, "f > t.f: only " + n + " need updates");
        }
        this.lastScreenLineP = -1;
        this.lastScreenLine = -1;
    }

    void invalidateAll() {
        this.firstInvalidLine = 0;
        this.lastScreenLineP = -1;
        this.lastScreenLine = -1;
    }

    void invalidateChunksFromPhys(int n) {
        for (int i = 0; i < this.firstInvalidLine; ++i) {
            LineInfo lineInfo = this.lineInfo[i];
            if (lineInfo.physicalLine != -1 && lineInfo.physicalLine < n) continue;
            this.firstInvalidLine = i;
            if (i > this.lastScreenLine) break;
            this.lastScreenLineP = -1;
            this.lastScreenLine = -1;
            break;
        }
    }

    LineInfo getLineInfo(int n) {
        this.updateChunksUpTo(n);
        return this.lineInfo[n];
    }

    int getLineSubregionCount(int n) {
        if (!this.textArea.softWrap) {
            return 1;
        }
        this.out.clear();
        this.lineToChunkList(n, this.out);
        int n2 = this.out.size();
        if (n2 == 0) {
            return 1;
        }
        return n2;
    }

    static int getSubregionOfOffset(int n, LineInfo[] lineInfoArray) {
        for (int i = 0; i < lineInfoArray.length; ++i) {
            LineInfo lineInfo = lineInfoArray[i];
            if (n < lineInfo.offset || n >= lineInfo.offset + lineInfo.length) continue;
            return i;
        }
        return -1;
    }

    int xToSubregionOffset(int n, int n2, int n3, boolean bl) {
        LineInfo[] lineInfoArray = this.getLineInfosForPhysicalLine(n);
        if (n2 == -1) {
            n2 += lineInfoArray.length;
        }
        return ChunkCache.xToSubregionOffset(lineInfoArray[n2], n3, bl);
    }

    static int xToSubregionOffset(LineInfo lineInfo, int n, boolean bl) {
        int n2 = Chunk.xToOffset(lineInfo.chunks, n, bl);
        if (n2 == -1 || n2 == lineInfo.offset + lineInfo.length) {
            n2 = lineInfo.offset + lineInfo.length - 1;
        }
        return n2;
    }

    int subregionOffsetToX(int n, int n2) {
        LineInfo[] lineInfoArray = this.getLineInfosForPhysicalLine(n);
        LineInfo lineInfo = lineInfoArray[ChunkCache.getSubregionOfOffset(n2, lineInfoArray)];
        return ChunkCache.subregionOffsetToX(lineInfo, n2);
    }

    static int subregionOffsetToX(LineInfo lineInfo, int n) {
        return (int)Chunk.offsetToX(lineInfo.chunks, n);
    }

    int getSubregionStartOffset(int n, int n2) {
        LineInfo[] lineInfoArray = this.getLineInfosForPhysicalLine(n);
        LineInfo lineInfo = lineInfoArray[ChunkCache.getSubregionOfOffset(n2, lineInfoArray)];
        return this.textArea.getLineStartOffset(lineInfo.physicalLine) + lineInfo.offset;
    }

    int getSubregionEndOffset(int n, int n2) {
        LineInfo[] lineInfoArray = this.getLineInfosForPhysicalLine(n);
        LineInfo lineInfo = lineInfoArray[ChunkCache.getSubregionOfOffset(n2, lineInfoArray)];
        return this.textArea.getLineStartOffset(lineInfo.physicalLine) + lineInfo.offset + lineInfo.length;
    }

    int getBelowPosition(int n, int n2, int n3, boolean bl) {
        LineInfo[] lineInfoArray = this.getLineInfosForPhysicalLine(n);
        int n4 = ChunkCache.getSubregionOfOffset(n2, lineInfoArray);
        if (n4 != lineInfoArray.length - 1 && !bl) {
            return this.textArea.getLineStartOffset(n) + ChunkCache.xToSubregionOffset(lineInfoArray[n4 + 1], n3, true);
        }
        int n5 = this.textArea.displayManager.getNextVisibleLine(n);
        if (n5 == -1) {
            return -1;
        }
        return this.textArea.getLineStartOffset(n5) + this.xToSubregionOffset(n5, 0, n3, true);
    }

    int getAbovePosition(int n, int n2, int n3, boolean bl) {
        LineInfo[] lineInfoArray = this.getLineInfosForPhysicalLine(n);
        int n4 = ChunkCache.getSubregionOfOffset(n2, lineInfoArray);
        if (n4 != 0 && !bl) {
            return this.textArea.getLineStartOffset(n) + ChunkCache.xToSubregionOffset(lineInfoArray[n4 - 1], n3, true);
        }
        int n5 = this.textArea.displayManager.getPrevVisibleLine(n);
        if (n5 == -1) {
            return -1;
        }
        return this.textArea.getLineStartOffset(n5) + this.xToSubregionOffset(n5, -1, n3, true);
    }

    boolean needFullRepaint() {
        boolean bl = this.needFullRepaint;
        this.needFullRepaint = false;
        return bl;
    }

    LineInfo[] getLineInfosForPhysicalLine(int n) {
        this.out.clear();
        if (!this.buffer.isLoading()) {
            this.lineToChunkList(n, this.out);
        }
        if (this.out.isEmpty()) {
            this.out.add(null);
        }
        ArrayList<LineInfo> arrayList = new ArrayList<LineInfo>(this.out.size());
        this.getLineInfosForPhysicalLine(n, arrayList);
        return arrayList.toArray(new LineInfo[this.out.size()]);
    }

    private void getLineInfosForPhysicalLine(int n, List<LineInfo> list) {
        for (int i = 0; i < this.out.size(); ++i) {
            Chunk chunk = this.out.get(i);
            LineInfo lineInfo = new LineInfo();
            lineInfo.physicalLine = n;
            if (i == 0) {
                lineInfo.firstSubregion = true;
                lineInfo.offset = 0;
            } else {
                lineInfo.offset = chunk.offset;
            }
            if (i == this.out.size() - 1) {
                lineInfo.lastSubregion = true;
                lineInfo.length = this.textArea.getLineLength(n) - lineInfo.offset + 1;
            } else {
                lineInfo.length = this.out.get((int)(i + 1)).offset - lineInfo.offset;
            }
            lineInfo.chunks = chunk;
            list.add(lineInfo);
        }
    }

    private int getFirstScreenLine() {
        for (int i = this.firstInvalidLine - 1; i >= 0; --i) {
            if (!this.lineInfo[i].lastSubregion) continue;
            return i + 1;
        }
        return 0;
    }

    private int getUpdateStartLine(int n) {
        if (n == 0) {
            return this.textArea.getFirstPhysicalLine();
        }
        int n2 = this.lineInfo[n - 1].physicalLine;
        if (n2 == -1) {
            return -1;
        }
        return this.textArea.displayManager.getNextVisibleLine(n2);
    }

    private void updateChunksUpTo(int n) {
        if (n >= this.lineInfo.length) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n < this.firstInvalidLine) {
            return;
        }
        int n2 = this.getFirstScreenLine();
        int n3 = this.getUpdateStartLine(n2);
        if (Debug.CHUNK_CACHE_DEBUG) {
            Log.log(1, this, "Updating chunks from " + n2 + " to " + n);
        }
        this.out.clear();
        for (int i = n2; i <= n; ++i) {
            int n4;
            int n5;
            int n6;
            Chunk chunk;
            LineInfo lineInfo = this.lineInfo[i];
            if (this.out.isEmpty()) {
                if (n3 != -1 && i != n2) {
                    n3 = this.textArea.displayManager.getNextVisibleLine(n3);
                }
                if (n3 == -1) {
                    lineInfo.chunks = null;
                    lineInfo.physicalLine = -1;
                    lineInfo.width = 0;
                    continue;
                }
                this.lineToChunkList(n3, this.out);
                lineInfo.firstSubregion = true;
                if (this.out.isEmpty()) {
                    if (i == 0 && this.textArea.displayManager.firstLine.skew > 0) {
                        Log.log(9, this, "BUG: skew=" + this.textArea.displayManager.firstLine.skew + ",out.size()=" + this.out.size());
                        this.textArea.displayManager.firstLine.skew = 0;
                        this.needFullRepaint = true;
                        n = this.lineInfo.length - 1;
                    }
                    chunk = null;
                    n6 = 0;
                    n5 = 1;
                } else {
                    if (i == 0) {
                        n4 = this.textArea.displayManager.firstLine.skew;
                        if (n4 >= this.out.size()) {
                            Log.log(9, this, "BUG: skew=" + n4 + ",out.size()=" + this.out.size());
                            this.needFullRepaint = true;
                            n = this.lineInfo.length - 1;
                        } else if (n4 > 0) {
                            lineInfo.firstSubregion = false;
                            for (int j = 0; j < n4; ++j) {
                                this.out.remove(0);
                            }
                        }
                    }
                    chunk = this.out.remove(0);
                    n6 = chunk.offset;
                    n5 = !this.out.isEmpty() ? this.out.get((int)0).offset - n6 : this.textArea.getLineLength(n3) - n6 + 1;
                }
            } else {
                lineInfo.firstSubregion = false;
                chunk = this.out.remove(0);
                n6 = chunk.offset;
                n5 = !this.out.isEmpty() ? this.out.get((int)0).offset - n6 : this.textArea.getLineLength(n3) - n6 + 1;
            }
            n4 = this.out.isEmpty() ? 1 : 0;
            if (i == n && n != this.lineInfo.length - 1) {
                if (this.tokenHandler.getLineContext() != lineInfo.lineContext) {
                    ++n;
                    this.needFullRepaint = true;
                } else if (lineInfo.physicalLine != n3 || lineInfo.lastSubregion != n4) {
                    ++n;
                    this.needFullRepaint = true;
                } else if (!this.out.isEmpty()) {
                    ++n;
                }
            }
            lineInfo.physicalLine = n3;
            lineInfo.lastSubregion = n4;
            lineInfo.offset = n6;
            lineInfo.length = n5;
            lineInfo.chunks = chunk;
            lineInfo.lineContext = this.tokenHandler.getLineContext();
        }
        this.firstInvalidLine = Math.max(n + 1, this.firstInvalidLine);
    }

    private void lineToChunkList(int n, List<Chunk> list) {
        TextAreaPainter textAreaPainter = this.textArea.getPainter();
        TabExpander tabExpander = this.textArea.getTabExpander();
        this.tokenHandler.init(textAreaPainter.getStyles(), textAreaPainter.getFontRenderContext(), tabExpander, list, this.textArea.softWrap ? (float)this.textArea.wrapMargin : 0.0f, this.buffer.getLineStartOffset(n));
        this.buffer.markTokens(n, this.tokenHandler);
    }

    static class LineInfo {
        int physicalLine;
        int offset;
        int length;
        boolean firstSubregion;
        boolean lastSubregion;
        Chunk chunks;
        int width;
        TokenMarker.LineContext lineContext;

        LineInfo() {
        }

        public String toString() {
            return "LineInfo[" + this.physicalLine + ',' + this.offset + ',' + this.length + ',' + this.firstSubregion + ',' + this.lastSubregion + "]";
        }
    }
}

