/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import org.gjt.sp.jedit.Abbrevs;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PositionChanging;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.options.GlobalOptions;
import org.gjt.sp.jedit.textarea.FoldPainter;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.jedit.textarea.TextAreaException;

public class JEditTextArea
extends TextArea {
    private View view;
    public static final String FOLD_PAINTER_PROPERTY = "foldPainter";
    public static final String FOLD_PAINTER_SERVICE = "org.gjt.sp.jedit.textarea.FoldPainter";
    public static final String DEFAULT_FOLD_PAINTER_SERVICE = "Triangle";

    public JEditTextArea(View view) {
        super(jEdit.getPropertyManager(), view);
        this.enableEvents(12L);
        this.view = view;
        this.painter.setLineExtraSpacing(jEdit.getIntegerProperty("options.textarea.lineSpacing", 0));
        EditBus.addToBus(this);
    }

    @Override
    public FoldPainter getFoldPainter() {
        FoldPainter foldPainter = (FoldPainter)ServiceManager.getService(FOLD_PAINTER_SERVICE, JEditTextArea.getFoldPainterName());
        if (foldPainter == null) {
            foldPainter = (FoldPainter)ServiceManager.getService(FOLD_PAINTER_SERVICE, DEFAULT_FOLD_PAINTER_SERVICE);
        }
        return foldPainter;
    }

    @Override
    public void home(boolean bl) {
        Macros.Recorder recorder = this.view.getMacroRecorder();
        switch (this.getInputHandler().getLastActionCount() % 2) {
            case 1: {
                if (recorder != null) {
                    recorder.record("textArea.goToStartOfWhiteSpace(" + bl + ");");
                }
                this.goToStartOfWhiteSpace(bl);
                break;
            }
            default: {
                if (recorder != null) {
                    recorder.record("textArea.goToStartOfLine(" + bl + ");");
                }
                this.goToStartOfLine(bl);
            }
        }
    }

    @Override
    public void end(boolean bl) {
        Macros.Recorder recorder = this.view.getMacroRecorder();
        switch (this.getInputHandler().getLastActionCount() % 2) {
            case 1: {
                if (recorder != null) {
                    recorder.record("textArea.goToEndOfWhiteSpace(" + bl + ");");
                }
                this.goToEndOfWhiteSpace(bl);
                break;
            }
            default: {
                if (recorder != null) {
                    recorder.record("textArea.goToEndOfLine(" + bl + ");");
                }
                this.goToEndOfLine(bl);
            }
        }
    }

    @Override
    public void smartHome(boolean bl) {
        Macros.Recorder recorder = this.view.getMacroRecorder();
        switch (this.view.getInputHandler().getLastActionCount()) {
            case 1: {
                if (recorder != null) {
                    recorder.record("textArea.goToStartOfWhiteSpace(" + bl + ");");
                }
                this.goToStartOfWhiteSpace(bl);
                break;
            }
            case 2: {
                if (recorder != null) {
                    recorder.record("textArea.goToStartOfLine(" + bl + ");");
                }
                this.goToStartOfLine(bl);
                break;
            }
            default: {
                if (recorder != null) {
                    recorder.record("textArea.goToFirstVisibleLine(" + bl + ");");
                }
                this.goToFirstVisibleLine(bl);
            }
        }
    }

    @Override
    public void smartEnd(boolean bl) {
        Macros.Recorder recorder = this.view.getMacroRecorder();
        switch (this.view.getInputHandler().getLastActionCount()) {
            case 1: {
                if (recorder != null) {
                    recorder.record("textArea.goToEndOfWhiteSpace(" + bl + ");");
                }
                this.goToEndOfWhiteSpace(bl);
                break;
            }
            case 2: {
                if (recorder != null) {
                    recorder.record("textArea.goToEndOfLine(" + bl + ");");
                }
                this.goToEndOfLine(bl);
                break;
            }
            default: {
                if (recorder != null) {
                    recorder.record("textArea.goToLastVisibleLine(" + bl + ");");
                }
                this.goToLastVisibleLine(bl);
            }
        }
    }

    @Override
    public void goToBufferEnd(boolean bl) {
        EditBus.send(new PositionChanging(this));
        super.goToBufferEnd(bl);
    }

    @Override
    public void goToMatchingBracket() {
        int n;
        int n2;
        if (this.getLineLength(this.caretLine) != 0 && (n2 = TextUtilities.findMatchingBracket(this.buffer, this.caretLine, Math.max(0, (n = this.caret - this.getLineStartOffset(this.caretLine)) - 1))) != -1) {
            EditBus.send(new PositionChanging(this));
            this.selectNone();
            this.moveCaretPosition(n2 + 1, false);
            return;
        }
        this.getToolkit().beep();
    }

    @Override
    public void goToBufferStart(boolean bl) {
        EditBus.send(new PositionChanging(this));
        super.goToBufferStart(bl);
    }

    @Override
    public int replaceSelection(String string) {
        EditBus.send(new PositionChanging(this));
        return super.replaceSelection(string);
    }

    public void showGoToLineDialog() {
        String string = GUIUtilities.input(this.view, "goto-line", null);
        if (string == null) {
            return;
        }
        try {
            int n = Integer.parseInt(string) - 1;
            EditBus.send(new PositionChanging(this));
            this.setCaretPosition(this.getLineStartOffset(n));
        }
        catch (Exception exception) {
            this.getToolkit().beep();
        }
    }

    @Override
    public void userInput(char c) {
        if (c == ' ' && Abbrevs.getExpandOnInput() && Abbrevs.expandAbbrev(this.view, false)) {
            return;
        }
        super.userInput(c);
    }

    @Override
    public void addExplicitFold() {
        try {
            super.addExplicitFold();
        }
        catch (TextAreaException textAreaException) {
            GUIUtilities.error(this.view, "folding-not-explicit", null);
        }
    }

    @Override
    public void formatParagraph() {
        try {
            super.formatParagraph();
        }
        catch (TextAreaException textAreaException) {
            GUIUtilities.error(this.view, "format-maxlinelen", null);
        }
    }

    protected static void doWordCount(View view, String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        int n3 = 1;
        boolean bl = true;
        block4: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '\n': 
                case '\r': {
                    ++n3;
                }
                case '\t': 
                case ' ': {
                    bl = true;
                    continue block4;
                }
                default: {
                    if (!bl) continue block4;
                    ++n2;
                    bl = false;
                }
            }
        }
        Object[] objectArray = new Object[]{n, n2, n3};
        GUIUtilities.message(view, "wordcount", objectArray);
    }

    public void showWordCountDialog() {
        String string = this.getSelectedText();
        if (string != null) {
            JEditTextArea.doWordCount(this.view, string);
            return;
        }
        JEditTextArea.doWordCount(this.view, this.buffer.getText(0, this.buffer.getLength()));
    }

    public View getView() {
        return this.view;
    }

    public static String getFoldPainterName() {
        return jEdit.getProperty(FOLD_PAINTER_PROPERTY, DEFAULT_FOLD_PAINTER_SERVICE);
    }

    @Override
    public void handlePopupTrigger(MouseEvent mouseEvent) {
        if (this.popup.isVisible()) {
            this.popup.setVisible(false);
        } else {
            this.createPopupMenu(mouseEvent);
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = this.xyToOffset(n, n2, !this.painter.isBlockCaretEnabled() && !this.isOverwriteEnabled());
            if (this.getSelectionCount() == 0 || this.multi) {
                this.moveCaretPosition(n3, false);
            }
            GUIUtilities.showPopupMenu(this.popup, this.painter, n, n2);
        }
    }

    @Override
    public void createPopupMenu(MouseEvent mouseEvent) {
        this.popup = GUIUtilities.loadPopupMenu("view.context", this, mouseEvent);
        JMenuItem jMenuItem = new JMenuItem(jEdit.getProperty("view.context.customize"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new GlobalOptions((Frame)JEditTextArea.this.view, "context");
            }
        });
        this.popup.addSeparator();
        this.popup.add(jMenuItem);
    }

    @Override
    public void showPopupMenu() {
        Point point;
        if (!this.popup.isVisible() && this.hasFocus() && (point = this.offsetToXY(this.getCaretPosition())) != null) {
            int n = this.getPainter().getLineHeight();
            GUIUtilities.showPopupMenu(this.popup, this.painter, point.x, point.y + n, true);
        }
    }

    @EditBus.EBHandler
    public void handlePropertiesChanged(PropertiesChanged propertiesChanged) {
        this.painter.setLineExtraSpacing(jEdit.getIntegerProperty("options.textarea.lineSpacing", 0));
    }
}

