/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.event.MouseEvent;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.Registers;
import org.gjt.sp.jedit.msg.PositionChanging;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.jedit.textarea.TextAreaMouseHandler;

public class MouseHandler
extends TextAreaMouseHandler {
    private JEditTextArea textArea;

    public MouseHandler(JEditTextArea jEditTextArea) {
        super(jEditTextArea);
        this.textArea = jEditTextArea;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.showCursor();
        this.control = OperatingSystem.isMacOS() && mouseEvent.isMetaDown() || !OperatingSystem.isMacOS() && mouseEvent.isControlDown();
        this.ctrlForRectangularSelection = this.textArea.isCtrlForRectangularSelection();
        this.textArea.getInputHandler().resetLastActionCount();
        boolean bl = this.quickCopyDrag = this.textArea.isQuickCopyEnabled() && MouseHandler.isMiddleButton(mouseEvent.getModifiers());
        if (!this.quickCopyDrag) {
            this.textArea.requestFocus();
            TextArea.focusedComponent = this.textArea;
        }
        if (this.textArea.getBuffer().isLoading()) {
            return;
        }
        EditBus.send(new PositionChanging(this.textArea));
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.dragStart = this.textArea.xyToOffset(n, n2, !this.textArea.getPainter().isBlockCaretEnabled() && !this.textArea.isOverwriteEnabled());
        this.dragStartLine = this.textArea.getLineOfOffset(this.dragStart);
        this.dragStartOffset = this.dragStart - this.textArea.getLineStartOffset(this.dragStartLine);
        if (MouseHandler.isPopupTrigger(mouseEvent) && this.textArea.getRightClickPopup() != null) {
            if (this.textArea.isRightClickPopupEnabled()) {
                this.textArea.handlePopupTrigger(mouseEvent);
            }
            return;
        }
        this.dragged = false;
        this.textArea.blink = true;
        this.textArea.invalidateLine(this.textArea.getCaretLine());
        this.clickCount = mouseEvent.getClickCount();
        if (this.textArea.isDragEnabled() && this.textArea.selectionManager.insideSelection(n, n2) && this.clickCount == 1 && !mouseEvent.isShiftDown()) {
            this.maybeDragAndDrop = true;
            this.textArea.moveCaretPosition(this.dragStart, false);
            return;
        }
        this.maybeDragAndDrop = false;
        if (this.quickCopyDrag) {
            this.doSingleClick(mouseEvent);
        } else {
            switch (this.clickCount) {
                case 1: {
                    this.doSingleClick(mouseEvent);
                    break;
                }
                case 2: {
                    this.doDoubleClick();
                    break;
                }
                default: {
                    this.doTripleClick();
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Selection selection = this.textArea.getSelectionAtOffset(this.dragStart);
        if (this.dragged && selection != null) {
            Registers.setRegister('%', this.textArea.getSelectedText(selection));
            if (this.quickCopyDrag) {
                this.textArea.removeFromSelection(selection);
                Registers.paste(TextArea.focusedComponent, '%', selection instanceof Selection.Rect);
                TextArea.focusedComponent.requestFocus();
            }
        } else if (!this.dragged && this.textArea.isQuickCopyEnabled() && MouseHandler.isMiddleButton(mouseEvent.getModifiers())) {
            this.textArea.requestFocus();
            TextArea.focusedComponent = this.textArea;
            this.textArea.setCaretPosition(this.dragStart, false);
            if (!this.textArea.isEditable()) {
                this.textArea.getToolkit().beep();
            } else {
                Registers.paste((TextArea)this.textArea, '%', this.control);
            }
        } else if (this.maybeDragAndDrop && !this.textArea.isMultipleSelectionEnabled()) {
            this.textArea.selectNone();
        }
        this.maybeDragAndDrop = false;
        this.dragged = false;
        if (!(this.textArea.isRectangularSelectionEnabled() || this.control && this.ctrlForRectangularSelection)) {
            this.textArea.scrollToCaret(false);
        }
    }
}

