/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ProgressObserver;
import org.gjt.sp.util.StandardUtilities;

public class IOUtilities {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean moveFile(File file, File file2) {
        boolean bl;
        block5: {
            bl = false;
            if ((!file2.exists() || !file2.canWrite()) && (file2.exists() || !file2.getParentFile().canWrite())) break block5;
            FileOutputStream fileOutputStream = null;
            FileInputStream fileInputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file2);
                fileInputStream = new FileInputStream(file);
                bl = IOUtilities.copyStream(32768, null, fileInputStream, fileOutputStream, false);
            }
            catch (IOException iOException) {
                try {
                    Log.log(7, IOUtilities.class, "Error moving file: " + iOException + " : " + iOException.getMessage());
                }
                catch (Throwable throwable) {
                    IOUtilities.closeQuietly(fileOutputStream);
                    IOUtilities.closeQuietly(fileInputStream);
                    throw throwable;
                }
                IOUtilities.closeQuietly(fileOutputStream);
                IOUtilities.closeQuietly(fileInputStream);
            }
            IOUtilities.closeQuietly(fileOutputStream);
            IOUtilities.closeQuietly(fileInputStream);
            if (bl) {
                file.delete();
            }
        }
        return bl;
    }

    public static boolean copyStream(int n, ProgressObserver progressObserver, InputStream inputStream, OutputStream outputStream, boolean bl) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        long l = 0L;
        while (-1 != (n2 = inputStream.read(byArray))) {
            outputStream.write(byArray, 0, n2);
            l += (long)n2;
            if (progressObserver != null) {
                progressObserver.setStatus(StandardUtilities.formatFileSize(l));
                progressObserver.setValue(l);
            }
            if (!bl || !Thread.interrupted()) continue;
            return false;
        }
        return true;
    }

    public static boolean copyStream(ProgressObserver progressObserver, InputStream inputStream, OutputStream outputStream, boolean bl) throws IOException {
        return IOUtilities.copyStream(4096, progressObserver, inputStream, outputStream, bl);
    }

    public static long fileLength(File file) {
        long l = 0L;
        if (file.isFile()) {
            l = file.length();
        } else if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                l += IOUtilities.fileLength(fileArray[i]);
            }
        }
        return l;
    }

    public static void closeQuietly(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Writer writer) {
        if (writer != null) {
            try {
                writer.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                if (closeable instanceof Flushable) {
                    ((Flushable)((Object)closeable)).flush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private IOUtilities() {
    }
}

