/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.gjt.sp.util.Task;
import org.gjt.sp.util.TaskListener;

public class TaskManager {
    public static final TaskManager instance = new TaskManager();
    private final List<TaskListener> listeners = new CopyOnWriteArrayList<TaskListener>();
    private final List<Task> tasks = Collections.synchronizedList(new ArrayList());

    private TaskManager() {
    }

    public int countTasks() {
        return this.tasks.size();
    }

    public void addTaskListener(TaskListener taskListener) {
        if (!this.listeners.contains(taskListener)) {
            this.listeners.add(taskListener);
        }
    }

    public void removeTaskListener(TaskListener taskListener) {
        if (this.listeners.contains(taskListener)) {
            this.listeners.remove(taskListener);
        }
    }

    void fireWaiting(Task task) {
        this.tasks.add(task);
        List<TaskListener> list = this.listeners;
        for (TaskListener taskListener : list) {
            taskListener.waiting(task);
        }
    }

    void fireRunning(Task task) {
        List<TaskListener> list = this.listeners;
        for (TaskListener taskListener : list) {
            taskListener.running(task);
        }
    }

    void fireDone(Task task) {
        this.tasks.remove(task);
        List<TaskListener> list = this.listeners;
        for (TaskListener taskListener : list) {
            taskListener.done(task);
        }
    }

    void fireStatusUpdated(Task task) {
        List<TaskListener> list = this.listeners;
        for (TaskListener taskListener : list) {
            taskListener.statusUpdated(task);
        }
    }

    void fireValueUpdated(Task task) {
        List<TaskListener> list = this.listeners;
        for (TaskListener taskListener : list) {
            taskListener.valueUpdated(task);
        }
    }

    void fireMaximumUpdated(Task task) {
        List<TaskListener> list = this.listeners;
        for (TaskListener taskListener : list) {
            taskListener.maximumUpdated(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(TaskVisitor taskVisitor) {
        List<Task> list = this.tasks;
        synchronized (list) {
            for (Task task : this.tasks) {
                taskVisitor.visit(task);
            }
        }
    }

    static Task decorate(Runnable runnable) {
        return new MyTask(runnable);
    }

    private static class MyTask
    extends Task {
        private final Runnable runnable;

        private MyTask(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void _run() {
            this.runnable.run();
        }
    }

    public static interface TaskVisitor {
        public void visit(Task var1);
    }
}

