/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.util;

import java.awt.EventQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.Task;
import org.gjt.sp.util.TaskManager;

public class ThreadUtilities {
    private static final ExecutorService threadPool = Executors.newCachedThreadPool(new JEditThreadFactory());
    private static final int CORE_POOL_SIZE = 4;

    public static void runInDispatchThread(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runInDispatchThreadAndWait(Runnable runnable) {
        MyRunnable myRunnable = new MyRunnable(runnable);
        ThreadUtilities.runInDispatchThread(myRunnable);
        while (!myRunnable.done) {
            MyRunnable myRunnable2 = myRunnable;
            synchronized (myRunnable2) {
                try {
                    myRunnable.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    Log.log(9, ThreadUtilities.class, interruptedException);
                }
            }
        }
    }

    public static void runInBackground(Runnable runnable) {
        Task task = runnable instanceof Task ? (Task)runnable : TaskManager.decorate(runnable);
        TaskManager.instance.fireWaiting(task);
        threadPool.execute(task);
    }

    public static void runInBackground(Task task) {
        TaskManager.instance.fireWaiting(task);
        threadPool.execute(task);
    }

    private ThreadUtilities() {
    }

    static {
        ((ThreadPoolExecutor)threadPool).setCorePoolSize(4);
    }

    private static class MyRunnable
    implements Runnable {
        private final Runnable runnable;
        private volatile boolean done;

        private MyRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.runnable.run();
            this.done = true;
            MyRunnable myRunnable = this;
            synchronized (myRunnable) {
                this.notifyAll();
            }
        }
    }

    private static class JEditThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadIDs = new AtomicInteger(0);
        private final ThreadGroup threadGroup = new ThreadGroup("jEdit Workers");

        private JEditThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(this.threadGroup, runnable);
            thread.setName("jEdit Worker #" + this.threadIDs.getAndIncrement());
            return thread;
        }
    }
}

