/*
 * Decompiled with CFR 0.152.
 */
package errorlist;

import errorlist.ErrorSource;
import errorlist.ErrorSourceUpdate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import javax.swing.text.Position;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;

public class DefaultErrorSource
extends ErrorSource {
    protected String name;
    protected int errorCount;
    protected Map<String, ErrorListForPath> errors = new LinkedHashMap<String, ErrorListForPath>();
    private boolean addedToBus;

    public DefaultErrorSource(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public ErrorSource.Error[] getAllErrors() {
        if (this.errors.size() == 0) {
            return null;
        }
        LinkedList linkedList = new LinkedList();
        Iterator<ErrorListForPath> iterator = this.errors.values().iterator();
        while (iterator.hasNext()) {
            linkedList.addAll(iterator.next());
        }
        return linkedList.toArray(new ErrorSource.Error[linkedList.size()]);
    }

    public int getFileErrorCount(String string) {
        ErrorListForPath errorListForPath = this.errors.get(string);
        if (errorListForPath == null) {
            return 0;
        }
        return errorListForPath.size();
    }

    public ErrorSource.Error[] getFileErrors(String string) {
        ErrorListForPath errorListForPath = this.errors.get(string);
        if (errorListForPath == null || errorListForPath.size() == 0) {
            return null;
        }
        return errorListForPath.toArray(new ErrorSource.Error[errorListForPath.size()]);
    }

    public ErrorSource.Error[] getLineErrors(String string, int n, int n2) {
        if (this.errors.size() == 0) {
            return null;
        }
        ErrorListForPath errorListForPath = this.errors.get(string);
        if (errorListForPath == null) {
            return null;
        }
        Collection<ErrorSource.Error> collection = errorListForPath.subSetInLineRange(n, n2);
        if (collection.size() == 0) {
            return null;
        }
        return collection.toArray(new ErrorSource.Error[collection.size()]);
    }

    public synchronized void clear() {
        if (this.errorCount == 0) {
            return;
        }
        this.errors.clear();
        this.errorCount = 0;
        this.removeOrAddToBus();
        if (this.registered) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ErrorSourceUpdate errorSourceUpdate = new ErrorSourceUpdate(DefaultErrorSource.this, ErrorSourceUpdate.ERRORS_CLEARED, null);
                    EditBus.send((EBMessage)errorSourceUpdate);
                }
            });
        }
    }

    public synchronized void removeFileErrors(String string) {
        final ErrorListForPath errorListForPath = this.errors.remove(string);
        if (errorListForPath == null) {
            return;
        }
        this.errorCount -= errorListForPath.size();
        this.removeOrAddToBus();
        if (this.registered) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    for (ErrorSource.Error error : errorListForPath) {
                        ErrorSourceUpdate errorSourceUpdate = new ErrorSourceUpdate(DefaultErrorSource.this, ErrorSourceUpdate.ERROR_REMOVED, error);
                        EditBus.send((EBMessage)errorSourceUpdate);
                    }
                }
            });
        }
    }

    public synchronized void addError(final DefaultError defaultError) {
        ErrorListForPath errorListForPath = this.errors.get(defaultError.getFilePath());
        if (errorListForPath == null) {
            errorListForPath = new ErrorListForPath();
            this.errors.put(defaultError.getFilePath(), errorListForPath);
        }
        if (errorListForPath.add(defaultError)) {
            ++this.errorCount;
            this.removeOrAddToBus();
            if (this.registered) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ErrorSourceUpdate errorSourceUpdate = new ErrorSourceUpdate(DefaultErrorSource.this, ErrorSourceUpdate.ERROR_ADDED, defaultError);
                        EditBus.send((EBMessage)errorSourceUpdate);
                    }
                });
            }
        }
    }

    public void addError(int n, String string, int n2, int n3, int n4, String string2) {
        DefaultError defaultError = new DefaultError(this, n, string, n2, n3, n4, string2);
        this.addError(defaultError);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.name + "]";
    }

    @EditBus.EBHandler
    public synchronized void handleBufferMessage(BufferUpdate bufferUpdate) {
        block4: {
            ErrorListForPath errorListForPath;
            Buffer buffer;
            block3: {
                buffer = bufferUpdate.getBuffer();
                if (bufferUpdate.getWhat() != BufferUpdate.LOADED) break block3;
                ErrorListForPath errorListForPath2 = this.errors.get(buffer.getSymlinkPath());
                if (errorListForPath2 == null) break block4;
                Iterator iterator = errorListForPath2.iterator();
                while (iterator.hasNext()) {
                    ((DefaultError)iterator.next()).openNotify(buffer);
                }
                break block4;
            }
            if (bufferUpdate.getWhat() == BufferUpdate.CLOSED && (errorListForPath = this.errors.get(buffer.getSymlinkPath())) != null) {
                Iterator iterator = errorListForPath.iterator();
                while (iterator.hasNext()) {
                    ((DefaultError)iterator.next()).closeNotify(buffer);
                }
            }
        }
    }

    protected void removeOrAddToBus() {
        if (this.addedToBus && this.errorCount == 0) {
            this.addedToBus = false;
            EditBus.removeFromBus((Object)this);
        } else if (!this.addedToBus && this.errorCount != 0) {
            this.addedToBus = true;
            EditBus.addToBus((Object)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ErrorListForPath
    extends TreeSet<ErrorSource.Error> {
        public ErrorListForPath() {
            super(new ErrorComparator());
        }

        public Collection<ErrorSource.Error> subSetInLineRange(int n, int n2) {
            return this.subSet(new LineKey(n), new LineKey(n2 + 1));
        }

        private static class LineKey
        implements ErrorSource.Error {
            private int line;

            public LineKey(int n) {
                this.line = n;
            }

            public int getLineNumber() {
                return this.line;
            }

            public String getErrorMessage() {
                return "";
            }

            public int getErrorType() {
                return 0;
            }

            public ErrorSource getErrorSource() {
                return null;
            }

            public Buffer getBuffer() {
                return null;
            }

            public String getFilePath() {
                return null;
            }

            public String getFileName() {
                return null;
            }

            public int getStartOffset() {
                return 0;
            }

            public int getEndOffset() {
                return 0;
            }

            public String[] getExtraMessages() {
                return null;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class ErrorComparator
        implements Comparator<ErrorSource.Error> {
            private ErrorComparator() {
            }

            @Override
            public int compare(ErrorSource.Error error, ErrorSource.Error error2) {
                String string;
                int n;
                int n2;
                int n3 = error.getLineNumber();
                if (n3 < (n2 = error2.getLineNumber())) {
                    return -1;
                }
                if (n3 > n2) {
                    return 1;
                }
                int n4 = error.getStartOffset();
                if (n4 < (n = error2.getStartOffset())) {
                    return -1;
                }
                if (n4 > n) {
                    return 1;
                }
                n4 = error.getEndOffset();
                if (n4 < (n = error2.getEndOffset())) {
                    return -1;
                }
                if (n4 > n) {
                    return 1;
                }
                String string2 = error.getErrorMessage();
                int n5 = string2.compareTo(string = error2.getErrorMessage());
                if (n5 != 0) {
                    return n5;
                }
                return 0;
            }
        }
    }

    public static class DefaultError
    implements ErrorSource.Error {
        DefaultError next;
        private ErrorSource source;
        private int type;
        private String path;
        private String name;
        private Buffer buffer;
        private int lineIndex;
        private int start;
        private int end;
        private Position linePos;
        private Position startPos;
        private Position endPos;
        private String error;
        private List<String> extras;

        public DefaultError(ErrorSource errorSource, int n, String string, int n2, int n3, int n4, String string2) {
            this.source = errorSource;
            this.type = n;
            if (MiscUtilities.isURL((String)string)) {
                this.path = string;
            } else {
                this.path = MiscUtilities.constructPath((String)System.getProperty("user.dir"), (String)string);
                this.path = MiscUtilities.resolveSymlinks((String)this.path);
            }
            this.lineIndex = n2;
            this.start = n3;
            this.end = n4;
            this.error = string2;
            this.name = MiscUtilities.getFileName((String)string);
            Buffer buffer = jEdit.getBuffer((String)this.path);
            if (buffer != null && buffer.isLoaded()) {
                this.openNotify(buffer);
            }
        }

        public ErrorSource getErrorSource() {
            return this.source;
        }

        public int getErrorType() {
            return this.type;
        }

        public Buffer getBuffer() {
            return this.buffer;
        }

        public String getFilePath() {
            return this.path;
        }

        public void setFilePath(String string) {
            this.path = string;
            this.name = this.path.substring(this.path.lastIndexOf(47));
        }

        public String getFileName() {
            return this.name;
        }

        public int getLineNumber() {
            if (this.startPos != null) {
                return this.buffer.getLineOfOffset(this.startPos.getOffset());
            }
            return this.lineIndex;
        }

        public int getStartOffset() {
            if (this.startPos != null) {
                return this.startPos.getOffset() - this.buffer.getLineStartOffset(this.getLineNumber());
            }
            return this.start;
        }

        public int getEndOffset() {
            if (this.endPos != null) {
                return this.endPos.getOffset() - this.buffer.getLineStartOffset(this.getLineNumber());
            }
            return this.end;
        }

        public String getErrorMessage() {
            return this.error;
        }

        public void addExtraMessage(String string) {
            if (this.extras == null) {
                this.extras = new ArrayList<String>();
            }
            this.extras.add(string);
        }

        public String[] getExtraMessages() {
            if (this.extras == null) {
                return new String[0];
            }
            return this.extras.toArray(new String[this.extras.size()]);
        }

        public String toString() {
            return this.getFileName() + ":" + (this.getLineNumber() + 1) + ":" + this.getErrorMessage();
        }

        void openNotify(Buffer buffer) {
            this.buffer = buffer;
            int n = Math.min(this.lineIndex, buffer.getLineCount() - 1);
            this.start = Math.min(this.start, buffer.getLineLength(n));
            int n2 = buffer.getLineStartOffset(n);
            this.startPos = buffer.createPosition(n2 + this.start);
            this.endPos = this.end != 0 ? buffer.createPosition(n2 + this.end) : null;
        }

        void closeNotify(Buffer buffer) {
            this.buffer = null;
            this.linePos = null;
            this.startPos = null;
            this.endPos = null;
        }
    }
}

