/*
 * Decompiled with CFR 0.152.
 */
package errorlist;

import errorlist.ErrorList;
import errorlist.ErrorSource;
import java.awt.Graphics2D;
import java.awt.Point;
import javax.swing.ImageIcon;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.TextAreaExtension;

public class ErrorGutterIcon
extends TextAreaExtension {
    private EditPane editPane;
    private static final int FOLD_MARKER_SIZE = 12;

    public ErrorGutterIcon(EditPane editPane) {
        this.editPane = editPane;
    }

    public String getToolTipText(int n, int n2) {
        ErrorSource[] errorSourceArray = ErrorSource.getErrorSources();
        if (!this.editPane.getBuffer().isLoaded()) {
            return null;
        }
        JEditTextArea jEditTextArea = this.editPane.getTextArea();
        int n3 = jEditTextArea.xyToOffset(n, n2);
        if (n3 == -1) {
            return null;
        }
        int n4 = jEditTextArea.getLineOfOffset(n3);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < errorSourceArray.length; ++i) {
            ErrorSource.Error[] errorArray = errorSourceArray[i].getLineErrors(this.editPane.getBuffer().getSymlinkPath(), n4, n4);
            if (errorArray == null) continue;
            stringBuffer.append("<html>");
            for (int j = 0; j < errorArray.length; ++j) {
                ErrorSource.Error error = errorArray[j];
                stringBuffer.append(error.getErrorMessage());
                stringBuffer.append("<br>");
                for (String string : error.getExtraMessages()) {
                    stringBuffer.append("__");
                    stringBuffer.append(string);
                    stringBuffer.append("<br>");
                }
            }
            stringBuffer.append("</html>");
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.toString();
        }
        return null;
    }

    public void paintValidLine(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
        ErrorSource[] errorSourceArray = ErrorSource.getErrorSources();
        if (errorSourceArray == null) {
            return;
        }
        for (int i = 0; i < errorSourceArray.length; ++i) {
            ErrorSource.Error[] errorArray = errorSourceArray[i].getLineErrors(this.editPane.getBuffer().getSymlinkPath(), n2, n2);
            if (errorArray == null) continue;
            boolean bl = false;
            for (int j = 0; j < errorArray.length; ++j) {
                if (errorArray[j].getErrorType() != 0) continue;
                bl = true;
                break;
            }
            JEditTextArea jEditTextArea = this.editPane.getTextArea();
            ImageIcon imageIcon = bl ? ErrorList.ERROR_ICON : ErrorList.WARNING_ICON;
            int n6 = jEditTextArea.getPainter().getFontMetrics().getHeight();
            Point point = new Point((12 - imageIcon.getIconWidth()) / 2, n5 + (n6 - imageIcon.getIconHeight()) / 2);
            graphics2D.drawImage(imageIcon.getImage(), point.x, point.y, null);
        }
    }
}

