/*
 * Decompiled with CFR 0.152.
 */
package errorlist;

import errorlist.ErrorListPlugin;
import errorlist.ErrorSource;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.textarea.JEditTextArea;

public class ErrorOverview
extends JPanel {
    private static final int WIDTH = 10;
    private static final int HILITE_HEIGHT = 2;
    private EditPane editPane;

    public ErrorOverview(final EditPane editPane) {
        super(new BorderLayout());
        this.editPane = editPane;
        this.setRequestFocusEnabled(false);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                int n = ErrorOverview.this.yToLine(mouseEvent.getY());
                JEditTextArea jEditTextArea = editPane.getTextArea();
                if (n >= 0 && n < jEditTextArea.getLineCount()) {
                    jEditTextArea.setCaretPosition(jEditTextArea.getLineStartOffset(n));
                }
            }
        });
    }

    public void invalidateLine(int n) {
        this.repaint(0, this.lineToY(n), this.getWidth(), 2);
    }

    public void addNotify() {
        super.addNotify();
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void removeNotify() {
        super.removeNotify();
        ToolTipManager.sharedInstance().unregisterComponent(this);
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        Buffer buffer = this.editPane.getBuffer();
        int n = buffer.getLineCount();
        int n2 = this.yToLine(mouseEvent.getY());
        JEditTextArea jEditTextArea = this.editPane.getTextArea();
        if (n2 >= 0 && n2 < jEditTextArea.getLineCount()) {
            ErrorSource[] errorSourceArray = ErrorSource.getErrorSources();
            for (int i = 0; i < errorSourceArray.length; ++i) {
                ErrorSource.Error[] errorArray = errorSourceArray[i].getLineErrors(buffer.getSymlinkPath(), n2, n2);
                if (errorArray == null && n2 != 0) {
                    errorArray = errorSourceArray[i].getLineErrors(buffer.getPath(), n2 - 1, n2 - 1);
                }
                if (errorArray == null && n2 != n - 1) {
                    errorArray = errorSourceArray[i].getLineErrors(buffer.getPath(), n2 + 1, n2 + 1);
                }
                if (errorArray == null) continue;
                return errorArray[0].getErrorMessage();
            }
        }
        return null;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        ErrorSource[] errorSourceArray = ErrorSource.getErrorSources();
        if (errorSourceArray == null) {
            return;
        }
        Buffer buffer = this.editPane.getBuffer();
        Rectangle rectangle = graphics.getClipBounds();
        int n = buffer.getLineCount();
        int n2 = this.yToLine(rectangle.y);
        int n3 = this.yToLine(rectangle.y + rectangle.height);
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 >= n) {
            n3 = n - 1;
        }
        for (int i = 0; i < errorSourceArray.length; ++i) {
            ErrorSource.Error[] errorArray = errorSourceArray[i].getLineErrors(buffer.getSymlinkPath(), n2, n3);
            if (errorArray == null) continue;
            for (int j = 0; j < errorArray.length; ++j) {
                ErrorSource.Error error = errorArray[j];
                int n4 = error.getLineNumber();
                if (n4 < n2 || n4 > n3) {
                    System.err.println("WTF: " + n4);
                }
                int n5 = this.lineToY(n4);
                graphics.setColor(ErrorListPlugin.getErrorColor(errorArray[j].getErrorType()));
                graphics.fillRect(0, n5, this.getWidth(), 2);
            }
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(10, 0);
    }

    private int lineToY(int n) {
        return n * this.getHeight() / this.editPane.getBuffer().getLineCount();
    }

    private int yToLine(int n) {
        return n * this.editPane.getBuffer().getLineCount() / this.getHeight();
    }
}

