/*
 * Decompiled with CFR 0.152.
 */
package console;

import console.CommandOutputParser;
import console.Console;
import console.Shell;
import console.SystemShell;
import console.commando.CommandoCommand;
import console.commando.CommandoToolBar;
import errorlist.DefaultErrorSource;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeMap;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.JEditAbstractEditAction;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.DynamicMenuChanged;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StringList;

public class ConsolePlugin
extends EditPlugin {
    private static String consoleDirectory;
    private static String userCommandDirectory;
    private static ActionSet allCommands;
    private static ActionSet shellSwitchActions;
    static CommandoToolBar toolBar;
    public static final String MENU = "plugin.console.ConsolePlugin.menu";
    public static final String CMD_PATH = "/console/bsh/";
    public static final int NO_ERROR = -1;
    private static HashMap<View, CommandOutputParser> sm_parsers;

    public static SystemShell getSystemShell() {
        return (SystemShell)ServiceManager.getService((String)"console.Shell", (String)"System");
    }

    public static ActionSet getShellSwitchActions() {
        return shellSwitchActions;
    }

    public static ActionSet getAllCommands() {
        return allCommands;
    }

    public void start() {
        File file;
        BeanShell.getNameSpace().addCommandPath(CMD_PATH, ((Object)((Object)this)).getClass());
        String settings = jEdit.getSettingsDirectory();
        if (settings != null && !(file = new File(userCommandDirectory = MiscUtilities.constructPath((String)(consoleDirectory = MiscUtilities.constructPath((String)settings, (String)"console")), (String)"commando"))).exists()) {
            file.mkdirs();
        }
        allCommands = new ActionSet("Plugin: Console - Commando Commands");
        shellSwitchActions = new ActionSet("Plugin: Console - Shell Switchers");
        ConsolePlugin.rescanCommands();
        CommandoToolBar.init();
        EditBus.addToBus((Object)((Object)this));
    }

    public static synchronized int parseLine(View view, String text, String directory, DefaultErrorSource errorSource) {
        CommandOutputParser parser = ConsolePlugin.getParser(view, directory, errorSource);
        return parser.processLine(text, false);
    }

    public void stop() {
        EditBus.removeFromBus((Object)((Object)this));
        View[] views = jEdit.getViews();
        for (int i = 0; i < views.length; ++i) {
            Console console = ConsolePlugin.getConsole(views[i]);
            if (console == null) continue;
            console.unload();
        }
        BeanShell.getNameSpace().addCommandPath(CMD_PATH, ((Object)((Object)this)).getClass());
        CommandoToolBar.remove();
        jEdit.removeActionSet((ActionSet)allCommands);
        jEdit.removeActionSet((ActionSet)shellSwitchActions);
    }

    @EditBus.EBHandler
    public void handleViewUpdate(ViewUpdate vmsg) {
        if (vmsg.getWhat() == ViewUpdate.CREATED) {
            View v = vmsg.getView();
            CommandoToolBar.create(v);
        }
    }

    @EditBus.EBHandler
    public void handlePluginUpdate(PluginUpdate msg) {
        ConsolePlugin.rescanShells();
    }

    public static String getConsoleSettingsDirectory() {
        return consoleDirectory;
    }

    public static void scanDirectory(String directory) {
        File[] files;
        if (directory != null && (files = new File(directory).listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                String fileName = file.getAbsolutePath();
                if (!fileName.endsWith(".xml") || file.isHidden()) continue;
                CommandoCommand action = CommandoCommand.create(fileName);
                allCommands.addAction((EditAction)action);
            }
        }
    }

    public static void scanJarFile() {
        String defaultCommands = jEdit.getProperty((String)"commando.default");
        StringList sl = StringList.split((String)defaultCommands, (Object)" ");
        for (String name : sl) {
            String key = "commando." + name;
            if (allCommands.contains(key)) continue;
            String resourceName = "/console/commands/" + name + ".xml";
            URL url = Console.class.getResource(resourceName);
            if (url != null) {
                CommandoCommand action = CommandoCommand.create(url);
                allCommands.addAction((EditAction)action);
                continue;
            }
            Log.log((int)9, (Object)"ConsolePlugin", (Object)("Unable to access resource: " + resourceName));
        }
    }

    static void rescanShells() {
        jEdit.removeActionSet((ActionSet)shellSwitchActions);
        shellSwitchActions.removeAllActions();
        for (String shell : Shell.getShellNames()) {
            Shell.SwitchAction ac1 = new Shell.SwitchAction(shell);
            Shell.ToggleAction ac2 = new Shell.ToggleAction(shell);
            shellSwitchActions.addAction((EditAction)ac1);
            shellSwitchActions.addAction((EditAction)ac2);
        }
        jEdit.addActionSet((ActionSet)shellSwitchActions);
        ConsolePlugin.redoKeyboardBindings(shellSwitchActions);
        EditBus.send((EBMessage)new DynamicMenuChanged(MENU));
    }

    public static void rescanCommands() {
        jEdit.removeActionSet((ActionSet)allCommands);
        allCommands.removeAllActions();
        ConsolePlugin.scanDirectory(userCommandDirectory);
        ConsolePlugin.scanJarFile();
        ConsolePlugin.redoKeyboardBindings(allCommands);
        ConsolePlugin.rescanShells();
        jEdit.addActionSet((ActionSet)allCommands);
        Log.log((int)1, ConsolePlugin.class, (Object)("Loaded " + allCommands.size() + " Actions"));
    }

    private static void redoKeyboardBindings(ActionSet actionSet) {
        EditAction[] ea = actionSet.getActions();
        for (int i = 0; i < ea.length; ++i) {
            String shortcut2;
            String shortcut1 = jEdit.getProperty((String)(ea[i].getName() + ".shortcut"));
            if (shortcut1 != null) {
                jEdit.getInputHandler().addKeyBinding(shortcut1, (JEditAbstractEditAction)ea[i]);
            }
            if ((shortcut2 = jEdit.getProperty((String)(ea[i].getName() + ".shortcut2"))) == null) continue;
            jEdit.getInputHandler().addKeyBinding(shortcut2, (JEditAbstractEditAction)ea[i]);
        }
    }

    public static EditAction[] getSwitchActions() {
        EditAction[] actions = ConsolePlugin.getShellSwitchActions().getActions();
        Arrays.sort(actions, new ActionCompare());
        return actions;
    }

    public static EditAction[] getCommandoCommands() {
        String[] names = allCommands.getActionNames();
        TreeMap<String, JEditAbstractEditAction> actions = new TreeMap<String, JEditAbstractEditAction>();
        for (String name : names) {
            boolean visible;
            String label = name;
            if (label.startsWith("commando.")) {
                label = name.substring(9);
            }
            if (!(visible = jEdit.getBooleanProperty((String)("commando.visible." + label), (boolean)true))) continue;
            actions.put(label, allCommands.getAction(name));
        }
        EditAction[] ar = new EditAction[actions.size()];
        return actions.values().toArray(ar);
    }

    public static void compile(View view, Buffer buffer) {
        String compiler = buffer.getStringProperty("commando.compile");
        if (compiler == null || compiler.length() == 0) {
            GUIUtilities.error((Component)view, (String)"commando.no-compiler", null);
            return;
        }
        CommandoCommand command = (CommandoCommand)allCommands.getAction("commando." + compiler);
        if (command == null) {
            GUIUtilities.error((Component)view, (String)"commando.no-command", (Object[])new String[]{compiler});
        } else {
            Object[] args;
            int result;
            if (buffer.isDirty() && ((result = GUIUtilities.confirm((Component)view, (String)"commando.not-saved-compile", (Object[])(args = new Object[]{buffer.getName()}), (int)1, (int)2)) == 0 ? !buffer.save(view, null, true) : result != 1)) {
                return;
            }
            command.invoke(view);
        }
    }

    public static Console getConsole(View v) {
        DockableWindowManager dwm = v.getDockableWindowManager();
        return (Console)dwm.getDockable("console");
    }

    public static void run(View view, Buffer buffer) {
        String interpreter = buffer.getStringProperty("commando.run");
        if (interpreter == null || interpreter.length() == 0) {
            GUIUtilities.error((Component)view, (String)"commando.no-interpreter", null);
            return;
        }
        CommandoCommand command = (CommandoCommand)allCommands.getAction("commando." + interpreter);
        if (command == null) {
            GUIUtilities.error((Component)view, (String)"commando.no-command", (Object[])new String[]{interpreter});
        } else {
            Object[] args;
            int result;
            if (buffer.isDirty() && ((result = GUIUtilities.confirm((Component)view, (String)"commando.not-saved-run", (Object[])(args = new Object[]{buffer.getName()}), (int)1, (int)2)) == 0 ? !buffer.save(view, null, true) : result != 1)) {
                return;
            }
            command.invoke(view);
        }
    }

    public static String getPackageName(Buffer buffer) {
        StringReader in = new StringReader(buffer.getText(0, buffer.getLength()));
        try {
            StreamTokenizer stok = new StreamTokenizer(in);
            stok.slashStarComments(true);
            stok.slashSlashComments(true);
            while (stok.nextToken() != -1) {
                if (stok.sval == null) continue;
                if (stok.sval.equals("package")) {
                    stok.nextToken();
                    in.close();
                    return stok.sval;
                }
                if (!stok.sval.equals("class")) continue;
                in.close();
                return null;
            }
            in.close();
        }
        catch (IOException io) {
            throw new InternalError();
        }
        return null;
    }

    public static String getClassName(Buffer buffer) {
        String pkg = ConsolePlugin.getPackageName(buffer);
        String clazz = MiscUtilities.getFileNameNoExtension((String)buffer.getPath());
        if (pkg == null) {
            return clazz;
        }
        return pkg + '.' + clazz;
    }

    public static String getPackageRoot(Buffer buffer) {
        String pkg = ConsolePlugin.getPackageName(buffer);
        String path = MiscUtilities.getParentOfPath((String)buffer.getPath());
        if (path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - 1);
        }
        if (pkg == null) {
            return path;
        }
        if (path.endsWith(pkg = pkg.replace('.', File.separatorChar))) {
            return path.substring(0, path.length() - pkg.length());
        }
        return path;
    }

    public static String expandSystemShellVariables(View view, String text) {
        return ConsolePlugin.getSystemShell().expandVariables(view, text);
    }

    public static String getSystemShellVariableValue(View view, String var) {
        return ConsolePlugin.getSystemShell().getVariableValue(view, var);
    }

    public static void setSystemShellVariableValue(String var, String value) {
        ConsolePlugin.getSystemShell().getVariables().put(var, value);
    }

    public static String getUserCommandDirectory() {
        return userCommandDirectory;
    }

    private static CommandOutputParser getParser(View v, String dir, DefaultErrorSource es) {
        if (sm_parsers == null) {
            sm_parsers = new HashMap();
        }
        CommandOutputParser retval = sm_parsers.get(v);
        Console console = ConsolePlugin.getConsole(v);
        if (retval == null) {
            retval = new CommandOutputParser(v, es, console.getPlainColor());
            sm_parsers.put(v, retval);
        }
        retval.setDirectory(dir);
        return retval;
    }

    static {
        toolBar = null;
    }

    static class ActionCompare
    implements Comparator<EditAction> {
        ActionCompare() {
        }

        @Override
        public int compare(EditAction a1, EditAction a2) {
            return a1.getLabel().compareTo(a2.getLabel());
        }
    }
}

