/*
 * Decompiled with CFR 0.152.
 */
package console;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StringList;

public abstract class ProcessRunner {
    private static ProcessRunner instance;

    abstract boolean shellExpandsGlobs();

    abstract boolean isCaseSensitive();

    abstract String shellPrefix();

    final boolean supportsEnvironmentVariables() {
        return true;
    }

    void setUpDefaultAliases(Hashtable<String, String> aliases2) {
    }

    private void prependUserPath(Map<String, String> environment) {
        String extra = jEdit.getProperty((String)"console.shell.pathdirs");
        boolean appendExtra = jEdit.getBooleanProperty((String)"console.shell.pathdirs.append");
        if (extra == null || extra.length() == 0) {
            return;
        }
        String oldPath = environment.get("PATH");
        String newPath = extra;
        if (oldPath != null) {
            newPath = appendExtra ? oldPath + File.pathSeparator + extra : extra + File.pathSeparator + oldPath;
        }
        environment.put("PATH", newPath);
    }

    Process exec(String[] args, Map<String, String> env2, String dir) throws IOException {
        String prefix = jEdit.getProperty((String)"console.shell.prefix", (String)"osdefault");
        StringList arglist = new StringList();
        if (prefix != null && prefix.length() >= 1) {
            arglist = StringList.split((String)prefix, (Object)" ");
            if (((String)arglist.get(0)).equals("none")) {
                arglist.clear();
            } else if (((String)arglist.get(0)).equals("osdefault")) {
                prefix = instance.shellPrefix();
                arglist = StringList.split((String)prefix, (Object)" ");
            }
        }
        if (arglist.size() > 0 && ((String)arglist.get(0)).contains("bash")) {
            StringList qargs = new StringList();
            for (String a : args) {
                if (a.contains(" ")) {
                    if (a.contains("\"")) {
                        qargs.add((Object)("'" + a + "'"));
                        continue;
                    }
                    qargs.add((Object)("\"" + a + "\""));
                    continue;
                }
                qargs.add((Object)a);
            }
            String cmd = StringList.join((Collection)qargs, (String)" ");
            arglist.add((Object)cmd);
        } else {
            arglist.addAll((Object[])args);
        }
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        Map<String, String> processEnv = processBuilder.environment();
        processEnv.clear();
        processEnv.putAll(env2);
        this.prependUserPath(processEnv);
        processBuilder.directory(new File(dir));
        boolean merge = jEdit.getBooleanProperty((String)"console.processrunner.mergeError", (boolean)true);
        processBuilder.redirectErrorStream(merge);
        processBuilder.command(arglist.toArray());
        try {
            return processBuilder.start();
        }
        catch (Exception e) {
            Log.log((int)9, (Object)e, (Object)"Process Runner");
            return null;
        }
    }

    public static ProcessRunner getProcessRunner() {
        if (instance == null) {
            if (OperatingSystem.isWindows9x()) {
                instance = new Windows9x();
            } else if (OperatingSystem.isWindowsNT()) {
                instance = new WindowsNT();
            } else if (OperatingSystem.isUnix()) {
                instance = new Unix();
            } else {
                Log.log((int)7, ProcessRunner.class, (Object)"Unknown operating system");
                instance = new Generic();
            }
        }
        return instance;
    }

    static class WindowsNT
    extends Windows {
        WindowsNT() {
        }

        @Override
        String shellPrefix() {
            return "cmd /c";
        }
    }

    static class Windows9x
    extends Windows {
        Windows9x() {
        }

        @Override
        void setUpDefaultAliases(Hashtable<String, String> aliases2) {
            String[] builtins = new String[]{"md", "rd", "del", "copy", "move", "erase", "mkdir", "rmdir", "start", "echo", "path", "ver", "vol", "ren", "type"};
            for (int i = 0; i < builtins.length; ++i) {
                aliases2.put(builtins[i], "%" + builtins[i]);
            }
        }

        Process exec(String[] args, String[] env2, String dir) throws IOException {
            String commandName = args[0];
            String[] extensionsToTry = commandName.indexOf(46) == -1 ? this.getExtensionsToTry() : new String[]{""};
            for (int i = 0; i < extensionsToTry.length; ++i) {
                args[0] = commandName + extensionsToTry[i];
                try {
                    ProcessBuilder processBuilder = new ProcessBuilder(args);
                    processBuilder.environment().clear();
                    for (String assignment : env2) {
                        String[] split = assignment.split("=");
                        processBuilder.environment().put(split[0], split[1]);
                    }
                    processBuilder.directory(new File(dir));
                    processBuilder.redirectErrorStream(true);
                    return processBuilder.start();
                }
                catch (Exception e) {
                    if (i != extensionsToTry.length - 1) continue;
                    throw new RuntimeException(jEdit.getProperty((String)"console.shell.not-found-win", (Object[])new String[]{commandName}));
                }
            }
            return null;
        }

        String[] getExtensionsToTry() {
            return new String[]{".exe", ".com"};
        }

        @Override
        String shellPrefix() {
            return "command.com /c";
        }
    }

    static abstract class Windows
    extends ProcessRunner {
        Windows() {
        }

        @Override
        boolean shellExpandsGlobs() {
            return false;
        }

        @Override
        boolean isCaseSensitive() {
            return false;
        }
    }

    static class Unix
    extends ProcessRunner {
        Unix() {
        }

        @Override
        void setUpDefaultAliases(Hashtable<String, String> aliases2) {
            aliases2.put("del", "rm");
            aliases2.put("copy", "cp");
            aliases2.put("ren", "mv");
        }

        @Override
        boolean shellExpandsGlobs() {
            return true;
        }

        @Override
        boolean isCaseSensitive() {
            return true;
        }

        @Override
        String shellPrefix() {
            return "/bin/bash -c";
        }
    }

    static class Generic
    extends ProcessRunner {
        Generic() {
        }

        @Override
        boolean shellExpandsGlobs() {
            return true;
        }

        @Override
        boolean isCaseSensitive() {
            return true;
        }

        @Override
        String shellPrefix() {
            return "bash -c";
        }
    }
}

