/*
 * Decompiled with CFR 0.152.
 */
package console.commando;

import console.ConsolePlugin;
import console.commando.CommandoButton;
import console.commando.CommandoCommand;
import console.commando.CommandoDialog;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JToolBar;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.DynamicMenuChanged;

public class CommandoToolBar
extends JToolBar {
    private View view;
    static HashMap<View, CommandoToolBar> smToolBarMap = new HashMap();

    public static void init() {
        CommandoToolBar.remove();
        View[] views = jEdit.getViews();
        for (int i = 0; i < views.length; ++i) {
            CommandoToolBar.create(views[i]);
        }
    }

    public static CommandoToolBar create(View view) {
        if (!jEdit.getBooleanProperty((String)"commando.toolbar.enabled")) {
            return null;
        }
        CommandoToolBar tb = new CommandoToolBar(view);
        view.addToolBar((Component)tb);
        smToolBarMap.put(view, tb);
        return tb;
    }

    public static void remove() {
        for (View v : smToolBarMap.keySet()) {
            CommandoToolBar tb;
            if (v == null || (tb = smToolBarMap.get(v)) == null) continue;
            v.removeToolBar((Component)tb);
        }
        smToolBarMap.clear();
    }

    private CommandoToolBar(View dockable) {
        this.view = dockable;
        this.setLayout(new BoxLayout(this, 0));
        this.setFloatable(true);
        this.updateButtons();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        EditBus.addToBus((Object)this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        EditBus.removeFromBus((Object)this);
    }

    @EditBus.EBHandler
    public void handleMessage(DynamicMenuChanged msg) {
        if ("plugin.console.ConsolePlugin.menu".equals(msg.getMenuName())) {
            this.updateButtons();
        }
    }

    private void updateButtons() {
        this.removeAll();
        ActionListener actionHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new CommandoDialog(CommandoToolBar.this.view, evt.getActionCommand());
            }
        };
        EditAction[] commands = ConsolePlugin.getCommandoCommands();
        for (int i = 0; i < commands.length; ++i) {
            CommandoCommand command = (CommandoCommand)commands[i];
            CommandoButton button = new CommandoButton(command);
            button.setActionCommand(command.getName());
            button.addActionListener(actionHandler);
            button.setRequestFocusEnabled(false);
            button.setMargin(new Insets(1, 2, 1, 2));
            this.add(button);
        }
        this.add(Box.createGlue());
    }
}

