/*
 * Decompiled with CFR 0.152.
 */
package com.ctreber.aclib.image.ico;

import com.ctreber.aclib.codec.AbstractDecoder;
import com.ctreber.aclib.image.ico.AbstractBitmap;
import com.ctreber.aclib.image.ico.BitmapDescriptor;
import com.ctreber.aclib.image.ico.BitmapMask;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import org.apache.log4j.Logger;

public abstract class AbstractBitmapIndexed
extends AbstractBitmap {
    private static final Logger LOG;
    private static final int OPAQUE = 255;
    private Color[] _colorPalette;
    protected int[] _pixels = new int[this.getWidth() * this.getHeight()];
    private BitmapMask _transparencyMask;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ctreber.aclib.image.ico.AbstractBitmapIndexed");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = Logger.getLogger(clazz);
    }

    public AbstractBitmapIndexed(BitmapDescriptor bitmapDescriptor) {
        super(bitmapDescriptor);
    }

    void read(AbstractDecoder abstractDecoder) throws IOException {
        this.readColorPalette(abstractDecoder);
        this.readBitmap(abstractDecoder);
        this.readMask(abstractDecoder);
    }

    private void readColorPalette(AbstractDecoder abstractDecoder) throws IOException {
        int n = this.getVerifiedColorCount();
        this._colorPalette = new Color[n];
        int n2 = 0;
        while (n2 < n) {
            this.setColor(n2, this.readColor(abstractDecoder));
            ++n2;
        }
    }

    private Color readColor(AbstractDecoder abstractDecoder) throws IOException {
        short s = abstractDecoder.readUInt1();
        short s2 = abstractDecoder.readUInt1();
        short s3 = abstractDecoder.readUInt1();
        abstractDecoder.readUInt1();
        return new Color(s3, s2, s);
    }

    abstract void readBitmap(AbstractDecoder var1) throws IOException;

    private void readMask(AbstractDecoder abstractDecoder) throws IOException {
        this._transparencyMask = new BitmapMask(this._descriptor);
        this._transparencyMask.read(abstractDecoder);
    }

    private int getVerifiedColorCount() {
        int n;
        int n2 = this.getColorCount();
        if (n2 < (n = 1 << this._descriptor.getBPP())) {
            LOG.warn("Number of specified colors is smaller than color count calculated from bits per pixel (will trust the latter): " + n2 + "/" + n);
            n2 = n;
        }
        return n2;
    }

    protected static int getBytesPerScanLine(int n, int n2) {
        double d = (double)n2 / 8.0;
        int n3 = (int)Math.ceil((double)n * d);
        if ((n3 & 3) != 0) {
            n3 = (n3 & 0xFFFFFFFC) + 4;
        }
        return n3;
    }

    public BufferedImage createImageIndexed() {
        IndexColorModel indexColorModel = this.createColorModel();
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 13, indexColorModel);
        bufferedImage.getRaster().setSamples(0, 0, this.getWidth(), this.getHeight(), 0, this._pixels);
        return bufferedImage;
    }

    private IndexColorModel createColorModel() {
        int n = this.getVerifiedColorCount();
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        byte[] byArray4 = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            Color color = this.getColor(n2);
            byArray[n2] = (byte)color.getRed();
            byArray2[n2] = (byte)color.getGreen();
            byArray3[n2] = (byte)color.getBlue();
            byArray4[n2] = -1;
            ++n2;
        }
        IndexColorModel indexColorModel = new IndexColorModel(8, n, byArray, byArray2, byArray3, byArray4);
        return indexColorModel;
    }

    public BufferedImage createImageRGB() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        int n = 0;
        while (n < this.getHeight()) {
            int n2 = 0;
            while (n2 < this.getWidth()) {
                int n3 = this.getColor(n2, n).getRGB();
                n3 = this._transparencyMask.isOpaque(n2, n) ? (n3 |= 0xFF000000) : (n3 &= 0xFFFFFF);
                bufferedImage.setRGB(n2, n, n3);
                ++n2;
            }
            ++n;
        }
        return bufferedImage;
    }

    public Color getColor(int n, int n2) {
        return this.getColor(this.getPaletteIndex(n, n2));
    }

    public int getPaletteIndex(int n, int n2) {
        return this._pixels[n2 * this.getWidth() + n];
    }

    public Color getColor(int n) {
        if (n >= this.getVerifiedColorCount()) {
            throw new IllegalArgumentException("Color index out of range: is " + n + ", max. " + this.getVerifiedColorCount());
        }
        return this._colorPalette[n];
    }

    private void setColor(int n, Color color) {
        this._colorPalette[n] = color;
    }
}

