/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.collection;

import org.jacorb.collection.IteratorFactory;
import org.jacorb.collection.KeySortedCollectionImpl;
import org.jacorb.collection.PositionalIteratorImpl;
import org.jacorb.collection.util.ObjectInvalid;
import org.omg.CORBA.Any;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CosCollection.Collection;
import org.omg.CosCollection.ElementInvalid;
import org.omg.CosCollection.ElementInvalidReason;
import org.omg.CosCollection.EqualityKeySortedCollectionOperations;
import org.omg.CosCollection.Iterator;
import org.omg.CosCollection.IteratorInBetween;
import org.omg.CosCollection.IteratorInvalid;
import org.omg.CosCollection.OperationsOperations;
import org.omg.PortableServer.POA;

class EqualityKeySortedCollectionImpl
extends KeySortedCollectionImpl
implements EqualityKeySortedCollectionOperations {
    EqualityKeySortedCollectionImpl(OperationsOperations ops, POA poa, IteratorFactory iterator_factory) {
        super(ops, poa, iterator_factory);
    }

    @Override
    public synchronized boolean contains_element(Any element) throws ElementInvalid {
        this.check_element(element);
        try {
            return this.data.indexOf(element) >= 0;
        }
        catch (ObjectInvalid e) {
            throw new ElementInvalid(ElementInvalidReason.element_type_invalid);
        }
    }

    @Override
    public synchronized boolean contains_all_from(Collection collector) throws ElementInvalid {
        throw new NO_IMPLEMENT();
    }

    @Override
    public synchronized boolean locate_or_add_element(Any element) throws ElementInvalid {
        this.check_element(element);
        try {
            if (this.data.indexOf(element) < 0) {
                this.element_add(element);
                return false;
            }
            return true;
        }
        catch (ObjectInvalid e) {
            throw new ElementInvalid(ElementInvalidReason.element_type_invalid);
        }
    }

    @Override
    public synchronized boolean locate_or_add_element_set_iterator(Any element, Iterator where) throws ElementInvalid, IteratorInvalid {
        this.check_element(element);
        PositionalIteratorImpl i = this.check_iterator(where);
        try {
            int pos = this.data.indexOf(element);
            if (pos < 0) {
                pos = this.element_add(element);
                i.set_pos(pos);
                i.set_in_between(false);
                return false;
            }
            i.set_pos(pos);
            i.set_in_between(false);
            return true;
        }
        catch (ObjectInvalid e) {
            throw new ElementInvalid(ElementInvalidReason.element_type_invalid);
        }
    }

    @Override
    public synchronized boolean locate_element(Any element, Iterator where) throws ElementInvalid, IteratorInvalid {
        this.check_element(element);
        PositionalIteratorImpl i = this.check_iterator(where);
        try {
            int pos = this.data.indexOf(element);
            if (pos >= 0) {
                i.set_pos(pos);
                i.set_in_between(false);
                return true;
            }
            i.invalidate();
            return false;
        }
        catch (ObjectInvalid e) {
            throw new ElementInvalid(ElementInvalidReason.element_type_invalid);
        }
    }

    @Override
    public synchronized boolean locate_next_element(Any element, Iterator where) throws ElementInvalid, IteratorInvalid {
        this.check_element(element);
        PositionalIteratorImpl i = this.check_iterator(where);
        i.check_invalid();
        try {
            int pos = this.data.indexOf(element);
            if (pos >= 0) {
                int new_pos;
                int n = new_pos = i.is_in_between() ? pos : pos + 1;
                while (new_pos < this.data.size() && this.ops.compare(element, (Any)this.data.elementAt(new_pos)) == 0) {
                    if (this.ops.equal(element, (Any)this.data.elementAt(new_pos))) {
                        i.set_pos(new_pos);
                        i.set_in_between(false);
                        return true;
                    }
                    ++new_pos;
                }
            }
            i.invalidate();
            return false;
        }
        catch (ObjectInvalid e) {
            throw new ElementInvalid(ElementInvalidReason.element_type_invalid);
        }
    }

    @Override
    public synchronized boolean locate_next_different_element(Iterator where) throws IteratorInvalid, IteratorInBetween {
        PositionalIteratorImpl i = this.check_iterator(where);
        i.check_iterator();
        int pos = i.get_pos();
        Any element = (Any)this.data.elementAt(pos);
        if (pos >= 0) {
            for (int new_pos = pos + 1; new_pos < this.data.size(); ++new_pos) {
                if (this.ops.compare(element, (Any)this.data.elementAt(new_pos)) == 0 && this.ops.equal(element, (Any)this.data.elementAt(new_pos))) continue;
                i.set_pos(new_pos);
                i.set_in_between(false);
                return true;
            }
        }
        i.invalidate();
        return false;
    }

    @Override
    public synchronized boolean remove_element(Any element) throws ElementInvalid {
        this.check_element(element);
        try {
            int pos = this.data.indexOf(element);
            if (pos >= 0) {
                this.element_remove(0);
                return true;
            }
            return false;
        }
        catch (ObjectInvalid e) {
            throw new ElementInvalid(ElementInvalidReason.element_type_invalid);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new INTERNAL();
        }
    }

    @Override
    public synchronized int remove_all_occurrences(Any element) throws ElementInvalid {
        this.check_element(element);
        try {
            int pos = this.data.indexOf(element);
            int count = 0;
            while (pos < this.data.size() && this.ops.equal(element, (Any)this.data.elementAt(pos))) {
                this.element_remove(pos);
                ++count;
            }
            return count;
        }
        catch (ObjectInvalid e) {
            throw new ElementInvalid(ElementInvalidReason.element_type_invalid);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new INTERNAL();
        }
    }

    @Override
    public synchronized int number_of_different_elements() {
        throw new NO_IMPLEMENT();
    }

    @Override
    public synchronized int number_of_occurrences(Any element) throws ElementInvalid {
        throw new NO_IMPLEMENT();
    }

    @Override
    public synchronized Iterator create_iterator(boolean read_only) {
        return this.create_ordered_iterator(read_only, false);
    }
}

