/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import java.util.Iterator;
import java.util.List;
import org.jacorb.notification.NoTranslationException;
import org.jacorb.notification.filter.ComponentName;
import org.jacorb.notification.filter.EvaluationContext;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.EvaluationResult;
import org.jacorb.notification.filter.RuntimeVariable;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.FilterStage;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.util.AbstractPoolable;
import org.omg.CORBA.Any;
import org.omg.CORBA.AnyHolder;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.MappingFilter;
import org.omg.CosNotifyFilter.UnsupportedFilterableData;

public abstract class AbstractMessage
extends AbstractPoolable {
    protected boolean proxyConsumerFiltered_;
    protected boolean supplierAdminFiltered_;
    protected boolean consumerAdminFiltered_;
    protected boolean proxySupplierFiltered_;
    private FilterStage currentFilterStage_;
    private long receiveTimestamp_;
    protected int referenced_ = 0;

    public abstract String getConstraintKey();

    public long getReceiveTimestamp() {
        return this.receiveTimestamp_;
    }

    public abstract Any toAny();

    public abstract Property[] toTypedEvent() throws NoTranslationException;

    public abstract StructuredEvent toStructuredEvent();

    public abstract int getType();

    @Override
    public final synchronized void reset() {
        this.referenced_ = 0;
        this.currentFilterStage_ = null;
        this.doReset();
    }

    protected void doReset() {
    }

    public synchronized void addReference() {
        ++this.referenced_;
    }

    protected synchronized void removeReference() {
        if (this.referenced_ > 0) {
            --this.referenced_;
        }
        if (this.referenced_ == 0) {
            super.dispose();
        }
    }

    public void setFilterStage(FilterStage node) {
        this.currentFilterStage_ = node;
    }

    public FilterStage getFilterStage() {
        return this.currentFilterStage_;
    }

    public EvaluationResult extractValue(EvaluationContext context, ComponentName componentRootNode, RuntimeVariable runtimeVariable) throws EvaluationException {
        EvaluationResult _ret = null;
        String _completePath = componentRootNode.getComponentName();
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("extractValue: " + _completePath);
            this.logger_.debug("runtimeVariable=" + runtimeVariable);
        }
        if ((_ret = context.lookupResult(_completePath)) == null) {
            _ret = runtimeVariable.evaluate(context);
            _ret = context.extractFromMessage(_ret, componentRootNode, runtimeVariable);
            context.storeResult(_completePath, _ret);
        }
        if (_ret == null) {
            throw new EvaluationException("Could not resolve " + _completePath);
        }
        return _ret;
    }

    public abstract EvaluationResult extractFilterableData(EvaluationContext var1, ComponentName var2, String var3) throws EvaluationException;

    public abstract EvaluationResult extractVariableHeader(EvaluationContext var1, ComponentName var2, String var3) throws EvaluationException;

    public EvaluationResult extractValue(EvaluationContext evaluationContext, ComponentName componentRootNode) throws EvaluationException {
        EvaluationResult _ret = null;
        String _completeExpr = componentRootNode.getComponentName();
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("extractValue path: " + componentRootNode.toStringTree() + "\n\tcomplete Expression=" + _completeExpr);
        }
        _ret = evaluationContext.lookupResult(_completeExpr);
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("Cache READ: " + _ret);
        }
        if (_ret == null) {
            this.logger_.debug("Cache MISS");
            _ret = evaluationContext.extractFromMessage(this, componentRootNode);
            if (_ret != null) {
                if (this.logger_.isDebugEnabled()) {
                    this.logger_.debug("Cache WRITE: " + _completeExpr + " => " + _ret);
                }
                evaluationContext.storeResult(_completeExpr, _ret);
            }
        }
        if (_ret == null) {
            throw new EvaluationException("Could not resolve " + _completeExpr);
        }
        return _ret;
    }

    public Message getHandle() {
        return new MessageHandle();
    }

    public void initReceiveTimestamp() {
        this.receiveTimestamp_ = System.currentTimeMillis();
    }

    public abstract boolean hasStartTime();

    public abstract long getStartTime();

    public abstract boolean hasStopTime();

    public abstract long getStopTime();

    public abstract boolean hasTimeout();

    public abstract long getTimeout();

    public abstract int getPriority();

    public abstract boolean match(Filter var1) throws UnsupportedFilterableData;

    public boolean match(FilterStage filterStage) {
        List _filterList = filterStage.getFilters();
        if (_filterList.isEmpty()) {
            return true;
        }
        Iterator _filterIterator = _filterList.iterator();
        while (_filterIterator.hasNext()) {
            try {
                Filter _filter = (Filter)_filterIterator.next();
                if (!this.match(_filter)) continue;
                return true;
            }
            catch (UnsupportedFilterableData e) {
                this.logger_.info("unsupported filterable data. match result defaults to false.", (Throwable)((Object)e));
            }
            catch (Exception e) {
                this.logger_.warn("unexpected error during match. match result defaults to false", (Throwable)e);
            }
        }
        return false;
    }

    public abstract boolean match(MappingFilter var1, AnyHolder var2) throws UnsupportedFilterableData;

    public static String calcConstraintKey(String domain_name, String type_name) {
        if ("".equals(domain_name)) {
            domain_name = "*";
        }
        if ("".equals(type_name)) {
            type_name = "*";
        }
        StringBuffer _buffer = new StringBuffer(domain_name);
        _buffer.append("_%_");
        _buffer.append(type_name);
        return _buffer.toString();
    }

    class MessageHandle
    implements Message,
    Disposable {
        private Message.MessageStateListener eventStateListener_;
        private boolean isInvalid_ = false;
        private boolean isPriorityOverridden = false;
        private int priority_;
        private boolean isTimeoutOverridden_ = false;
        private long timeOut_;

        MessageHandle() {
            AbstractMessage.this.addReference();
        }

        private MessageHandle(int priority, boolean priorityOverride, long timeout, boolean timeoutOverride) {
            AbstractMessage.this.addReference();
            this.priority_ = priority;
            this.isPriorityOverridden = priorityOverride;
            this.timeOut_ = timeout;
            this.isTimeoutOverridden_ = timeoutOverride;
        }

        public void setInitialFilterStage(FilterStage s) {
            AbstractMessage.this.setFilterStage(s);
        }

        @Override
        public FilterStage getInitialFilterStage() {
            return AbstractMessage.this.getFilterStage();
        }

        @Override
        public String getConstraintKey() {
            return AbstractMessage.this.getConstraintKey();
        }

        @Override
        public Any toAny() {
            return AbstractMessage.this.toAny();
        }

        @Override
        public Property[] toTypedEvent() throws NoTranslationException {
            return AbstractMessage.this.toTypedEvent();
        }

        @Override
        public StructuredEvent toStructuredEvent() {
            return AbstractMessage.this.toStructuredEvent();
        }

        @Override
        public int getType() {
            return AbstractMessage.this.getType();
        }

        @Override
        public EvaluationResult extractValue(EvaluationContext context, ComponentName componentName, RuntimeVariable runtimeVariable) throws EvaluationException {
            return AbstractMessage.this.extractValue(context, componentName, runtimeVariable);
        }

        @Override
        public EvaluationResult extractValue(EvaluationContext context, ComponentName componentName) throws EvaluationException {
            return AbstractMessage.this.extractValue(context, componentName);
        }

        @Override
        public EvaluationResult extractFilterableData(EvaluationContext context, ComponentName componentRootNode, String variable) throws EvaluationException {
            return AbstractMessage.this.extractFilterableData(context, componentRootNode, variable);
        }

        @Override
        public EvaluationResult extractVariableHeader(EvaluationContext context, ComponentName componentName, String s) throws EvaluationException {
            return AbstractMessage.this.extractVariableHeader(context, componentName, s);
        }

        @Override
        public boolean hasStartTime() {
            return AbstractMessage.this.hasStartTime();
        }

        @Override
        public long getStartTime() {
            return AbstractMessage.this.getStartTime();
        }

        @Override
        public boolean hasStopTime() {
            return AbstractMessage.this.hasStopTime();
        }

        @Override
        public long getStopTime() {
            return AbstractMessage.this.getStopTime();
        }

        @Override
        public boolean hasTimeout() {
            return this.isTimeoutOverridden_ || AbstractMessage.this.hasTimeout();
        }

        @Override
        public long getTimeout() {
            if (this.isTimeoutOverridden_) {
                return this.timeOut_;
            }
            return AbstractMessage.this.getTimeout();
        }

        @Override
        public void setTimeout(long timeout) {
            this.timeOut_ = timeout;
            this.isTimeoutOverridden_ = true;
            if (this.eventStateListener_ != null) {
                this.eventStateListener_.actionLifetimeChanged(timeout);
            }
        }

        @Override
        public void setPriority(int priority) {
            this.isPriorityOverridden = true;
            this.priority_ = priority;
        }

        @Override
        public int getPriority() {
            if (this.isPriorityOverridden) {
                return this.priority_;
            }
            return AbstractMessage.this.getPriority();
        }

        @Override
        public boolean match(FilterStage s) {
            return AbstractMessage.this.match(s);
        }

        @Override
        public boolean match(MappingFilter m, AnyHolder r) throws UnsupportedFilterableData {
            return AbstractMessage.this.match(m, r);
        }

        @Override
        public Object clone() {
            try {
                this.checkInvalid();
                return new MessageHandle(this.priority_, this.isPriorityOverridden, this.timeOut_, this.isTimeoutOverridden_);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public void dispose() {
            AbstractMessage.this.removeReference();
        }

        @Override
        public synchronized boolean isInvalid() {
            return this.isInvalid_;
        }

        @Override
        public void setMessageStateListener(Message.MessageStateListener listener) {
            this.eventStateListener_ = listener;
        }

        @Override
        public Message.MessageStateListener removeMessageStateListener() {
            Message.MessageStateListener _listener = this.eventStateListener_;
            this.eventStateListener_ = null;
            return _listener;
        }

        @Override
        public synchronized void actionTimeout() {
            this.isInvalid_ = true;
        }

        @Override
        public long getReceiveTimestamp() {
            return AbstractMessage.this.getReceiveTimestamp();
        }

        public String toString() {
            return "[Message/" + AbstractMessage.this + "]";
        }

        private void checkInvalid() throws IllegalArgumentException {
            if (this.isInvalid()) {
                throw new IllegalArgumentException("This Notification has been invalidated");
            }
        }
    }
}

