/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import org.jacorb.notification.AbstractMessage;
import org.jacorb.notification.filter.EventTypeIdentifier;
import org.omg.CosNotification.EventType;

public class EventTypeWrapper
implements EventTypeIdentifier,
Comparable {
    private final EventType eventType_;
    private final String constraintKey_;
    public static final EventType EVENT_TYPE_ALL = new EventType("", "%ALL");
    public static final EventType[] EMPTY_EVENT_TYPE_ARRAY = new EventType[0];

    public EventTypeWrapper(EventType eventType) {
        this.eventType_ = eventType;
        this.constraintKey_ = AbstractMessage.calcConstraintKey(eventType.domain_name, eventType.type_name);
    }

    public EventType getEventType() {
        return this.eventType_;
    }

    public String toString() {
        return EventTypeWrapper.toString(this.eventType_);
    }

    public boolean equals(Object other) {
        try {
            return EventTypeWrapper.equals(this.eventType_, ((EventTypeWrapper)other).eventType_);
        }
        catch (ClassCastException e) {
            return super.equals(other);
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public int compareTo(Object o) {
        try {
            EventTypeWrapper _other = (EventTypeWrapper)o;
            int _compare = this.eventType_.domain_name.compareTo(_other.eventType_.domain_name);
            if (_compare == 0) {
                _compare = this.eventType_.type_name.compareTo(_other.eventType_.type_name);
            }
            return _compare;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException();
        }
    }

    public static String toString(EventType et) {
        StringBuffer buffer = new StringBuffer();
        EventTypeWrapper.appendEventTypeToBuffer(et, buffer);
        return buffer.toString();
    }

    private static void appendEventTypeToBuffer(EventType et, StringBuffer buffer) {
        buffer.append(et.domain_name);
        buffer.append("/");
        buffer.append(et.type_name);
    }

    public static String toString(EventType[] ets) {
        StringBuffer b = new StringBuffer("[");
        for (int x = 0; x < ets.length; ++x) {
            EventTypeWrapper.appendEventTypeToBuffer(ets[x], b);
            if (x >= ets.length - 1) continue;
            b.append(", ");
        }
        b.append("]");
        return b.toString();
    }

    public static boolean equals(EventType left, EventType right) {
        return left.domain_name.equals(right.domain_name) && left.type_name.equals(right.type_name);
    }

    @Override
    public String getConstraintKey() {
        return this.constraintKey_;
    }
}

