/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.notification.MessageFactory;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.interfaces.MessageSupplier;
import org.jacorb.notification.servant.AbstractProxyConsumer;
import org.jacorb.notification.servant.ITypedAdmin;
import org.jacorb.notification.servant.ITypedProxy;
import org.jacorb.notification.servant.MessageSupplierDelegate;
import org.jacorb.notification.servant.PullMessagesOperation;
import org.jacorb.notification.servant.PullMessagesUtility;
import org.jacorb.notification.servant.TypedProxyPullConsumerImplMBean;
import org.omg.CORBA.Any;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.InterfaceDefPackage.FullInterfaceDescription;
import org.omg.CORBA.NVList;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.OperationDescription;
import org.omg.CORBA.Request;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventChannelAdmin.TypeError;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosNotifyChannelAdmin.ProxyType;
import org.omg.CosNotifyChannelAdmin.SupplierAdmin;
import org.omg.CosTypedEventComm.TypedPullSupplier;
import org.omg.CosTypedNotifyChannelAdmin.TypedProxyPullConsumerOperations;
import org.omg.CosTypedNotifyChannelAdmin.TypedProxyPullConsumerPOATie;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class TypedProxyPullConsumerImpl
extends AbstractProxyConsumer
implements TypedProxyPullConsumerOperations,
MessageSupplier,
MessageSupplierDelegate,
ITypedProxy,
TypedProxyPullConsumerImplMBean {
    private String[] tryPullOperations_;
    private TypedPullSupplier pullSupplier_;
    private Object typedPullSupplier_;
    private InterfaceDef interfaceDef_;
    private final String supportedInterface_;
    private final Map operationDescriptions_ = new HashMap();
    private final Map fullQualifiedOperationNames_ = new HashMap();
    private final PullMessagesUtility pollUtil_;
    private long pollInterval_;
    private final PullMessagesOperation pullMessagesOperation_;

    public TypedProxyPullConsumerImpl(ITypedAdmin admin, SupplierAdmin supplierAdmin, ORB orb, POA poa, Configuration config, TaskProcessor taskProcessor, MessageFactory messageFactory, OfferManager offerManager, SubscriptionManager subscriptionManager) {
        super(admin, orb, poa, config, taskProcessor, messageFactory, supplierAdmin, offerManager, subscriptionManager);
        this.supportedInterface_ = admin.getSupportedInterface();
        this.pollUtil_ = new PullMessagesUtility(taskProcessor, this);
        try {
            this.pollInterval_ = config.getAttributeAsLong("jacorb.notification.supplier.poll_intervall", 1000L);
        }
        catch (ConfigurationException ex) {
            config.getLogger("TypedProxyPullConsumerImpl").error("Error configuring jacorb.notification.supplier.poll_intervall", (Throwable)ex);
            throw new INTERNAL("Error configuring TypedProxyPullConsumerImpl" + (java.lang.Object)((java.lang.Object)ex));
        }
        this.pullMessagesOperation_ = new PullMessagesOperation(this);
    }

    @Override
    public void connect_typed_pull_supplier(TypedPullSupplier typedPullSupplier) throws AlreadyConnected, TypeError {
        this.logger_.info("connect typed_pull_supplier");
        this.checkIsNotConnected();
        this.connectClient(typedPullSupplier);
        this.pullSupplier_ = typedPullSupplier;
        this.typedPullSupplier_ = this.pullSupplier_.get_typed_supplier();
        this.interfaceDef_ = InterfaceDefHelper.narrow((Object)this.typedPullSupplier_._get_interface_def());
        if (this.interfaceDef_ == null) {
            throw new TypeError("Could not access Interface Definition for TypedPullSupplier [" + this.typedPullSupplier_ + "]");
        }
        if (!this.typedPullSupplier_._is_a(this.supportedInterface_)) {
            throw new TypeError();
        }
        this.pollUtil_.startTask(this.pollInterval_);
    }

    private String[] getTryPullOperations() {
        if (this.tryPullOperations_ == null) {
            FullInterfaceDescription _fullIfDescription = this.interfaceDef_.describe_interface();
            for (int x = 0; x < _fullIfDescription.operations.length; ++x) {
                if (!_fullIfDescription.operations[x].name.startsWith("try_")) continue;
                this.operationDescriptions_.put(_fullIfDescription.operations[x].name, _fullIfDescription.operations[x]);
            }
            this.tryPullOperations_ = this.operationDescriptions_.keySet().toArray(new String[this.operationDescriptions_.size()]);
        }
        return this.tryPullOperations_;
    }

    @Override
    public MessageSupplierDelegate.PullResult pullMessages() {
        String[] _tryPullOperations = this.getTryPullOperations();
        HashMap<String, Request> _successFulRequests = new HashMap<String, Request>();
        for (int x = 0; x < _tryPullOperations.length; ++x) {
            Request _request = this.prepareRequest(_tryPullOperations[x]);
            if (this.logger_.isDebugEnabled()) {
                this.logger_.debug("invoke " + _tryPullOperations[x]);
            }
            try {
                _request.invoke();
                Any _result = _request.result().value();
                boolean _success = _result.extract_boolean();
                if (!_success) continue;
                String _operationNameWithoutTry = _tryPullOperations[x].substring(4);
                _successFulRequests.put(_operationNameWithoutTry, _request);
                continue;
            }
            catch (Exception e) {
                if (!this.logger_.isInfoEnabled()) continue;
                String _mesg = "Operation " + _tryPullOperations[x] + " failed: Ignore";
                if (this.logger_.isDebugEnabled()) {
                    this.logger_.debug(_mesg, (Throwable)e);
                    continue;
                }
                this.logger_.info(_mesg);
            }
        }
        return new MessageSupplierDelegate.PullResult(Collections.unmodifiableMap(_successFulRequests), true);
    }

    @Override
    public void queueMessages(MessageSupplierDelegate.PullResult data) {
        Map _successfulRequests = (Map)data.data_;
        for (String _operationNameWithoutTry : _successfulRequests.keySet()) {
            Request _request = (Request)_successfulRequests.get(_operationNameWithoutTry);
            String _operationName = this.getFullQualifiedName(_operationNameWithoutTry);
            Message _mesg = this.getMessageFactory().newMessage(this.supportedInterface_, _operationName, _request.arguments(), this);
            this.checkMessageProperties(_mesg);
            this.processMessage(_mesg);
        }
    }

    private OperationDescription getOperationDescription(String operation) {
        return (OperationDescription)this.operationDescriptions_.get(operation);
    }

    private String getFullQualifiedName(String operation) {
        String _fullQualifiedName = (String)this.fullQualifiedOperationNames_.get(operation);
        if (_fullQualifiedName == null) {
            _fullQualifiedName = this.interfaceDef_.lookup(operation).absolute_name();
            this.fullQualifiedOperationNames_.put(operation, _fullQualifiedName);
        }
        return _fullQualifiedName;
    }

    private Request prepareRequest(String operation) {
        Request _request = this.typedPullSupplier_._request(operation);
        NVList _args = _request.arguments();
        OperationDescription _operationDescription = this.getOperationDescription(operation);
        for (int x = 0; x < _operationDescription.parameters.length; ++x) {
            Any _any = this.getORB().create_any();
            _any.type(_operationDescription.parameters[x].type);
            _args.add_value(_operationDescription.parameters[x].name, _any, 2);
        }
        _request.set_return_type(_operationDescription.result);
        return _request;
    }

    @Override
    public void disconnect_pull_consumer() {
        this.destroy();
    }

    @Override
    public ProxyType MyType() {
        return ProxyType.PULL_TYPED;
    }

    @Override
    public void disconnectClient() {
        this.pollUtil_.stopTask();
        if (this.pullSupplier_ != null) {
            this.pullSupplier_.disconnect_pull_supplier();
            this.pullSupplier_ = null;
        }
    }

    @Override
    public Servant newServant() {
        return new TypedProxyPullConsumerPOATie(this);
    }

    @Override
    public String getSupportedInterface() {
        return this.supportedInterface_;
    }

    @Override
    public void runPullMessage() throws Disconnected {
        this.pullMessagesOperation_.runPull();
    }
}

