/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.logging.Level;
import org.jacorb.idl.AliasTypeSpec;
import org.jacorb.idl.ConstExpr;
import org.jacorb.idl.ConstType;
import org.jacorb.idl.Declaration;
import org.jacorb.idl.FixedPointConstType;
import org.jacorb.idl.FixedPointType;
import org.jacorb.idl.FloatType;
import org.jacorb.idl.GlobalInputStream;
import org.jacorb.idl.IDLTypes;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.Interface;
import org.jacorb.idl.LongLongType;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.OctetType;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.ShortType;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.parser;

public class ConstDecl
extends Declaration {
    private static Hashtable values = new Hashtable();
    private static Hashtable declarations = new Hashtable();
    private ScopedName t = new ScopedName(ConstDecl.new_num());
    private int pos_int_const = 0;
    private boolean int_const_set = false;
    public ConstExpr const_expr;
    public ConstType const_type;

    public ConstDecl(int num) {
        super(num);
    }

    public static void init() {
        values.clear();
        declarations.clear();
    }

    public static String namedValue(ScopedName sn) {
        String resolvedName = sn.resolvedName();
        if (values.containsKey(resolvedName)) {
            return (String)values.get(resolvedName);
        }
        return resolvedName;
    }

    @Override
    public void setPackage(String s) {
        s = parser.pack_replace(s);
        super.setPackage(s);
        this.const_type.setPackage(s);
        this.const_expr.setPackage(s);
        this.t.typeName = this.name;
        this.t.setPackage(s);
    }

    @Override
    public void parse() {
        this.const_expr.setDeclaration(this);
        try {
            NameTable.define(this.full_name(), IDLTypes.CONSTANT);
        }
        catch (NameAlreadyDefined p) {
            parser.error("Constant " + this.full_name() + " already defined", this.token);
        }
        this.const_type.parse();
        this.const_expr.parse();
        this.t.typeName = this.name;
        values.put(this.t.resolvedName() + (this.contained() ? "" : ".value"), this.const_expr.toString());
        if (parser.logger.isLoggable(Level.ALL)) {
            parser.logger.log(Level.ALL, "ConstDecl.parse, put value: " + this.t.resolvedName() + (this.contained() ? "" : ".value") + " , " + this.const_expr);
        }
        declarations.put(this.t.resolvedName(), this);
    }

    static ConstDecl getDeclaration(String resolvedName) {
        return (ConstDecl)declarations.get(resolvedName);
    }

    int pos_int_const() {
        if (!this.int_const_set) {
            this.pos_int_const = this.const_expr.pos_int_const();
            this.int_const_set = true;
        }
        return this.pos_int_const;
    }

    public void printContained(PrintWriter ps) {
        ps.print("\t" + this.const_type + " " + this.name + " = ");
        ps.print(this.getValue());
        ps.println(";");
    }

    boolean contained() {
        boolean result = false;
        for (IdlSymbol enc = this.getEnclosingSymbol(); enc != null; enc = enc.getEnclosingSymbol()) {
            if (!(enc instanceof Interface)) continue;
            result = true;
            break;
        }
        if (parser.logger.isLoggable(Level.ALL)) {
            parser.logger.log(Level.ALL, "ConstDecl.contained()? " + this.full_name() + " returns " + result);
        }
        return result;
    }

    @Override
    public void print(PrintWriter ps) {
        if (this.contained() || this.included && !this.generateIncluded()) {
            return;
        }
        try {
            String fname;
            File f;
            String className;
            String fullName = ScopedName.unPseudoName(this.full_name());
            if (fullName.indexOf(46) > 0) {
                this.pack_name = fullName.substring(0, fullName.lastIndexOf(46));
                className = fullName.substring(fullName.lastIndexOf(46) + 1);
            } else {
                this.pack_name = "";
                className = fullName;
            }
            String path = parser.out_dir + fileSeparator + this.pack_name.replace('.', fileSeparator);
            File dir = new File(path);
            if (!dir.exists() && !dir.mkdirs()) {
                parser.fatal_error("Unable to create " + path, null);
            }
            if (GlobalInputStream.isMoreRecentThan(f = new File(dir, fname = className + ".java"))) {
                PrintWriter pw = new PrintWriter(new FileWriter(f));
                if (parser.logger.isLoggable(Level.ALL)) {
                    parser.logger.log(Level.ALL, "ConstDecl.print " + fname);
                }
                if (!this.pack_name.equals("")) {
                    pw.println("package " + this.pack_name + ";");
                }
                this.printClassComment("const", className, pw);
                pw.println("public interface " + className);
                pw.println("{");
                pw.print("\t" + this.const_type.toString() + " value = ");
                pw.print(this.getValue());
                pw.println(";");
                pw.println("}");
                pw.close();
            }
        }
        catch (IOException i) {
            throw new RuntimeException("File IO error" + i);
        }
    }

    private String getValue() {
        String exprStr;
        TypeSpec ts = this.const_type.symbol.typeSpec();
        while (ts instanceof AliasTypeSpec) {
            ts = ((AliasTypeSpec)ts).originalType();
        }
        if (parser.logger.isLoggable(Level.ALL)) {
            parser.logger.log(Level.ALL, "ConstDecl(" + this.name + ": " + ts.getClass() + ") = " + this.const_type.toString());
        }
        if ((exprStr = this.const_expr.toString()) != null && exprStr.contains("Infinity")) {
            parser.logger.log(Level.WARNING, "[" + this.token.line_no + ":" + this.token.char_pos + "]" + "Infinity value used in const declaration");
            exprStr = exprStr.startsWith("-") ? "Double.NEGATIVE_INFINITY" : "Double.POSITIVE_INFINITY";
        }
        if (ts instanceof ShortType) {
            return "(short)(" + exprStr + ")";
        }
        if (ts instanceof FloatType) {
            return "(float)(" + exprStr + ")";
        }
        if (ts instanceof OctetType) {
            return "(byte)(" + exprStr + ")";
        }
        if (ts instanceof FixedPointConstType || ts instanceof FixedPointType) {
            return "new java.math.BigDecimal (" + exprStr + ")";
        }
        if (ts instanceof LongLongType) {
            String cast = "";
            try {
                if (this.const_expr.or_expr.xor_expr.and_expr.shift_expr.operator != null || this.const_expr.or_expr.xor_expr.and_expr.shift_expr.add_expr.operator != null || this.const_expr.or_expr.xor_expr.and_expr.shift_expr.add_expr.mult_expr.operator != null) {
                    cast = "(long)";
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return cast + this.const_expr.toString();
        }
        return exprStr;
    }
}

