/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir.gui.typesystem;

import java.lang.reflect.Method;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jacorb.ir.gui.typesystem.IllegalChildException;
import org.jacorb.ir.gui.typesystem.ModelParticipant;

public abstract class TypeSystemNode
extends ModelParticipant {
    protected DefaultMutableTreeNode treeNode;
    protected String name = "";
    protected String absoluteName = "";

    public TypeSystemNode() {
    }

    protected TypeSystemNode(DefaultMutableTreeNode treeNode) {
        this();
        this.treeNode = treeNode;
    }

    public TypeSystemNode(String name) {
        this();
        this.name = name;
    }

    public String[] allowedToAdd() {
        return null;
    }

    @Override
    public int compareTo(ModelParticipant other) {
        return this.toString().compareTo(other.toString());
    }

    public String description() {
        return this.getInstanceNodeTypeName() + " " + this.getAbsoluteName();
    }

    public String getAbsoluteName() {
        return this.absoluteName;
    }

    public String getInstanceNodeTypeName() {
        String nodeTypeName = "";
        try {
            Method nodeTypeNameMethod = this.getClass().getMethod("nodeTypeName", new Class[0]);
            nodeTypeName = (String)nodeTypeNameMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nodeTypeName;
    }

    public String getName() {
        return this.name;
    }

    protected void insertChild(TypeSystemNode newChild) throws IllegalChildException {
        int i;
        String[] allowedTypes = this.allowedToAdd();
        for (i = 0; i < allowedTypes.length && !allowedTypes[i].equals(TypeSystemNode.nodeTypeName()); ++i) {
        }
        if (!allowedTypes[i].equals(TypeSystemNode.nodeTypeName())) {
            throw new IllegalChildException();
        }
    }

    public static String nodeTypeName() {
        return null;
    }

    protected void setAbsoluteName(String absoluteName) {
        this.absoluteName = absoluteName;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.getInstanceNodeTypeName() + " " + this.getName();
    }
}

