/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.graphstream.graph.Graph;
import org.graphstream.stream.GraphReplay;
import org.graphstream.stream.ProxyPipe;
import org.graphstream.stream.Sink;
import org.graphstream.stream.file.FileSink;
import org.graphstream.stream.file.FileSourceDGS;
import org.graphstream.stream.thread.ThreadProxyPipe;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.graphicGraph.GraphicGraph;
import org.graphstream.ui.layout.Layout;
import org.graphstream.ui.layout.LayoutRunner;
import org.graphstream.ui.layout.Layouts;
import org.graphstream.ui.swingViewer.GraphRenderer;

public class FileSinkImages
implements FileSink {
    protected Resolution resolution;
    protected OutputType outputType;
    protected GraphRenderer renderer;
    protected String filePrefix;
    protected BufferedImage image;
    protected Graphics2D g2d;
    protected final GraphicGraph gg;
    protected Sink sink;
    protected int counter;
    protected OutputPolicy outputPolicy;
    protected LinkedList<PostRenderer> postRenderers;
    protected LayoutPolicy layoutPolicy;
    protected LayoutRunner optLayout;
    protected ProxyPipe layoutPipeIn;
    protected Layout layout;
    protected float layoutStabilizationLimit = 0.9f;
    protected int layoutStepAfterStabilization = 10;
    protected int layoutStepPerFrame = 4;
    protected int layoutStepWithoutFrame = 0;
    protected long outputRunnerDelay = 10L;
    protected boolean outputRunnerAlive = false;
    protected OutputRunner outputRunner;
    protected ThreadProxyPipe outputRunnerProxy;
    protected boolean clearImageBeforeOutput = false;
    protected boolean hasBegan = false;
    protected boolean autofit = true;
    protected String styleSheet = null;

    public FileSinkImages() {
        this(OutputType.PNG, Resolutions.HD720);
    }

    public FileSinkImages(OutputType type, Resolution resolution) {
        this("frame_", type, resolution, OutputPolicy.NONE);
    }

    public FileSinkImages(String prefix, OutputType type, Resolution resolution, OutputPolicy outputPolicy) {
        this.resolution = resolution;
        this.outputType = type;
        this.filePrefix = prefix;
        this.counter = 0;
        this.gg = new GraphicGraph(prefix);
        this.postRenderers = new LinkedList();
        this.layoutPolicy = LayoutPolicy.NO_LAYOUT;
        this.layout = null;
        this.optLayout = null;
        this.layoutPipeIn = null;
        this.sink = this.gg;
        this.setOutputPolicy(outputPolicy);
        this.setRenderer(RendererType.BASIC);
        this.initImage();
    }

    public void setQuality(Quality q) {
        switch (q) {
            case LOW: {
                if (this.gg.hasAttribute("ui.quality")) {
                    this.gg.removeAttribute("ui.quality");
                }
                if (!this.gg.hasAttribute("ui.antialias")) break;
                this.gg.removeAttribute("ui.antialias");
                break;
            }
            case MEDIUM: {
                if (!this.gg.hasAttribute("ui.quality")) {
                    this.gg.addAttribute("ui.quality", new Object[0]);
                }
                if (!this.gg.hasAttribute("ui.antialias")) break;
                this.gg.removeAttribute("ui.antialias");
                break;
            }
            case HIGH: {
                if (!this.gg.hasAttribute("ui.quality")) {
                    this.gg.addAttribute("ui.quality", new Object[0]);
                }
                if (this.gg.hasAttribute("ui.antialias")) break;
                this.gg.addAttribute("ui.antialias", new Object[0]);
            }
        }
    }

    public void setStyleSheet(String styleSheet) {
        this.styleSheet = styleSheet;
        this.gg.addAttribute("ui.stylesheet", styleSheet);
    }

    public void setResolution(Resolution r) {
        if (r != this.resolution) {
            this.resolution = r;
            this.initImage();
        }
    }

    public void setResolution(int width, int height) {
        if (this.resolution == null || this.resolution.getWidth() != width || this.resolution.getHeight() != height) {
            this.resolution = new CustomResolution(width, height);
            this.initImage();
        }
    }

    public void setRenderer(RendererType rendererType) {
        try {
            Class<?> clazz = Class.forName(rendererType.classname);
            GraphRenderer obj = (GraphRenderer)clazz.newInstance();
            if (this.renderer != null) {
                this.renderer.close();
            }
            this.renderer = obj;
            this.renderer.open(this.gg, null);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (ClassCastException e) {
            System.err.printf("not a renderer \"%s\"%n", rendererType.classname);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public void setOutputPolicy(OutputPolicy policy) {
        this.outputPolicy = policy;
    }

    public synchronized void setLayoutPolicy(LayoutPolicy policy) {
        if (policy != this.layoutPolicy) {
            switch (this.layoutPolicy) {
                case COMPUTED_IN_LAYOUT_RUNNER: {
                    this.optLayout.release();
                    this.optLayout = null;
                    this.layoutPipeIn.removeAttributeSink(this.gg);
                    this.layoutPipeIn = null;
                    this.layout = null;
                    break;
                }
                case COMPUTED_ONCE_AT_NEW_IMAGE: {
                    this.gg.removeSink(this.layout);
                    this.layout.removeAttributeSink(this.gg);
                    this.layout = null;
                    break;
                }
            }
            switch (policy) {
                case COMPUTED_IN_LAYOUT_RUNNER: {
                    this.layout = Layouts.newLayoutAlgorithm();
                    this.optLayout = new InnerLayoutRunner();
                    break;
                }
                case COMPUTED_ONCE_AT_NEW_IMAGE: 
                case COMPUTED_FULLY_AT_NEW_IMAGE: {
                    this.layout = Layouts.newLayoutAlgorithm();
                    this.gg.addSink(this.layout);
                    this.layout.addAttributeSink(this.gg);
                    break;
                }
            }
            this.layoutPolicy = policy;
        }
    }

    public void setLayoutStepPerFrame(int spf) {
        this.layoutStepPerFrame = spf;
    }

    public void setLayoutStepAfterStabilization(int sas) {
        this.layoutStepAfterStabilization = sas;
    }

    public void setLayoutStabilizationLimit(double limit) {
        if (this.layout == null) {
            throw new NullPointerException("did you enable layout ?");
        }
        this.layout.setStabilizationLimit(limit);
    }

    public void addLogo(String logoFile, int x, int y) {
        try {
            AddLogoRenderer pr = new AddLogoRenderer(logoFile, x, y);
            this.postRenderers.add(pr);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void setOutputRunnerEnabled(boolean on) {
        if (!on && this.outputRunnerAlive) {
            this.outputRunnerAlive = false;
            try {
                if (this.outputRunner != null) {
                    this.outputRunner.join();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.outputRunner = null;
            this.sink = this.gg;
            if (this.outputRunnerProxy != null) {
                this.outputRunnerProxy.pump();
            }
        }
        this.outputRunnerAlive = on;
        if (this.outputRunnerAlive) {
            if (this.outputRunnerProxy == null) {
                this.outputRunnerProxy = new ThreadProxyPipe();
                this.outputRunnerProxy.init(this.gg);
            }
            this.sink = this.outputRunnerProxy;
            this.outputRunner = new OutputRunner();
            this.outputRunner.start();
        }
    }

    public void setOutputRunnerDelay(long delay) {
        this.outputRunnerDelay = delay;
    }

    public void stabilizeLayout(double limit) {
        if (this.layout != null) {
            while (this.layout.getStabilization() < limit) {
                this.layout.compute();
            }
        }
    }

    public Point3 getViewCenter() {
        return this.renderer.getCamera().getViewCenter();
    }

    public void setViewCenter(double x, double y) {
        this.renderer.getCamera().setViewCenter(x, y, 0.0);
    }

    public double getViewPercent() {
        return this.renderer.getCamera().getViewPercent();
    }

    public void setViewPercent(double zoom) {
        this.renderer.getCamera().setViewPercent(zoom);
    }

    public void setGraphViewport(double minx, double miny, double maxx, double maxy) {
        this.renderer.getCamera().setGraphViewport(minx, miny, maxx, maxy);
    }

    public void setClearImageBeforeOutputEnabled(boolean on) {
        this.clearImageBeforeOutput = on;
    }

    public void setAutofit(boolean on) {
        this.autofit = on;
    }

    protected void initImage() {
        this.image = new BufferedImage(this.resolution.getWidth(), this.resolution.getHeight(), this.outputType.imageType);
        this.g2d = this.image.createGraphics();
    }

    protected void clearGG() {
        this.gg.clear();
        if (this.styleSheet != null) {
            this.gg.setAttribute("ui.stylesheet", this.styleSheet);
        }
        if (this.layout != null) {
            this.layout.clear();
        }
    }

    public void outputNewImage() {
        this.outputNewImage(String.format("%s%06d.%s", this.filePrefix, this.counter++, this.outputType.ext));
    }

    public synchronized void outputNewImage(String filename) {
        switch (this.layoutPolicy) {
            case COMPUTED_IN_LAYOUT_RUNNER: {
                this.layoutPipeIn.pump();
                break;
            }
            case COMPUTED_ONCE_AT_NEW_IMAGE: {
                if (this.layout == null) break;
                this.layout.compute();
                break;
            }
            case COMPUTED_FULLY_AT_NEW_IMAGE: {
                this.stabilizeLayout(this.layout.getStabilizationLimit());
                break;
            }
        }
        if (this.resolution.getWidth() != this.image.getWidth() || this.resolution.getHeight() != this.image.getHeight()) {
            this.initImage();
        }
        if (this.clearImageBeforeOutput) {
            int x = 0;
            while (x < this.resolution.getWidth()) {
                int y = 0;
                while (y < this.resolution.getHeight()) {
                    this.image.setRGB(x, y, 0);
                    ++y;
                }
                ++x;
            }
        }
        if (this.gg.getNodeCount() > 0) {
            if (this.autofit) {
                this.gg.computeBounds();
                Point3 lo = this.gg.getMinPos();
                Point3 hi = this.gg.getMaxPos();
                this.renderer.getCamera().setBounds(lo.x, lo.y, lo.z, hi.x, hi.y, hi.z);
            }
            this.renderer.render(this.g2d, 0, 0, this.resolution.getWidth(), this.resolution.getHeight());
        }
        for (PostRenderer action : this.postRenderers) {
            action.render(this.g2d);
        }
        this.image.flush();
        try {
            File out = new File(filename);
            if (out.getParent() != null && !out.getParentFile().exists()) {
                out.getParentFile().mkdirs();
            }
            ImageIO.write((RenderedImage)this.image, this.outputType.name(), out);
            this.printProgress();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void printProgress() {
        System.out.printf("\u001b[s\u001b[K%d images written\u001b[u", this.counter);
    }

    @Override
    public void begin(OutputStream stream) throws IOException {
        throw new IOException("not implemented");
    }

    @Override
    public void begin(Writer writer) throws IOException {
        throw new IOException("not implemented");
    }

    @Override
    public void begin(String prefix) throws IOException {
        this.filePrefix = prefix;
        this.hasBegan = true;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void end() throws IOException {
        this.flush();
        this.hasBegan = false;
    }

    @Override
    public void writeAll(Graph g, OutputStream stream) throws IOException {
        throw new IOException("not implemented");
    }

    @Override
    public void writeAll(Graph g, Writer writer) throws IOException {
        throw new IOException("not implemented");
    }

    @Override
    public synchronized void writeAll(Graph g, String filename) throws IOException {
        this.clearGG();
        GraphReplay replay = new GraphReplay(String.format("file_sink_image-write_all-replay-%x", System.nanoTime()));
        replay.addSink(this.gg);
        replay.replay(g);
        replay.removeSink(this.gg);
        this.outputNewImage(filename);
        this.clearGG();
    }

    @Override
    public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
        this.sink.edgeAttributeAdded(sourceId, timeId, edgeId, attribute, value);
        switch (this.outputPolicy) {
            case BY_EVENT: 
            case BY_ATTRIBUTE_EVENT: 
            case BY_EDGE_EVENT: 
            case BY_EDGE_ATTRIBUTE: {
                if (!this.hasBegan) break;
                this.outputNewImage();
                break;
            }
        }
    }

    @Override
    public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
        this.sink.edgeAttributeChanged(sourceId, timeId, edgeId, attribute, oldValue, newValue);
        switch (this.outputPolicy) {
            case BY_EVENT: 
            case BY_ATTRIBUTE_EVENT: 
            case BY_EDGE_EVENT: 
            case BY_EDGE_ATTRIBUTE: {
                if (!this.hasBegan) break;
                this.outputNewImage();
                break;
            }
        }
    }

    @Override
    public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
        this.sink.edgeAttributeRemoved(sourceId, timeId, edgeId, attribute);
        switch (this.outputPolicy) {
            case BY_EVENT: 
            case BY_ATTRIBUTE_EVENT: 
            case BY_EDGE_EVENT: 
            case BY_EDGE_ATTRIBUTE: {
                if (!this.hasBegan) break;
                this.outputNewImage();
                break;
            }
        }
    }

    @Override
    public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
        this.sink.graphAttributeAdded(sourceId, timeId, attribute, value);
        switch (this.outputPolicy) {
            case BY_EVENT: 
            case BY_ATTRIBUTE_EVENT: 
            case BY_GRAPH_EVENT: 
            case BY_GRAPH_ATTRIBUTE: {
                if (!this.hasBegan) break;
                this.outputNewImage();
                break;
            }
        }
    }

    @Override
    public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
        this.sink.graphAttributeChanged(sourceId, timeId, attribute, oldValue, newValue);
        switch (this.outputPolicy) {
            case BY_EVENT: 
            case BY_ATTRIBUTE_EVENT: 
            case BY_GRAPH_EVENT: 
            case BY_GRAPH_ATTRIBUTE: {
                if (!this.hasBegan) break;
                this.outputNewImage();
                break;
            }
        }
    }

    @Override
    public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
        this.sink.graphAttributeRemoved(sourceId, timeId, attribute);
        switch (this.outputPolicy) {
            case BY_EVENT: 
            case BY_ATTRIBUTE_EVENT: 
            case BY_GRAPH_EVENT: 
            case BY_GRAPH_ATTRIBUTE: {
                if (!this.hasBegan) break;
                this.outputNewImage();
                break;
            }
        }
    }

    @Override
    public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
        this.sink.nodeAttributeAdded(sourceId, timeId, nodeId, attribute, value);
        switch (this.outputPolicy) {
            case BY_EVENT: 
            case BY_ATTRIBUTE_EVENT: 
            case BY_NODE_EVENT: 
            case BY_NODE_ATTRIBUTE: {
                if (!this.hasBegan) break;
                this.outputNewImage();
                break;
            }
        }
    }

    @Override
    public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        this.sink.nodeAttributeChanged(sourceId, timeId, nodeId, attribute, oldValue, newValue);
        switch (this.outputPolicy) {
            case BY_EVENT: 
            case BY_ATTRIBUTE_EVENT: 
            case BY_NODE_EVENT: 
            case BY_NODE_ATTRIBUTE: {
                if (!this.hasBegan) break;
                this.outputNewImage();
                break;
            }
        }
    }

    @Override
    public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
        this.sink.nodeAttributeRemoved(sourceId, timeId, nodeId, attribute);
        switch (this.outputPolicy) {
            case BY_EVENT: 
            case BY_ATTRIBUTE_EVENT: 
            case BY_NODE_EVENT: 
            case BY_NODE_ATTRIBUTE: {
                if (!this.hasBegan) break;
                this.outputNewImage();
                break;
            }
        }
    }

    @Override
    public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        this.sink.edgeAdded(sourceId, timeId, edgeId, fromNodeId, toNodeId, directed);
        switch (this.outputPolicy) {
            case BY_EVENT: 
            case BY_ELEMENT_EVENT: 
            case BY_EDGE_EVENT: 
            case BY_EDGE_ADDED_REMOVED: {
                if (!this.hasBegan) break;
                this.outputNewImage();
                break;
            }
        }
    }

    @Override
    public void edgeRemoved(String sourceId, long timeId, String edgeId) {
        this.sink.edgeRemoved(sourceId, timeId, edgeId);
        switch (this.outputPolicy) {
            case BY_EVENT: 
            case BY_ELEMENT_EVENT: 
            case BY_EDGE_EVENT: 
            case BY_EDGE_ADDED_REMOVED: {
                if (!this.hasBegan) break;
                this.outputNewImage();
                break;
            }
        }
    }

    @Override
    public void graphCleared(String sourceId, long timeId) {
        this.sink.graphCleared(sourceId, timeId);
        switch (this.outputPolicy) {
            case BY_EVENT: 
            case BY_ELEMENT_EVENT: 
            case BY_GRAPH_EVENT: 
            case BY_NODE_ADDED_REMOVED: 
            case BY_EDGE_ADDED_REMOVED: {
                if (!this.hasBegan) break;
                this.outputNewImage();
                break;
            }
        }
    }

    @Override
    public void nodeAdded(String sourceId, long timeId, String nodeId) {
        this.sink.nodeAdded(sourceId, timeId, nodeId);
        switch (this.outputPolicy) {
            case BY_EVENT: 
            case BY_ELEMENT_EVENT: 
            case BY_NODE_EVENT: 
            case BY_NODE_ADDED_REMOVED: {
                if (!this.hasBegan) break;
                this.outputNewImage();
                break;
            }
        }
    }

    @Override
    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
        this.sink.nodeRemoved(sourceId, timeId, nodeId);
        switch (this.outputPolicy) {
            case BY_EVENT: 
            case BY_ELEMENT_EVENT: 
            case BY_NODE_EVENT: 
            case BY_NODE_ADDED_REMOVED: {
                if (!this.hasBegan) break;
                this.outputNewImage();
                break;
            }
        }
    }

    @Override
    public void stepBegins(String sourceId, long timeId, double step) {
        this.sink.stepBegins(sourceId, timeId, step);
        switch (this.outputPolicy) {
            case BY_EVENT: 
            case BY_STEP: {
                if (!this.hasBegan) break;
                this.outputNewImage();
                break;
            }
        }
    }

    public static void usage() {
        System.out.printf("usage: java %s [options] fichier.dgs%n", FileSinkImages.class.getName());
        System.out.printf("where options in:%n", new Object[0]);
        Option[] optionArray = Option.values();
        int n = optionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Option option = optionArray[n2];
            System.out.printf("%n --%s%s , -%s %s%n%s%n", option.fullopts, option.valuable ? "=..." : "", Character.valueOf(option.shortopts), option.valuable ? "..." : "", option.description);
            ++n2;
        }
    }

    public static void main(String ... args) throws IOException {
        File test;
        HashMap<Option, String> options = new HashMap<Option, String>();
        LinkedList<String> others = new LinkedList<String>();
        Option[] optionArray = Option.values();
        int n = optionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Option option = optionArray[n2];
            if (option.defaultValue != null) {
                options.put(option, option.defaultValue);
            }
            ++n2;
        }
        if (args != null && args.length > 0) {
            Pattern valueGetter = Pattern.compile("^--\\w[\\w-]*\\w?(?:=(?:\"([^\"]*)\"|([^\\s]*)))$");
            int i = 0;
            while (i < args.length) {
                Option option;
                int n3;
                int n4;
                Option[] optionArray2;
                boolean found;
                if (args[i].matches("^--\\w[\\w-]*\\w?(=(\"[^\"]*\"|[^\\s]*))?$")) {
                    found = false;
                    optionArray2 = Option.values();
                    n4 = optionArray2.length;
                    n3 = 0;
                    while (n3 < n4) {
                        option = optionArray2[n3];
                        if (args[i].startsWith("--" + option.fullopts + "=")) {
                            Matcher m = valueGetter.matcher(args[i]);
                            if (m.matches()) {
                                options.put(option, m.group(1) == null ? m.group(2) : m.group(1));
                            }
                            found = true;
                            break;
                        }
                        ++n3;
                    }
                    if (!found) {
                        System.err.printf("unknown option: %s%n", args[i].substring(0, args[i].indexOf(61)));
                        System.exit(1);
                    }
                } else if (args[i].matches("^-\\w$")) {
                    found = false;
                    optionArray2 = Option.values();
                    n4 = optionArray2.length;
                    n3 = 0;
                    while (n3 < n4) {
                        option = optionArray2[n3];
                        if (args[i].equals("-" + option.shortopts)) {
                            options.put(option, args[++i]);
                            break;
                        }
                        ++n3;
                    }
                    if (!found) {
                        System.err.printf("unknown option: %s%n", args[i]);
                        System.exit(1);
                    }
                } else {
                    others.addLast(args[i]);
                }
                ++i;
            }
        } else {
            FileSinkImages.usage();
            System.exit(0);
        }
        LinkedList<String> errors = new LinkedList<String>();
        if (others.size() == 0) {
            errors.add("dgs file name missing.");
        }
        OutputType outputType = null;
        OutputPolicy outputPolicy = null;
        Resolution resolution = null;
        Quality quality = null;
        String imagePrefix = (String)options.get((Object)Option.IMAGE_PREFIX);
        try {
            outputType = OutputType.valueOf((String)options.get((Object)Option.IMAGE_TYPE));
        }
        catch (IllegalArgumentException e) {
            errors.add("bad image type: " + (String)options.get((Object)Option.IMAGE_TYPE));
        }
        try {
            outputPolicy = OutputPolicy.valueOf((String)options.get((Object)Option.OUTPUT_POLICY));
        }
        catch (IllegalArgumentException e) {
            errors.add("bad output policy: " + (String)options.get((Object)Option.OUTPUT_POLICY));
        }
        try {
            quality = Quality.valueOf((String)options.get((Object)Option.QUALITY));
        }
        catch (IllegalArgumentException e) {
            errors.add("bad quality: " + (String)options.get((Object)Option.QUALITY));
        }
        String logo = (String)options.get((Object)Option.LOGO);
        String stylesheet = (String)options.get((Object)Option.STYLESHEET);
        try {
            resolution = Resolutions.valueOf((String)options.get((Object)Option.IMAGE_RESOLUTION));
        }
        catch (IllegalArgumentException e) {
            Pattern p = Pattern.compile("^\\s*(\\d+)\\s*x\\s*(\\d+)\\s*$");
            Matcher m = p.matcher((CharSequence)options.get((Object)Option.IMAGE_RESOLUTION));
            if (m.matches()) {
                resolution = new CustomResolution(Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)));
            }
            errors.add("bad resolution: " + (String)options.get((Object)Option.IMAGE_RESOLUTION));
        }
        if (stylesheet != null && stylesheet.length() < 1024 && (test = new File(stylesheet)).exists()) {
            FileReader in = new FileReader(test);
            char[] buffer = new char[128];
            String content = "";
            while (in.ready()) {
                int c = in.read(buffer, 0, 128);
                content = String.valueOf(content) + new String(buffer, 0, c);
            }
            stylesheet = content;
            in.close();
        }
        if (!(test = new File((String)others.peek())).exists()) {
            errors.add(String.format("file \"%s\" does not exist", others.peek()));
        }
        if (errors.size() > 0) {
            System.err.printf("error:%n", new Object[0]);
            for (String error : errors) {
                System.err.printf("- %s%n", error);
            }
            System.exit(1);
        }
        FileSourceDGS dgs = new FileSourceDGS();
        FileSinkImages fsi = new FileSinkImages(imagePrefix, outputType, resolution, outputPolicy);
        dgs.addSink(fsi);
        if (logo != null) {
            fsi.addLogo(logo, 0, 0);
        }
        fsi.setQuality(quality);
        if (stylesheet != null) {
            fsi.setStyleSheet(stylesheet);
        }
        boolean next = true;
        dgs.begin((String)others.get(0));
        while (next) {
            next = dgs.nextStep();
        }
        dgs.end();
    }

    protected static class AddLogoRenderer
    implements PostRenderer {
        BufferedImage logo;
        int x;
        int y;

        public AddLogoRenderer(String logoFile, int x, int y) throws IOException {
            File f = new File(logoFile);
            this.logo = f.exists() ? ImageIO.read(f) : ImageIO.read(ClassLoader.getSystemResource(logoFile));
            this.x = x;
            this.y = y;
        }

        @Override
        public void render(Graphics2D g) {
            g.drawImage((Image)this.logo, this.x, this.y, null);
        }
    }

    public static class CustomResolution
    implements Resolution {
        final int width;
        final int height;

        public CustomResolution(int width, int height) {
            this.width = width;
            this.height = height;
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        public String toString() {
            return String.format("%dx%d", this.width, this.height);
        }
    }

    protected class InnerLayoutRunner
    extends LayoutRunner {
        public InnerLayoutRunner() {
            super(FileSinkImages.this.gg, FileSinkImages.this.layout, true, true);
            FileSinkImages.this.layoutPipeIn = this.newLayoutPipe();
            FileSinkImages.this.layoutPipeIn.addAttributeSink(FileSinkImages.this.gg);
        }

        @Override
        public void run() {
            int stepAfterStabilization = 0;
            do {
                this.pumpPipe.pump();
                this.layout.compute();
                stepAfterStabilization = this.layout.getStabilization() > this.layout.getStabilizationLimit() ? ++stepAfterStabilization : 0;
                this.nap(80L);
                if (stepAfterStabilization <= FileSinkImages.this.layoutStepAfterStabilization) continue;
                this.loop = false;
            } while (this.loop);
        }
    }

    public static enum LayoutPolicy {
        NO_LAYOUT,
        COMPUTED_IN_LAYOUT_RUNNER,
        COMPUTED_ONCE_AT_NEW_IMAGE,
        COMPUTED_FULLY_AT_NEW_IMAGE;

    }

    public static enum Option {
        IMAGE_PREFIX("image-prefix", 'p', "prefix of outputted images", true, true, "image_"),
        IMAGE_TYPE("image-type", 't', "image type. one of " + Arrays.toString((Object[])OutputType.values()), true, true, "PNG"),
        IMAGE_RESOLUTION("image-resolution", 'r', "defines images resolution. \"width x height\" or one of " + Arrays.toString(Resolutions.values()), true, true, "HD720"),
        OUTPUT_POLICY("output-policy", 'e', "defines when images are outputted. one of " + Arrays.toString((Object[])OutputPolicy.values()), true, true, "ByStepOutput"),
        LOGO("logo", 'l', "add a logo to images", true, true, null),
        STYLESHEET("stylesheet", 's', "defines stylesheet of graph. can be a file or a string.", true, true, null),
        QUALITY("quality", 'q', "defines quality of rendering. one of " + Arrays.toString((Object[])Quality.values()), true, true, "HIGH");

        String fullopts;
        char shortopts;
        String description;
        boolean optional;
        boolean valuable;
        String defaultValue;

        private Option(String fullopts, char shortopts, String description, boolean optional, boolean valuable, String defaultValue) {
            this.fullopts = fullopts;
            this.shortopts = shortopts;
            this.description = description;
            this.optional = optional;
            this.valuable = valuable;
            this.defaultValue = defaultValue;
        }
    }

    public static enum OutputPolicy {
        BY_EVENT,
        BY_ELEMENT_EVENT,
        BY_ATTRIBUTE_EVENT,
        BY_NODE_EVENT,
        BY_EDGE_EVENT,
        BY_GRAPH_EVENT,
        BY_STEP,
        BY_NODE_ADDED_REMOVED,
        BY_EDGE_ADDED_REMOVED,
        BY_NODE_ATTRIBUTE,
        BY_EDGE_ATTRIBUTE,
        BY_GRAPH_ATTRIBUTE,
        BY_LAYOUT_STEP,
        BY_NODE_MOVED,
        ON_RUNNER,
        NONE;

    }

    protected class OutputRunner
    extends Thread {
        public OutputRunner() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (FileSinkImages.this.outputRunnerAlive && FileSinkImages.this.outputPolicy == OutputPolicy.ON_RUNNER) {
                FileSinkImages.this.outputRunnerProxy.pump();
                if (FileSinkImages.this.hasBegan) {
                    FileSinkImages.this.outputNewImage();
                }
                try {
                    Thread.sleep(FileSinkImages.this.outputRunnerDelay);
                }
                catch (InterruptedException e) {
                    FileSinkImages.this.outputRunnerAlive = false;
                }
            }
        }
    }

    public static enum OutputType {
        PNG(2, "png"),
        JPG(1, "jpg"),
        png(2, "png"),
        jpg(1, "jpg");

        final int imageType;
        final String ext;

        private OutputType(int imageType, String ext) {
            this.imageType = imageType;
            this.ext = ext;
        }
    }

    public static interface PostRenderer {
        public void render(Graphics2D var1);
    }

    public static enum Quality {
        LOW,
        MEDIUM,
        HIGH;

    }

    public static enum RendererType {
        BASIC("org.graphstream.ui.swingViewer.basicRenderer.SwingBasicGraphRenderer"),
        SCALA("org.graphstream.ui.j2dviewer.J2DGraphRenderer");

        final String classname;

        private RendererType(String cn) {
            this.classname = cn;
        }
    }

    public static interface Resolution {
        public int getWidth();

        public int getHeight();
    }

    public static enum Resolutions implements Resolution
    {
        QVGA(320, 240),
        CGA(320, 200),
        VGA(640, 480),
        NTSC(720, 480),
        PAL(768, 576),
        WVGA_5by3(800, 480),
        SVGA(800, 600),
        WVGA_16by9(854, 480),
        WSVGA(1024, 600),
        XGA(1024, 768),
        HD720(1280, 720),
        WXGA_5by3(1280, 768),
        WXGA_8by5(1280, 800),
        SXGA(1280, 1024),
        SXGAp(1400, 1050),
        WSXGAp(1680, 1050),
        UXGA(1600, 1200),
        HD1080(1920, 1080),
        WUXGA(1920, 1200),
        TwoK(2048, 1080),
        QXGA(2048, 1536),
        WQXGA(2560, 1600),
        QSXGA(2560, 2048),
        UHD_4K(3840, 2160),
        UHD_8K_16by9(7680, 4320),
        UHD_8K_17by8(8192, 4320),
        UHD_8K_1by1(8192, 8192);

        final int width;
        final int height;

        private Resolutions(int width, int height) {
            this.width = width;
            this.height = height;
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        public String toString() {
            return String.format("%s (%dx%d)", this.name(), this.width, this.height);
        }
    }
}

