/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.util;

import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Stack;
import org.graphstream.stream.Sink;

public class VerboseSink
implements Sink {
    public static final String DEFAULT_AN_FORMAT = "%prefix%[%sourceId%:%timeId%] add node \"%nodeId%\"%suffix%";
    public static final String DEFAULT_CNA_FORMAT = "%prefix%[%sourceId%:%timeId%] set node \"%nodeId%\" +\"%attributeId%\"=%value%%suffix%";
    public static final String DEFAULT_CNC_FORMAT = "%prefix%[%sourceId%:%timeId%] set node \"%nodeId%\" \"%attributeId%\"=%value%%suffix%";
    public static final String DEFAULT_CNR_FORMAT = "%prefix%[%sourceId%:%timeId%] set node \"%nodeId%\" -\"%attributeId%\"%suffix%";
    public static final String DEFAULT_DN_FORMAT = "%prefix%[%sourceId%:%timeId%] remove node \"%nodeId%\"%suffix%";
    public static final String DEFAULT_AE_FORMAT = "%prefix%[%sourceId%:%timeId%] add edge \"%edgeId%\" : \"%source%\" -- \"%target%\"%suffix%";
    public static final String DEFAULT_CEA_FORMAT = "%prefix%[%sourceId%:%timeId%] set edge \"%edgeId%\" +\"%attributeId%\"=%value%%suffix%";
    public static final String DEFAULT_CEC_FORMAT = "%prefix%[%sourceId%:%timeId%] set edge \"%edgeId%\" \"%attributeId%\"=%value%%suffix%";
    public static final String DEFAULT_CER_FORMAT = "%prefix%[%sourceId%:%timeId%] set edge \"%edgeId%\" -\"%attributeId%\"%suffix%";
    public static final String DEFAULT_DE_FORMAT = "%prefix%[%sourceId%:%timeId%] remove edge \"%edgeId%\"%suffix%";
    public static final String DEFAULT_CGA_FORMAT = "%prefix%[%sourceId%:%timeId%] set +\"%attributeId%\"=%value%%suffix%";
    public static final String DEFAULT_CGC_FORMAT = "%prefix%[%sourceId%:%timeId%] set \"%attributeId%\"=%value%%suffix%";
    public static final String DEFAULT_CGR_FORMAT = "%prefix%[%sourceId%:%timeId%] set -\"%attributeId%\"%suffix%";
    public static final String DEFAULT_CL_FORMAT = "%prefix%[%sourceId%:%timeId%] clear%suffix%";
    public static final String DEFAULT_ST_FORMAT = "%prefix%[%sourceId%:%timeId%] step %step% begins%suffix%";
    protected boolean autoflush;
    protected final PrintStream out;
    protected final EnumMap<EventType, String> formats;
    protected final EnumMap<EventType, Boolean> enable;
    private final Stack<Args> argsStack;
    protected String prefix;
    protected String suffix;

    public VerboseSink() {
        this(System.out);
    }

    public VerboseSink(PrintStream out) {
        this.out = out;
        this.argsStack = new Stack();
        this.enable = new EnumMap(EventType.class);
        this.formats = new EnumMap(EventType.class);
        this.formats.put(EventType.ADD_NODE, DEFAULT_AN_FORMAT);
        this.formats.put(EventType.ADD_NODE_ATTRIBUTE, DEFAULT_CNA_FORMAT);
        this.formats.put(EventType.SET_NODE_ATTRIBUTE, DEFAULT_CNC_FORMAT);
        this.formats.put(EventType.DEL_NODE_ATTRIBUTE, DEFAULT_CNR_FORMAT);
        this.formats.put(EventType.DEL_NODE, DEFAULT_DN_FORMAT);
        this.formats.put(EventType.ADD_EDGE, DEFAULT_AE_FORMAT);
        this.formats.put(EventType.ADD_EDGE_ATTRIBUTE, DEFAULT_CEA_FORMAT);
        this.formats.put(EventType.SET_EDGE_ATTRIBUTE, DEFAULT_CEC_FORMAT);
        this.formats.put(EventType.DEL_EDGE_ATTRIBUTE, DEFAULT_CER_FORMAT);
        this.formats.put(EventType.DEL_EDGE, DEFAULT_DE_FORMAT);
        this.formats.put(EventType.ADD_GRAPH_ATTRIBUTE, DEFAULT_CGA_FORMAT);
        this.formats.put(EventType.SET_GRAPH_ATTRIBUTE, DEFAULT_CGC_FORMAT);
        this.formats.put(EventType.DEL_GRAPH_ATTRIBUTE, DEFAULT_CGR_FORMAT);
        this.formats.put(EventType.CLEAR, DEFAULT_CL_FORMAT);
        this.formats.put(EventType.STEP_BEGINS, DEFAULT_ST_FORMAT);
        EventType[] eventTypeArray = EventType.values();
        int n = eventTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EventType t = eventTypeArray[n2];
            this.enable.put(t, Boolean.TRUE);
            ++n2;
        }
        this.suffix = "";
        this.prefix = "";
    }

    public void setAutoFlush(boolean on) {
        this.autoflush = on;
    }

    public void setEventFormat(EventType type, String format) {
        this.formats.put(type, format);
    }

    public void setEventEnabled(EventType type, boolean on) {
        this.enable.put(type, on);
    }

    public void setElementEventEnabled(boolean on) {
        this.enable.put(EventType.ADD_EDGE_ATTRIBUTE, on);
        this.enable.put(EventType.SET_EDGE_ATTRIBUTE, on);
        this.enable.put(EventType.DEL_EDGE_ATTRIBUTE, on);
        this.enable.put(EventType.ADD_NODE_ATTRIBUTE, on);
        this.enable.put(EventType.SET_NODE_ATTRIBUTE, on);
        this.enable.put(EventType.DEL_NODE_ATTRIBUTE, on);
        this.enable.put(EventType.ADD_GRAPH_ATTRIBUTE, on);
        this.enable.put(EventType.SET_GRAPH_ATTRIBUTE, on);
        this.enable.put(EventType.DEL_GRAPH_ATTRIBUTE, on);
    }

    public void setAttributeEventEnabled(boolean on) {
        this.enable.put(EventType.ADD_EDGE, on);
        this.enable.put(EventType.DEL_EDGE, on);
        this.enable.put(EventType.ADD_NODE, on);
        this.enable.put(EventType.DEL_NODE, on);
        this.enable.put(EventType.CLEAR, on);
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    private void print(EventType type, Args args) {
        if (!this.enable.get((Object)type).booleanValue()) {
            return;
        }
        String out = this.formats.get((Object)type);
        for (String k : args.keySet()) {
            Object o = args.get(k);
            out = out.replace(String.format("%%%s%%", k), o == null ? "null" : o.toString());
        }
        this.out.print(out);
        this.out.printf("\n", new Object[0]);
        if (this.autoflush) {
            this.out.flush();
        }
        this.argsPnP(args);
    }

    private Args argsPnP(Args args) {
        if (args == null) {
            args = this.argsStack.size() > 0 ? this.argsStack.pop() : new Args();
            args.put("prefix", this.prefix);
            args.put("suffix", this.suffix);
            return args;
        }
        args.clear();
        this.argsStack.push(args);
        return null;
    }

    private String toStringValue(Object o) {
        if (o == null) {
            return "<null>";
        }
        if (o instanceof String) {
            return "\"" + ((String)o).replace("\"", "\\\"");
        }
        if (o.getClass().isArray()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("{");
            int i = 0;
            while (i < Array.getLength(o)) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(this.toStringValue(Array.get(o, i)));
                ++i;
            }
            buffer.append("}");
            return buffer.toString();
        }
        return o.toString();
    }

    @Override
    public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
        Args args = this.argsPnP(null);
        args.put("sourceId", sourceId);
        args.put("timeId", timeId);
        args.put("edgeId", edgeId);
        args.put("attributeId", attribute);
        args.put("value", this.toStringValue(value));
        this.print(EventType.ADD_EDGE_ATTRIBUTE, args);
    }

    @Override
    public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
        Args args = this.argsPnP(null);
        args.put("sourceId", sourceId);
        args.put("timeId", timeId);
        args.put("edgeId", edgeId);
        args.put("attributeId", attribute);
        args.put("value", this.toStringValue(newValue));
        this.print(EventType.SET_EDGE_ATTRIBUTE, args);
    }

    @Override
    public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
        Args args = this.argsPnP(null);
        args.put("sourceId", sourceId);
        args.put("timeId", timeId);
        args.put("edgeId", edgeId);
        args.put("attributeId", attribute);
        this.print(EventType.DEL_EDGE_ATTRIBUTE, args);
    }

    @Override
    public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
        Args args = this.argsPnP(null);
        args.put("sourceId", sourceId);
        args.put("timeId", timeId);
        args.put("attributeId", attribute);
        args.put("value", this.toStringValue(value));
        this.print(EventType.ADD_GRAPH_ATTRIBUTE, args);
    }

    @Override
    public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
        Args args = this.argsPnP(null);
        args.put("sourceId", sourceId);
        args.put("timeId", timeId);
        args.put("attributeId", attribute);
        args.put("value", this.toStringValue(newValue));
        this.print(EventType.SET_GRAPH_ATTRIBUTE, args);
    }

    @Override
    public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
        Args args = this.argsPnP(null);
        args.put("sourceId", sourceId);
        args.put("timeId", timeId);
        args.put("attributeId", attribute);
        this.print(EventType.DEL_GRAPH_ATTRIBUTE, args);
    }

    @Override
    public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
        Args args = this.argsPnP(null);
        args.put("sourceId", sourceId);
        args.put("timeId", timeId);
        args.put("nodeId", nodeId);
        args.put("attributeId", attribute);
        args.put("value", this.toStringValue(value));
        this.print(EventType.ADD_NODE_ATTRIBUTE, args);
    }

    @Override
    public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        Args args = this.argsPnP(null);
        args.put("sourceId", sourceId);
        args.put("timeId", timeId);
        args.put("nodeId", nodeId);
        args.put("attributeId", attribute);
        args.put("value", this.toStringValue(newValue));
        this.print(EventType.SET_NODE_ATTRIBUTE, args);
    }

    @Override
    public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
        Args args = this.argsPnP(null);
        args.put("sourceId", sourceId);
        args.put("timeId", timeId);
        args.put("nodeId", nodeId);
        args.put("attributeId", attribute);
        this.print(EventType.DEL_NODE_ATTRIBUTE, args);
    }

    @Override
    public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        Args args = this.argsPnP(null);
        args.put("sourceId", sourceId);
        args.put("timeId", timeId);
        args.put("edgeId", edgeId);
        args.put("source", fromNodeId);
        args.put("target", toNodeId);
        this.print(EventType.ADD_EDGE, args);
    }

    @Override
    public void edgeRemoved(String sourceId, long timeId, String edgeId) {
        Args args = this.argsPnP(null);
        args.put("sourceId", sourceId);
        args.put("timeId", timeId);
        args.put("edgeId", edgeId);
        this.print(EventType.DEL_EDGE, args);
    }

    @Override
    public void graphCleared(String sourceId, long timeId) {
        Args args = this.argsPnP(null);
        args.put("sourceId", sourceId);
        args.put("timeId", timeId);
        this.print(EventType.CLEAR, args);
    }

    @Override
    public void nodeAdded(String sourceId, long timeId, String nodeId) {
        Args args = this.argsPnP(null);
        args.put("sourceId", sourceId);
        args.put("timeId", timeId);
        args.put("nodeId", nodeId);
        this.print(EventType.ADD_NODE, args);
    }

    @Override
    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
        Args args = this.argsPnP(null);
        args.put("sourceId", sourceId);
        args.put("timeId", timeId);
        args.put("nodeId", nodeId);
        this.print(EventType.DEL_NODE, args);
    }

    @Override
    public void stepBegins(String sourceId, long timeId, double step) {
        Args args = this.argsPnP(null);
        args.put("sourceId", sourceId);
        args.put("timeId", timeId);
        args.put("step", step);
        this.print(EventType.STEP_BEGINS, args);
    }

    private static class Args
    extends HashMap<String, Object> {
        private static final long serialVersionUID = 3064164898156692557L;

        private Args() {
        }
    }

    public static enum EventType {
        ADD_NODE,
        ADD_NODE_ATTRIBUTE,
        SET_NODE_ATTRIBUTE,
        DEL_NODE_ATTRIBUTE,
        DEL_NODE,
        ADD_EDGE,
        ADD_EDGE_ATTRIBUTE,
        SET_EDGE_ATTRIBUTE,
        DEL_EDGE_ATTRIBUTE,
        DEL_EDGE,
        ADD_GRAPH_ATTRIBUTE,
        SET_GRAPH_ATTRIBUTE,
        DEL_GRAPH_ATTRIBUTE,
        CLEAR,
        STEP_BEGINS;

    }
}

