/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.util;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class Logger {
    public static Logger GLOBAL_LOGGER;
    protected String logFileName = "stderr";
    protected boolean logFileOpened = false;
    protected static PrintWriter out;
    protected LogLevel logLevel = LogLevel.DEBUG;

    public void log(LogLevel level, String ref, Exception e) {
        if (level.ge(this.logLevel)) {
            try {
                this.openLogFile();
                out.printf("%-5s : %s : %s\n", this.logLevel.info, ref, e.toString());
                out.printf("The exception is in %s", Thread.currentThread().toString());
                e.printStackTrace(out);
                out.flush();
            }
            catch (IOException ioe) {
                System.err.printf("%-5s : %s : %s\n", "ERROR", "Environment", ioe.toString());
                ioe.printStackTrace();
                System.exit(0);
            }
        }
    }

    public void log(LogLevel level, String ref, String message, Object ... params) {
        if (level.ge(this.logLevel)) {
            try {
                this.openLogFile();
                out.printf("%-5s : %s : ", level.info, ref);
                out.printf(message, params);
                out.printf("%n", new Object[0]);
                out.flush();
            }
            catch (IOException ioe) {
                System.err.printf("%-5s : %s : %s\n", "ERROR", "Environment", ioe.toString());
                ioe.printStackTrace();
                System.exit(0);
            }
        }
    }

    protected void openLogFile() throws IOException {
        if (!this.logFileOpened) {
            out = this.logFileName.equals("stderr") ? new PrintWriter(System.err) : new PrintWriter(new BufferedWriter(new FileWriter(this.logFileName)));
            this.logFileOpened = true;
        }
    }

    public void setLogLevel(LogLevel level) {
        this.logLevel = level;
    }

    public static Logger getGlobalLogger() {
        if (GLOBAL_LOGGER == null) {
            GLOBAL_LOGGER = new Logger();
        }
        return GLOBAL_LOGGER;
    }

    public static enum LogLevel {
        DEBUG("Debug", 0),
        INFO("Info", 1),
        WARN("Warning", 2),
        ERROR("Error", 3),
        RESULT("Result", 4);

        public String info;
        public int value;

        private LogLevel(String info, int value) {
            this.info = info;
            this.value = value;
        }

        public boolean ge(LogLevel other) {
            return this.value >= other.value;
        }
    }
}

