/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file.test;

import org.graphstream.graph.implementations.MultiGraph;
import org.graphstream.stream.file.FileSourceDOT;
import org.graphstream.stream.file.test.TestFileSourceBase;
import org.junit.Before;

public class TestFileSourceDOT
extends TestFileSourceBase {
    protected static String TEST1_TRIANGLE = "graph test1 {\n    graph [ id=\"test1\" ];\n    A -- B [ id=AB ];\n    B -- C [ id=BC ];\n    C -- A [ id=CA ];\n}\n";
    protected static String TEST2_DIRECTED_TRIANGLE = "graph test2 {\n    graph [ id=\"test2\" ];\n    A -> B [ id=AB ];\n    B -- C [ id=BC ];\n    A -> C [ id=CA ];\n}\n";
    protected static String TEST3_ATTRIBUTES = "graph test3 {\n    graph [ id=\"test3\" ];\n    A [ a=1, b=truc, c=true ];\n    B [ aa=\"1,2,3,4\", bb=\"foo\", cc=bar ];\n    C [ aaa=1.234 ];\n    A -- B [ id=AB ];\n    B -- C [ id=BC ];\n    C -- A [ id=CA ];\n}\n";

    @Before
    public void setUp() {
        this.graph = new MultiGraph("g1");
        this.input = new FileSourceDOT();
    }

    public static void main(String[] args) {
        TestFileSourceDOT fid = new TestFileSourceDOT();
        fid.setUp();
        fid.test_Access_ReadAll_URL();
    }

    @Override
    public String anUndirectedTriangle() {
        return TEST1_TRIANGLE;
    }

    @Override
    public String aDirectedTriangle() {
        return TEST2_DIRECTED_TRIANGLE;
    }

    @Override
    public String basicAttributes() {
        return TEST3_ATTRIBUTES;
    }

    @Override
    public String anUndirectedTriangleFileName() {
        return "src-test/org/graphstream/stream/file/test/data/undirectedTriangle.dot";
    }

    @Override
    public String anUndirectedTriangleHttpURL() {
        return "http://graphstream-project.org/media/data/undirectedTriangle.dot";
    }
}

