/*
 * This file is part of OpenModelica.
 *
 * Copyright (c) 1998-CurrentYear, Open Source Modelica Consortium (OSMC),
 * c/o Linköpings universitet, Department of Computer and Information Science,
 * SE-58183 Linköping, Sweden.
 *
 * All rights reserved.
 *
 * THIS PROGRAM IS PROVIDED UNDER THE TERMS OF GPL VERSION 3 LICENSE OR
 * THIS OSMC PUBLIC LICENSE (OSMC-PL) VERSION 1.2.
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THE OSMC PUBLIC LICENSE OR THE GPL VERSION 3,
 * ACCORDING TO RECIPIENTS CHOICE.
 *
 * The OpenModelica software and the Open Source Modelica
 * Consortium (OSMC) Public License (OSMC-PL) are obtained
 * from OSMC, either from the above address,
 * from the URLs: http://www.ida.liu.se/projects/OpenModelica or
 * http://www.openmodelica.org, and in the OpenModelica distribution.
 * GNU version 3 is obtained from: http://www.gnu.org/copyleft/gpl.html.
 *
 * This program is distributed WITHOUT ANY WARRANTY; without
 * even the implied warranty of  MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE, EXCEPT AS EXPRESSLY SET FORTH
 * IN THE BY RECIPIENT SELECTED SUBSIDIARY LICENSE CONDITIONS OF OSMC-PL.
 *
 * See the full OSMC Public License conditions for more details.
 *
 */

#include <OMSBoost.h>

boost::filesystem::path oms_temp_directory_path(void)
{
#if (BOOST_VERSION >= 104600) // no temp_directory_path in boost < 1.46
  return boost::filesystem::temp_directory_path();

#else

#if (_WIN32)

 char* val = (char*)malloc(sizeof(char)*(MAX_PATH + 1));
 GetTempPath(MAX_PATH, val);

 boost::filesystem::path p((val!=0) ? val : "/tmp");
 if (val) free(val);
 return p;

#else

 const char* val = 0;

 (val = std::getenv("TMPDIR" )) ||
 (val = std::getenv("TMP"    )) ||
 (val = std::getenv("TEMP"   )) ||
 (val = std::getenv("TEMPDIR"));

 boost::filesystem::path p((val!=0) ? val : "/tmp");
 return p;
#endif // win32

#endif // boost version
}


boost::filesystem::path oms_canonical(boost::filesystem::path p)
{
#if (BOOST_VERSION >= 104600) // no temp_directory_path in boost < 1.46
  return boost::filesystem::canonical(p);
#else
  return p;
#endif
}

boost::filesystem::path oms_unique_path(std::string prefix)
{
#if (BOOST_VERSION >= 104500) // no temp_directory_path in boost < 1.45
  return boost::filesystem::unique_path(prefix + "-%%%%");
#else
  int i;
  std::string s = prefix + "-";
  for(i=0; i<4; i++)
    s += std::string(1, ('A' + rand()%26));
  boost::filesystem::path p(s);
  return p;
#endif
}

/*

The code above is partially based on the boost implementation for
boost::filesystem::temp_directory_path.

Boost Software License - Version 1.0 - August 17th, 2003

Permission is hereby granted, free of charge, to any person or organization
obtaining a copy of the software and accompanying documentation covered by
this license (the "Software") to use, reproduce, display, distribute,
execute, and transmit the Software, and to prepare derivative works of the
Software, and to permit third-parties to whom the Software is furnished to
do so, all subject to the following:

The copyright notices in the Software and this entire statement, including
the above license grant, this restriction and the following disclaimer,
must be included in all copies of the Software, in whole or in part, and
all derivative works of the Software, unless such copies or derivative
works are solely in the form of machine-executable object code generated by
a source language processor.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.

*/
