/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.test;

import java.util.LinkedList;
import java.util.Random;
import org.graphstream.stream.Sink;
import org.graphstream.stream.SourceBase;
import org.junit.Assert;
import org.junit.Test;

public class TestSourceBase {
    protected static String getRandomString(int size) {
        String chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_-%=+/:";
        StringBuilder sb = new StringBuilder();
        Random r = new Random();
        while (size-- > 0) {
            sb.append("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_-%=+/:".charAt(r.nextInt("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_-%=+/:".length())));
        }
        return sb.toString();
    }

    protected LinkedList<Event> generateEventList(int size) {
        Random r = new Random();
        LinkedList<Event> events = new LinkedList<Event>();
        EventType[] types = EventType.values();
        while (size-- > 0) {
            String sourceId = TestSourceBase.getRandomString(10);
            long timeId = r.nextLong();
            EventType type = types[r.nextInt(types.length)];
            Object[] args = null;
            switch (type) {
                case AN: {
                    args = new Object[]{TestSourceBase.getRandomString(10)};
                    break;
                }
                case DN: {
                    args = new Object[]{TestSourceBase.getRandomString(10)};
                    break;
                }
                case CNA: {
                    args = new Object[]{TestSourceBase.getRandomString(10), TestSourceBase.getRandomString(10), TestSourceBase.getRandomString(10)};
                    break;
                }
                case CNC: {
                    args = new Object[]{TestSourceBase.getRandomString(10), TestSourceBase.getRandomString(10), TestSourceBase.getRandomString(10), TestSourceBase.getRandomString(10)};
                    break;
                }
                case CNR: {
                    args = new Object[]{TestSourceBase.getRandomString(10), TestSourceBase.getRandomString(10)};
                    break;
                }
                case AE: {
                    args = new Object[]{TestSourceBase.getRandomString(10), TestSourceBase.getRandomString(10), TestSourceBase.getRandomString(10), r.nextBoolean()};
                    break;
                }
                case DE: {
                    args = new Object[]{TestSourceBase.getRandomString(10)};
                    break;
                }
                case CEA: {
                    args = new Object[]{TestSourceBase.getRandomString(10), TestSourceBase.getRandomString(10), TestSourceBase.getRandomString(10)};
                    break;
                }
                case CEC: {
                    args = new Object[]{TestSourceBase.getRandomString(10), TestSourceBase.getRandomString(10), TestSourceBase.getRandomString(10), TestSourceBase.getRandomString(10)};
                    break;
                }
                case CER: {
                    args = new Object[]{TestSourceBase.getRandomString(10), TestSourceBase.getRandomString(10)};
                    break;
                }
                case CGA: {
                    args = new Object[]{TestSourceBase.getRandomString(10), TestSourceBase.getRandomString(10)};
                    break;
                }
                case CGC: {
                    args = new Object[]{TestSourceBase.getRandomString(10), TestSourceBase.getRandomString(10), TestSourceBase.getRandomString(10)};
                    break;
                }
                case CGR: {
                    args = new Object[]{TestSourceBase.getRandomString(10)};
                    break;
                }
                case ST: {
                    args = new Object[]{r.nextDouble()};
                    break;
                }
            }
            if (args == null) {
                events.add(new Event(type, sourceId, timeId, new Object[0]));
                continue;
            }
            events.add(new Event(type, sourceId, timeId, args));
        }
        return events;
    }

    @Test
    public void testSentEvents() {
        LinkedList<Event> events = this.generateEventList(10000);
        TestSource source = new TestSource();
        EventStack stack = new EventStack();
        source.addSink(stack);
        for (Event e : events) {
            this.send(source, e);
        }
        Assert.assertEquals((long)events.size(), (long)stack.size());
        int i = 0;
        while (i < events.size()) {
            events.get(i).assertEventEquals((Event)stack.get(i));
            ++i;
        }
    }

    protected void send(SourceBase base, Event e) {
        switch (e.type) {
            case AN: {
                base.sendNodeAdded(e.sourceId, e.timeId, (String)e.args[0]);
                break;
            }
            case DN: {
                base.sendNodeRemoved(e.sourceId, e.timeId, (String)e.args[0]);
                break;
            }
            case CNA: {
                base.sendNodeAttributeAdded(e.sourceId, e.timeId, (String)e.args[0], (String)e.args[1], e.args[2]);
                break;
            }
            case CNC: {
                base.sendNodeAttributeChanged(e.sourceId, e.timeId, (String)e.args[0], (String)e.args[1], e.args[2], e.args[3]);
                break;
            }
            case CNR: {
                base.sendNodeAttributeRemoved(e.sourceId, e.timeId, (String)e.args[0], (String)e.args[1]);
                break;
            }
            case AE: {
                base.sendEdgeAdded(e.sourceId, e.timeId, (String)e.args[0], (String)e.args[1], (String)e.args[2], (Boolean)e.args[3]);
                break;
            }
            case DE: {
                base.sendEdgeRemoved(e.sourceId, e.timeId, (String)e.args[0]);
                break;
            }
            case CEA: {
                base.sendEdgeAttributeAdded(e.sourceId, e.timeId, (String)e.args[0], (String)e.args[1], e.args[2]);
                break;
            }
            case CEC: {
                base.sendEdgeAttributeChanged(e.sourceId, e.timeId, (String)e.args[0], (String)e.args[1], e.args[2], e.args[3]);
                break;
            }
            case CER: {
                base.sendEdgeAttributeRemoved(e.sourceId, e.timeId, (String)e.args[0], (String)e.args[1]);
                break;
            }
            case CGA: {
                base.sendGraphAttributeAdded(e.sourceId, e.timeId, (String)e.args[0], e.args[1]);
                break;
            }
            case CGC: {
                base.sendGraphAttributeChanged(e.sourceId, e.timeId, (String)e.args[0], e.args[1], e.args[2]);
                break;
            }
            case CGR: {
                base.sendGraphAttributeRemoved(e.sourceId, e.timeId, (String)e.args[0]);
                break;
            }
            case ST: {
                base.sendStepBegins(e.sourceId, e.timeId, (Double)e.args[0]);
                break;
            }
            case CL: {
                base.sendGraphCleared(e.sourceId, e.timeId);
            }
        }
    }

    static class Event {
        EventType type;
        String sourceId;
        long timeId;
        Object[] args;

        Event(EventType type, String sourceId, long timeId, Object ... args) {
            this.type = type;
            this.sourceId = sourceId;
            this.timeId = timeId;
            this.args = args;
        }

        public void assertEventEquals(Event e) {
            Assert.assertEquals((Object)((Object)e.type), (Object)((Object)this.type));
            Assert.assertEquals((Object)this.sourceId, (Object)e.sourceId);
            Assert.assertEquals((long)this.timeId, (long)e.timeId);
            Assert.assertFalse((boolean)(this.args == null ^ e.args == null));
            if (this.args != null) {
                Assert.assertArrayEquals((Object[])this.args, (Object[])e.args);
            }
        }
    }

    static class EventStack
    extends LinkedList<Event>
    implements Sink {
        private static final long serialVersionUID = -4953996922753724259L;

        EventStack() {
        }

        @Override
        public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
            Event e = new Event(EventType.CEA, sourceId, timeId, edgeId, attribute, value);
            this.addLast(e);
        }

        @Override
        public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
            Event e = new Event(EventType.CEC, sourceId, timeId, edgeId, attribute, oldValue, newValue);
            this.addLast(e);
        }

        @Override
        public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
            Event e = new Event(EventType.CER, sourceId, timeId, edgeId, attribute);
            this.addLast(e);
        }

        @Override
        public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
            Event e = new Event(EventType.CGA, sourceId, timeId, attribute, value);
            this.addLast(e);
        }

        @Override
        public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
            Event e = new Event(EventType.CGC, sourceId, timeId, attribute, oldValue, newValue);
            this.addLast(e);
        }

        @Override
        public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
            Event e = new Event(EventType.CGR, sourceId, timeId, attribute);
            this.addLast(e);
        }

        @Override
        public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
            Event e = new Event(EventType.CNA, sourceId, timeId, nodeId, attribute, value);
            this.addLast(e);
        }

        @Override
        public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
            Event e = new Event(EventType.CNC, sourceId, timeId, nodeId, attribute, oldValue, newValue);
            this.addLast(e);
        }

        @Override
        public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
            Event e = new Event(EventType.CNR, sourceId, timeId, nodeId, attribute);
            this.addLast(e);
        }

        @Override
        public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
            Event e = new Event(EventType.AE, sourceId, timeId, edgeId, fromNodeId, toNodeId, directed);
            this.addLast(e);
        }

        @Override
        public void edgeRemoved(String sourceId, long timeId, String edgeId) {
            Event e = new Event(EventType.DE, sourceId, timeId, edgeId);
            this.addLast(e);
        }

        @Override
        public void graphCleared(String sourceId, long timeId) {
            Event e = new Event(EventType.CL, sourceId, timeId, new Object[0]);
            this.addLast(e);
        }

        @Override
        public void nodeAdded(String sourceId, long timeId, String nodeId) {
            Event e = new Event(EventType.AN, sourceId, timeId, nodeId);
            this.addLast(e);
        }

        @Override
        public void nodeRemoved(String sourceId, long timeId, String nodeId) {
            Event e = new Event(EventType.DN, sourceId, timeId, nodeId);
            this.addLast(e);
        }

        @Override
        public void stepBegins(String sourceId, long timeId, double step) {
            Event e = new Event(EventType.ST, sourceId, timeId, step);
            this.addLast(e);
        }
    }

    static enum EventType {
        AN,
        DN,
        CNA,
        CNC,
        CNR,
        AE,
        DE,
        CEA,
        CEC,
        CER,
        CGA,
        CGC,
        CGR,
        ST,
        CL;

    }

    static class TestSource
    extends SourceBase {
        TestSource() {
        }
    }
}

