/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.util;

import java.util.Iterator;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.util.Filter;

public class FilteredNodeIterator<T extends Node>
implements Iterator<T> {
    protected Iterator<T> globalIterator;
    protected Filter<Node> filter;
    protected T next;

    public FilteredNodeIterator(Graph g, Filter<Node> filter) {
        this(g.getNodeIterator(), filter);
    }

    public FilteredNodeIterator(Iterator<T> ite, Filter<Node> filter) {
        this.globalIterator = ite;
        this.filter = filter;
        this.findNext();
    }

    protected void findNext() {
        this.next = null;
        while (this.globalIterator.hasNext() && this.next == null) {
            this.next = (Node)this.globalIterator.next();
            if (this.filter.isAvailable((Node)this.next)) continue;
            this.next = null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public T next() {
        T tmp = this.next;
        this.findNext();
        return tmp;
    }

    @Override
    public void remove() {
    }
}

