/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.graphicGraph;

import java.util.ArrayList;
import java.util.HashMap;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.AbstractElement;
import org.graphstream.stream.SourceBase;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.graphicGraph.GraphicNode;
import org.graphstream.ui.graphicGraph.stylesheet.Selector;

public class GraphicEdge
extends GraphicElement
implements Edge {
    public GraphicNode from;
    public GraphicNode to;
    public boolean directed;
    public int multi;
    public EdgeGroup group;
    public double[] ctrl;

    public GraphicEdge(String id, GraphicNode from, GraphicNode to, boolean dir, HashMap<String, Object> attributes) {
        super(id, from.mygraph);
        this.from = from;
        this.to = to;
        this.directed = dir;
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        if (attributes != null) {
            this.addAttributes(attributes);
        }
    }

    @Override
    public Selector.Type getSelectorType() {
        return Selector.Type.EDGE;
    }

    public GraphicNode otherNode(GraphicNode n) {
        return (GraphicNode)this.getOpposite(n);
    }

    @Override
    public double getX() {
        return this.from.x + (this.to.x - this.from.x) / 2.0;
    }

    @Override
    public double getY() {
        return this.from.y + (this.to.y - this.from.y) / 2.0;
    }

    @Override
    public double getZ() {
        return this.from.z + (this.to.z - this.from.z) / 2.0;
    }

    public double[] getControlPoints() {
        return this.ctrl;
    }

    public boolean isCurve() {
        return this.ctrl != null;
    }

    public void setControlPoints(double[] points) {
        this.ctrl = points;
    }

    public int getMultiIndex() {
        return this.multi;
    }

    @Override
    public void move(double x, double y, double z) {
    }

    @Override
    protected void attributeChanged(AbstractElement.AttributeChangeEvent event, String attribute, Object oldValue, Object newValue) {
        super.attributeChanged(event, attribute, oldValue, newValue);
        if (attribute.startsWith("ui.sprite.")) {
            this.mygraph.spriteAttribute(event, this, attribute, newValue);
        }
        this.mygraph.listeners.sendAttributeChangedEvent(this.getId(), SourceBase.ElementType.EDGE, attribute, event, oldValue, newValue);
    }

    protected void countSameEdges(ArrayList<GraphicEdge> edgeList) {
        for (GraphicEdge other : edgeList) {
            if (other == this || (other.from != this.from || other.to != this.to) && (other.to != this.from || other.from != this.to)) continue;
            this.group = other.group;
            if (this.group == null) {
                this.group = new EdgeGroup(other, this);
                break;
            }
            this.group.increment(this);
            break;
        }
    }

    @Override
    public void removed() {
        if (this.group != null) {
            this.group.decrement(this);
            if (this.group.getCount() == 1) {
                this.group = null;
            }
        }
    }

    @Override
    public <T extends Node> T getNode0() {
        return (T)this.from;
    }

    @Override
    public <T extends Node> T getNode1() {
        return (T)this.to;
    }

    public EdgeGroup getGroup() {
        return this.group;
    }

    @Override
    public <T extends Node> T getOpposite(Node node) {
        if (node == this.from) {
            return (T)this.to;
        }
        return (T)this.from;
    }

    @Override
    public <T extends Node> T getSourceNode() {
        return (T)this.from;
    }

    @Override
    public <T extends Node> T getTargetNode() {
        return (T)this.to;
    }

    @Override
    public boolean isDirected() {
        return this.directed;
    }

    @Override
    public boolean isLoop() {
        return this.from == this.to;
    }

    public void setDirected(boolean on) {
        this.directed = on;
    }

    public void switchDirection() {
        GraphicNode tmp = this.from;
        this.from = this.to;
        this.to = tmp;
    }

    public class EdgeGroup {
        public ArrayList<GraphicEdge> edges = new ArrayList();

        public EdgeGroup(GraphicEdge first, GraphicEdge second) {
            first.group = this;
            second.group = this;
            this.edges.add(first);
            this.edges.add(second);
            first.multi = 0;
            second.multi = 1;
        }

        public GraphicEdge getEdge(int i) {
            return this.edges.get(i);
        }

        public int getCount() {
            return this.edges.size();
        }

        public void increment(GraphicEdge edge) {
            edge.multi = this.getCount();
            this.edges.add(edge);
        }

        public void decrement(GraphicEdge edge) {
            this.edges.remove(this.edges.indexOf(edge));
            int i = 0;
            while (i < this.edges.size()) {
                this.edges.get((int)i).multi = i;
                ++i;
            }
        }
    }
}

