/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.geom;

import java.io.Serializable;
import org.graphstream.ui.geom.Point2;
import org.graphstream.ui.geom.Vector3;

public class Point3
extends Point2
implements Serializable {
    private static final long serialVersionUID = 5971336344439693816L;
    public double z;
    public static final Point3 NULL_POINT3 = new Point3(0.0, 0.0, 0.0);

    public Point3() {
    }

    public Point3(double x, double y) {
        this.set(x, y, 0.0);
    }

    public Point3(double x, double y, double z) {
        this.set(x, y, z);
    }

    public Point3(Point3 other) {
        this.copy(other);
    }

    public Point3(Vector3 vec) {
        this.copy(vec);
    }

    public Point3(float[] data) {
        this(0, data);
    }

    public Point3(double[] data) {
        this(0, data);
    }

    public Point3(int start, float[] data) {
        if (data != null) {
            if (data.length > start + 0) {
                this.x = data[start + 0];
            }
            if (data.length > start + 1) {
                this.y = data[start + 1];
            }
            if (data.length > start + 2) {
                this.z = data[start + 2];
            }
        }
    }

    public Point3(int start, double[] data) {
        if (data != null) {
            if (data.length > start + 0) {
                this.x = data[start + 0];
            }
            if (data.length > start + 1) {
                this.y = data[start + 1];
            }
            if (data.length > start + 2) {
                this.z = data[start + 2];
            }
        }
    }

    @Override
    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    public Point3 interpolate(Point3 other, double factor) {
        Point3 p = new Point3(this.x + (other.x - this.x) * factor, this.y + (other.y - this.y) * factor, this.z + (other.z - this.z) * factor);
        return p;
    }

    public double distance(Point3 other) {
        double xx = other.x - this.x;
        double yy = other.y - this.y;
        double zz = other.z - this.z;
        return Math.abs(Math.sqrt(xx * xx + yy * yy + zz * zz));
    }

    public double distance(double x, double y, double z) {
        double xx = x - this.x;
        double yy = y - this.y;
        double zz = z - this.z;
        return Math.abs(Math.sqrt(xx * xx + yy * yy + zz * zz));
    }

    public void copy(Point3 other) {
        this.x = other.x;
        this.y = other.y;
        this.z = other.z;
    }

    public void copy(Vector3 vec) {
        this.x = vec.data[0];
        this.y = vec.data[1];
        this.z = vec.data[2];
    }

    public void set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void moveTo(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void move(double dx, double dy, double dz) {
        this.x += dx;
        this.y += dy;
        this.z += dz;
    }

    public void move(Point3 p) {
        this.x += p.x;
        this.y += p.y;
        this.z += p.z;
    }

    public void move(Vector3 d) {
        this.x += d.data[0];
        this.y += d.data[1];
        this.z += d.data[2];
    }

    public void moveZ(double dz) {
        this.z += dz;
    }

    public void scale(double sx, double sy, double sz) {
        this.x *= sx;
        this.y *= sy;
        this.z *= sz;
    }

    public void scale(Point3 s) {
        this.x *= s.x;
        this.y *= s.y;
        this.z *= s.z;
    }

    public void scale(Vector3 s) {
        this.x *= s.data[0];
        this.y *= s.data[1];
        this.z *= s.data[2];
    }

    public void scale(double scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public void swap(Point3 other) {
        if (other != this) {
            double t = this.x;
            this.x = other.x;
            other.x = t;
            t = this.y;
            this.y = other.y;
            other.y = t;
            t = this.z;
            this.z = other.z;
            other.z = t;
        }
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer("Point3[");
        buf.append(this.x);
        buf.append('|');
        buf.append(this.y);
        buf.append('|');
        buf.append(this.z);
        buf.append("]");
        return buf.toString();
    }
}

