/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.layout;

import org.graphstream.graph.Graph;
import org.graphstream.stream.ProxyPipe;
import org.graphstream.stream.Source;
import org.graphstream.stream.thread.ThreadProxyPipe;
import org.graphstream.ui.layout.Layout;

public class LayoutRunner
extends Thread {
    protected Layout layout = null;
    protected ThreadProxyPipe pumpPipe = null;
    protected boolean loop = true;
    protected long longNap = 80L;
    protected long shortNap = 10L;

    public LayoutRunner(Source source, Layout layout) {
        this(source, layout, true);
    }

    public LayoutRunner(Source source, Layout layout, boolean start) {
        this.layout = layout;
        this.pumpPipe = new ThreadProxyPipe();
        this.pumpPipe.addSink(layout);
        if (start) {
            this.start();
        }
        this.pumpPipe.init(source);
    }

    public LayoutRunner(Graph graph, Layout layout, boolean start, boolean replay) {
        this.layout = layout;
        this.pumpPipe = new ThreadProxyPipe();
        this.pumpPipe.addSink(layout);
        if (start) {
            this.start();
        }
        this.pumpPipe.init(graph, replay);
    }

    public ProxyPipe newLayoutPipe() {
        ThreadProxyPipe tpp = new ThreadProxyPipe();
        tpp.init(this.layout);
        return tpp;
    }

    @Override
    public void run() {
        String layoutName = this.layout.getLayoutAlgorithmName();
        while (this.loop) {
            double limit = this.layout.getStabilizationLimit();
            this.pumpPipe.pump();
            if (limit > 0.0) {
                if (this.layout.getStabilization() > limit) {
                    this.nap(this.longNap);
                    continue;
                }
                this.layout.compute();
                this.nap(this.shortNap);
                continue;
            }
            this.layout.compute();
            this.nap(this.shortNap);
        }
        System.out.printf("Layout '%s' process stopped.%n", layoutName);
        System.out.flush();
    }

    public void release() {
        this.pumpPipe.unregisterFromSource();
        this.pumpPipe.removeSink(this.layout);
        this.pumpPipe = null;
        this.loop = false;
        if (Thread.currentThread() != this) {
            try {
                this.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                System.err.printf("Layout can not stop ...\n", new Object[0]);
            }
        }
        this.layout = null;
    }

    protected void nap(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setNaps(long longNap, long shortNap) {
        this.longNap = longNap;
        this.shortNap = shortNap;
    }
}

