/*
 * This file is part of OpenModelica.
 *
 * Copyright (c) 1998-CurrentYear, Open Source Modelica Consortium (OSMC),
 * c/o Linköpings universitet, Department of Computer and Information Science,
 * SE-58183 Linköping, Sweden.
 *
 * All rights reserved.
 *
 * THIS PROGRAM IS PROVIDED UNDER THE TERMS OF THE BSD NEW LICENSE OR THE
 * GPL VERSION 3 LICENSE OR THE OSMC PUBLIC LICENSE (OSMC-PL) VERSION 1.2.
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THE OSMC PUBLIC LICENSE OR THE GPL VERSION 3,
 * ACCORDING TO RECIPIENTS CHOICE.
 *
 * The OpenModelica software and the OSMC (Open Source Modelica Consortium)
 * Public License (OSMC-PL) are obtained from OSMC, either from the above
 * address, from the URLs: http://www.openmodelica.org or
 * http://www.ida.liu.se/projects/OpenModelica, and in the OpenModelica
 * distribution. GNU version 3 is obtained from:
 * http://www.gnu.org/copyleft/gpl.html. The New BSD License is obtained from:
 * http://www.opensource.org/licenses/BSD-3-Clause.
 *
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE, EXCEPT AS
 * EXPRESSLY SET FORTH IN THE BY RECIPIENT SELECTED SUBSIDIARY LICENSE
 * CONDITIONS OF OSMC-PL.
 *
 */

/* Simulation help constants are available in the regular runtime so we can link omc with them */

#ifndef OPENMODELICA_SIMULATION_OPTIONS_H
#define OPENMODELICA_SIMULATION_OPTIONS_H

#if defined(__cplusplus)
  extern "C" {
#endif

#define EXPANDSTRING(s) EXPANDSTRINGHELPER(s)
#define EXPANDSTRINGHELPER(s) #s

#define DEFAULT_FLAG_LSS_MIN_SIZE 201
#define DEFAULT_FLAG_NLS_MIN_SIZE 10001

enum _FLAG
{
  FLAG_UNKNOWN = 0,

  FLAG_ABORT_SLOW,
  FLAG_ALARM,
  FLAG_CLOCK,
  FLAG_CPU,
  FLAG_CSV_OSTEP,
  FLAG_CVODE_ITER,
  FLAG_CVODE_LMM,
  FLAG_DAE_MODE,
  FLAG_DELTA_X_LINEARIZE,
  FLAG_DELTA_X_SOLVER,
  FLAG_EMBEDDED_SERVER,
  FLAG_EMBEDDED_SERVER_PORT,
  FLAG_MAT_SYNC,
  FLAG_EMIT_PROTECTED,
  FLAG_DATA_RECONCILE_Eps,
  FLAG_F,
  FLAG_HELP,
  FLAG_HOMOTOPY_ADAPT_BEND,
  FLAG_HOMOTOPY_BACKTRACE_STRATEGY,
  FLAG_HOMOTOPY_H_EPS,
  FLAG_HOMOTOPY_MAX_LAMBDA_STEPS,
  FLAG_HOMOTOPY_MAX_NEWTON_STEPS,
  FLAG_HOMOTOPY_MAX_TRIES,
  FLAG_HOMOTOPY_NEG_START_DIR,
  FLAG_HOMOTOPY_ON_FIRST_TRY,
  FLAG_NO_HOMOTOPY_ON_FIRST_TRY,
  FLAG_HOMOTOPY_TAU_DEC_FACTOR,
  FLAG_HOMOTOPY_TAU_DEC_FACTOR_PRED,
  FLAG_HOMOTOPY_TAU_INC_FACTOR,
  FLAG_HOMOTOPY_TAU_INC_THRESHOLD,
  FLAG_HOMOTOPY_TAU_MAX,
  FLAG_HOMOTOPY_TAU_MIN,
  FLAG_HOMOTOPY_TAU_START,
  FLAG_IDA_MAXERRORTESTFAIL,
  FLAG_IDA_MAXNONLINITERS,
  FLAG_IDA_MAXCONVFAILS,
  FLAG_IDA_NONLINCONVCOEF,
  FLAG_IDA_LS,
  FLAG_IDA_SCALING,
  FLAG_IDAS,
  FLAG_IGNORE_HIDERESULT,
  FLAG_IIF,
  FLAG_IIM,
  FLAG_IIT,
  FLAG_ILS,
  FLAG_IMPRK_ORDER,
  FLAG_IMPRK_LS,
  FLAG_INITIAL_STEP_SIZE,
  FLAG_INPUT_CSV,
  FLAG_INPUT_FILE,
  FLAG_INPUT_FILE_STATES,
  FLAG_INPUT_PATH,
  FLAG_IPOPT_HESSE,
  FLAG_IPOPT_INIT,
  FLAG_IPOPT_JAC,
  FLAG_IPOPT_MAX_ITER,
  FLAG_IPOPT_WARM_START,
  FLAG_JACOBIAN,
  FLAG_JACOBIAN_THREADS,
  FLAG_L,
  FLAG_L_DATA_RECOVERY,
  FLAG_LOG_FORMAT,
  FLAG_LS,
  FLAG_LS_IPOPT,
  FLAG_LSS,
  FLAG_LSS_MAX_DENSITY,
  FLAG_LSS_MIN_SIZE,
  FLAG_LV,
  FLAG_LV_TIME,
  FLAG_MAX_BISECTION_ITERATIONS,
  FLAG_MAX_EVENT_ITERATIONS,
  FLAG_MAX_ORDER,
  FLAG_MAX_STEP_SIZE,
  FLAG_MEASURETIMEPLOTFORMAT,
  FLAG_NEWTON_FTOL,
  FLAG_NEWTON_MAX_STEP_FACTOR,
  FLAG_NEWTON_XTOL,
  FLAG_NEWTON_STRATEGY,
  FLAG_NLS,
  FLAG_NLS_INFO,
  FLAG_NLS_LS,
  FLAG_NLS_MAX_DENSITY,
  FLAG_NLS_MIN_SIZE,
  FLAG_NOEMIT,
  FLAG_NOEQUIDISTANT_GRID,
  FLAG_NOEQUIDISTANT_OUT_FREQ,
  FLAG_NOEQUIDISTANT_OUT_TIME,
  FLAG_NOEVENTEMIT,
  FLAG_NO_RESTART,
  FLAG_NO_ROOTFINDING,
  FLAG_NO_SCALING,
  FLAG_NO_SUPPRESS_ALG,
  FLAG_OPTDEBUGEJAC,
  FLAG_OPTIMIZER_NP,
  FLAG_OPTIMIZER_TGRID,
  FLAG_OUTPUT,
  FLAG_OUTPUT_PATH,
  FLAG_OVERRIDE,
  FLAG_OVERRIDE_FILE,
  FLAG_PORT,
  FLAG_R,
  FLAG_DATA_RECONCILE,
  FLAG_RT,
  FLAG_S,
  FLAG_SINGLE_PRECISION,
  FLAG_SOLVER_STEPS,
  FLAG_STEADY_STATE,
  FLAG_STEADY_STATE_TOL,
  FLAG_DATA_RECONCILE_Sx,
  FLAG_UP_HESSIAN,
  FLAG_W,

  FLAG_MAX
};

enum _FLAG_TYPE
{
  FLAG_TYPE_UNKNOWN = 0,

  FLAG_TYPE_FLAG,         /* e.g. -f */
  FLAG_TYPE_OPTION,       /* e.g. -f=value or -f value */

  FLAG_TYPE_MAX
};

extern const char *FLAG_NAME[FLAG_MAX+1];
extern const char *FLAG_DESC[FLAG_MAX+1];
extern const char *FLAG_DETAILED_DESC[FLAG_MAX+1];
extern const int FLAG_TYPE[FLAG_MAX];

enum SOLVER_METHOD
{
  S_UNKNOWN = 0,

  S_EULER,
  S_HEUN,
  S_RUNGEKUTTA,
  S_IMPEULER,
  S_TRAPEZOID,
  S_IMPRUNGEKUTTA,
  S_IRKSCO,
  S_DASSL,
  S_IDA,
  S_CVODE,
  S_ERKSSC,
  S_SYM_SOLVER,
  S_SYM_SOLVER_SSC,
  S_QSS,
  S_OPTIMIZATION,

  S_MAX
};

extern const char *SOLVER_METHOD_NAME[S_MAX];
extern const char *SOLVER_METHOD_DESC[S_MAX];

enum INIT_INIT_METHOD
{
  IIM_UNKNOWN = 0,
  IIM_NONE,
  IIM_SYMBOLIC,
  IIM_MAX
};

extern const char *INIT_METHOD_NAME[IIM_MAX];
extern const char *INIT_METHOD_DESC[IIM_MAX];

enum LINEAR_SOLVER
{
  LS_NONE = 0,

  LS_LAPACK,
#if !defined(OMC_MINIMAL_RUNTIME)
  LS_LIS,
#else
  LS_LIS_NOT_AVAILABLE,
#endif
  LS_KLU,
  LS_UMFPACK,
  LS_TOTALPIVOT,
  LS_DEFAULT,

  LS_MAX
};
extern const char *LS_NAME[LS_MAX];
extern const char *LS_DESC[LS_MAX];

enum LINEAR_SPARSE_SOLVER
{
  LSS_NONE = 0,

  LSS_DEFAULT,
#if !defined(OMC_MINIMAL_RUNTIME)
  LSS_LIS,
#else
  LSS_LIS_NOT_AVAILABLE,
#endif
  LSS_KLU,
  LSS_UMFPACK,
  LSS_MAX
};

extern const char *LSS_NAME[LSS_MAX];
extern const char *LSS_DESC[LSS_MAX];

enum NONLINEAR_SOLVER
{
  NLS_NONE = 0,

#if !defined(OMC_MINIMAL_RUNTIME)
  NLS_HYBRID,
  NLS_KINSOL,
  NLS_NEWTON,
  NLS_MIXED,
#else
  NLS_HYBRID_DOESNT_EXIST,
  NLS_KINSOL_DOESNT_EXIST,
  NLS_NEWTON_DOESNT_EXIST,
  NLS_MIXED_DOESNT_EXIST,
#endif
  NLS_HOMOTOPY,

  NLS_MAX
};

extern const char *NLS_NAME[NLS_MAX];
extern const char *NLS_DESC[NLS_MAX];

enum NEWTON_STRATEGY
{
  NEWTON_NONE = 0,

  NEWTON_DAMPED,
  NEWTON_DAMPED2,
  NEWTON_DAMPED_LS,
  NEWTON_DAMPED_BT,
  NEWTON_PURE,

  NEWTON_MAX
};

extern const char *NEWTONSTRATEGY_NAME[NEWTON_MAX];
extern const char *NEWTONSTRATEGY_DESC[NEWTON_MAX];

enum JACOBIAN_METHOD
{
  JAC_UNKNOWN = 0,

  COLOREDNUMJAC,
  INTERNALNUMJAC,
  COLOREDSYMJAC,
  NUMJAC,
  SYMJAC,

  JAC_MAX
};

extern const char *JACOBIAN_METHOD[JAC_MAX];
extern const char *JACOBIAN_METHOD_DESC[JAC_MAX];

enum IDA_LS
{
  IDA_LS_UNKNOWN = 0,

  IDA_LS_DENSE,
  IDA_LS_KLU,
  IDA_LS_SPGMR,
  IDA_LS_SPBCG,
  IDA_LS_SPTFQMR,

  IDA_LS_MAX
};

extern const char *IDA_LS_METHOD[IDA_LS_MAX];
extern const char *IDA_LS_METHOD_DESC[IDA_LS_MAX];

enum NLS_LS
{
  NLS_LS_UNKNOWN = 0,

  NLS_LS_DEFAULT,

  NLS_LS_TOTALPIVOT,
  NLS_LS_LAPACK,
  NLS_LS_KLU,

  NLS_LS_MAX
};

extern const char *NLS_LS_METHOD[NLS_LS_MAX];
extern const char *NLS_LS_METHOD_DESC[NLS_LS_MAX];

enum IMPRK_LS
{
  IMPRK_LS_UNKNOWN = 0,

  IMPRK_LS_ITERATIVE,
  IMPRK_LS_DENSE,

  IMPRK_LS_MAX
};

extern const char *IMPRK_LS_METHOD[IMPRK_LS_MAX];
extern const char *IMPRK_LS_METHOD_DESC[IMPRK_LS_MAX];

enum HOMOTOPY_BACKTRACE_STRATEGY
{
  HOM_BACK_STRAT_NONE = 0,

  HOM_BACK_STRAT_FIX,
  HOM_BACK_STRAT_ORTHOGONAL,

  HOM_BACK_STRAT_MAX
};

extern const char *HOM_BACK_STRAT_NAME[HOM_BACK_STRAT_MAX];
extern const char *HOM_BACK_STRAT_DESC[HOM_BACK_STRAT_MAX];

enum FMU_FLAG
{
  FMU_FLAG_UNKNOWN = 0,

  FMU_FLAG_SOLVER,
  FMU_FLAG_NLS,

  FMU_FLAG_MAX
};

/* Flag mapping to use the same descriptions and names for FMU.*/
extern const int FMU_FLAG_MAP[FMU_FLAG_MAX];

#if defined(__cplusplus)
  }
#endif

#endif
