/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.graph.test;

import java.util.HashSet;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Element;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.AdjacencyListGraph;
import org.graphstream.graph.implementations.MultiGraph;
import org.graphstream.graph.implementations.MultiNode;
import org.graphstream.graph.implementations.SingleGraph;
import org.graphstream.stream.Replayable;
import org.junit.Assert;
import org.junit.Test;

public class TestGraph {
    @Test
    public void testBasic() {
        this.testBasic(new SingleGraph("sg"));
        this.testBasic(new MultiGraph("mg"));
        this.testBasic(new AdjacencyListGraph("alg"));
        this.testBasic(new AdjacencyListGraph("AL"));
        this.testBasic(new SingleGraph("S"));
        this.testBasic(new MultiGraph("M"));
    }

    @Test
    public void testReplay() {
        AdjacencyListGraph g1 = new AdjacencyListGraph("g1");
        AdjacencyListGraph g2 = new AdjacencyListGraph("g2");
        Object A1 = g1.addNode("A");
        Object B1 = g1.addNode("B");
        Object C1 = g1.addNode("C");
        Object AB1 = g1.addEdge("AB", "A", "B");
        Object BC1 = g1.addEdge("BC", "B", "C");
        Object CA1 = g1.addEdge("CA", "C", "A");
        A1.addAttribute("string", "an example");
        B1.addAttribute("double", 42.0);
        C1.addAttribute("array", new Object[]{new int[]{1, 2, 3}});
        AB1.addAttribute("string", "an example");
        BC1.addAttribute("double", 42.0);
        CA1.addAttribute("array", new Object[]{new int[]{1, 2, 3}});
        Replayable.Controller controller = g1.getReplayController();
        controller.addSink(g2);
        controller.replay();
        Object A2 = g2.getNode("A");
        Object B2 = g2.getNode("B");
        Object C2 = g2.getNode("C");
        Assert.assertNotNull(A2);
        Assert.assertNotNull(B2);
        Assert.assertNotNull(C2);
        this.checkAttribute((Element)A1, (Element)A2);
        this.checkAttribute((Element)B1, (Element)B2);
        this.checkAttribute((Element)C1, (Element)C2);
        Object AB2 = g2.getEdge("AB");
        Object BC2 = g2.getEdge("BC");
        Object CA2 = g2.getEdge("CA");
        Assert.assertNotNull(AB2);
        Assert.assertNotNull(BC2);
        Assert.assertNotNull(CA2);
        this.checkAttribute((Element)AB1, (Element)AB2);
        this.checkAttribute((Element)BC1, (Element)BC2);
        this.checkAttribute((Element)CA1, (Element)CA2);
    }

    protected void checkAttribute(Element e1, Element e2) {
        for (String key : e1.getAttributeKeySet()) {
            Assert.assertTrue((boolean)e2.hasAttribute(key));
            Assert.assertEquals(e1.getAttribute(key), e2.getAttribute(key));
        }
        for (String key : e2.getAttributeKeySet()) {
            Assert.assertTrue((boolean)e1.hasAttribute(key));
        }
    }

    protected void testBasic(Graph graph) {
        Object A = graph.addNode("A");
        Object B = graph.addNode("B");
        Object C = graph.addNode("C");
        Object AB = graph.addEdge("AB", "A", "B");
        Object BC = graph.addEdge("BC", "B", "C");
        Object CA = graph.addEdge("CA", "C", "A");
        Assert.assertEquals((long)3L, (long)graph.getNodeCount());
        Assert.assertEquals((long)3L, (long)graph.getEdgeCount());
        Assert.assertNotNull(A);
        Assert.assertNotNull(B);
        Assert.assertNotNull(C);
        Assert.assertNotNull(AB);
        Assert.assertNotNull(BC);
        Assert.assertNotNull(CA);
        Assert.assertEquals((Object)"A", (Object)A.getId());
        Assert.assertEquals((Object)"B", (Object)B.getId());
        Assert.assertEquals((Object)"C", (Object)C.getId());
        Assert.assertEquals((Object)"AB", (Object)AB.getId());
        Assert.assertEquals((Object)"BC", (Object)BC.getId());
        Assert.assertEquals((Object)"CA", (Object)CA.getId());
        Assert.assertEquals(A, graph.getNode("A"));
        Assert.assertEquals(B, graph.getNode("B"));
        Assert.assertEquals(C, graph.getNode("C"));
        Assert.assertEquals(AB, graph.getEdge("AB"));
        Assert.assertEquals(BC, graph.getEdge("BC"));
        Assert.assertEquals(CA, graph.getEdge("CA"));
        Assert.assertFalse((boolean)AB.isDirected());
        Assert.assertFalse((boolean)BC.isDirected());
        Assert.assertFalse((boolean)CA.isDirected());
        Assert.assertEquals(A, AB.getNode0());
        Assert.assertEquals(B, AB.getNode1());
        Assert.assertEquals(A, AB.getSourceNode());
        Assert.assertEquals(B, AB.getTargetNode());
        Assert.assertEquals(B, BC.getNode0());
        Assert.assertEquals(C, BC.getNode1());
        Assert.assertEquals(B, BC.getSourceNode());
        Assert.assertEquals(C, BC.getTargetNode());
        Assert.assertEquals(C, CA.getNode0());
        Assert.assertEquals(A, CA.getNode1());
        Assert.assertEquals(C, CA.getSourceNode());
        Assert.assertEquals(A, CA.getTargetNode());
        Assert.assertEquals(B, AB.getOpposite((Node)A));
        Assert.assertEquals(A, AB.getOpposite((Node)B));
        Assert.assertEquals(C, BC.getOpposite((Node)B));
        Assert.assertEquals(B, BC.getOpposite((Node)C));
        Assert.assertEquals(A, CA.getOpposite((Node)C));
        Assert.assertEquals(C, CA.getOpposite((Node)A));
        Assert.assertEquals((long)2L, (long)A.getDegree());
        Assert.assertEquals((long)2L, (long)B.getDegree());
        Assert.assertEquals((long)2L, (long)C.getDegree());
        Assert.assertEquals((long)2L, (long)A.getInDegree());
        Assert.assertEquals((long)2L, (long)A.getOutDegree());
        Assert.assertEquals((long)2L, (long)B.getInDegree());
        Assert.assertEquals((long)2L, (long)B.getOutDegree());
        Assert.assertEquals((long)2L, (long)C.getInDegree());
        Assert.assertEquals((long)2L, (long)C.getOutDegree());
        Assert.assertTrue((boolean)A.hasEdgeFrom("B"));
        Assert.assertTrue((boolean)A.hasEdgeFrom("C"));
        Assert.assertTrue((boolean)B.hasEdgeFrom("A"));
        Assert.assertTrue((boolean)B.hasEdgeFrom("C"));
        Assert.assertTrue((boolean)C.hasEdgeFrom("A"));
        Assert.assertTrue((boolean)C.hasEdgeFrom("B"));
        Assert.assertEquals(AB, A.getEdgeFrom("B"));
        Assert.assertEquals(CA, A.getEdgeFrom("C"));
        Assert.assertEquals(AB, B.getEdgeFrom("A"));
        Assert.assertEquals(BC, B.getEdgeFrom("C"));
        Assert.assertEquals(CA, C.getEdgeFrom("A"));
        Assert.assertEquals(BC, C.getEdgeFrom("B"));
        Assert.assertTrue((boolean)A.hasEdgeToward("B"));
        Assert.assertTrue((boolean)A.hasEdgeToward("C"));
        Assert.assertTrue((boolean)B.hasEdgeToward("A"));
        Assert.assertTrue((boolean)B.hasEdgeToward("C"));
        Assert.assertTrue((boolean)C.hasEdgeToward("A"));
        Assert.assertTrue((boolean)C.hasEdgeToward("B"));
        Assert.assertEquals(AB, A.getEdgeToward("B"));
        Assert.assertEquals(CA, A.getEdgeToward("C"));
        Assert.assertEquals(AB, B.getEdgeToward("A"));
        Assert.assertEquals(BC, B.getEdgeToward("C"));
        Assert.assertEquals(CA, C.getEdgeToward("A"));
        Assert.assertEquals(BC, C.getEdgeToward("B"));
        Assert.assertNull(A.getEdgeFrom("Z"));
        Assert.assertNull(B.getEdgeFrom("Z"));
        Assert.assertNull(C.getEdgeFrom("Z"));
        Assert.assertNull(A.getEdgeToward("Z"));
        Assert.assertNull(B.getEdgeToward("Z"));
        Assert.assertNull(C.getEdgeToward("Z"));
        Assert.assertFalse((boolean)A.hasEdgeBetween((Node)A));
        Assert.assertFalse((boolean)A.hasEdgeToward((Node)A));
        Assert.assertFalse((boolean)A.hasEdgeFrom((Node)A));
        Assert.assertNull(A.getEdgeBetween((Node)A));
        Assert.assertNull(A.getEdgeToward((Node)A));
        Assert.assertNull(A.getEdgeFrom((Node)A));
        Object AA = graph.addEdge("AA", "A", "A");
        Assert.assertEquals((long)4L, (long)graph.getEdgeCount());
        Assert.assertEquals((long)3L, (long)A.getDegree());
        Assert.assertEquals((long)3L, (long)A.getInDegree());
        Assert.assertEquals((long)3L, (long)A.getOutDegree());
        Assert.assertTrue((boolean)A.hasEdgeBetween((Node)A));
        Assert.assertTrue((boolean)A.hasEdgeToward((Node)A));
        Assert.assertTrue((boolean)A.hasEdgeFrom((Node)A));
        Assert.assertEquals(AA, A.getEdgeBetween((Node)A));
        Assert.assertEquals(AA, A.getEdgeToward((Node)A));
        Assert.assertEquals(AA, A.getEdgeFrom((Node)A));
        Assert.assertEquals(A, AA.getSourceNode());
        Assert.assertEquals(A, AA.getTargetNode());
    }

    @Test
    public void testDirected() {
        this.testDirected(new SingleGraph("sg"));
        this.testDirected(new MultiGraph("mg"));
        this.testDirected(new AdjacencyListGraph("AL"));
        this.testDirected(new SingleGraph("S"));
        this.testDirected(new MultiGraph("M"));
    }

    protected void testDirected(Graph graph) {
        Object A = graph.addNode("A");
        Object B = graph.addNode("B");
        Object C = graph.addNode("C");
        Object AB = graph.addEdge("AB", "A", "B");
        Object BC = graph.addEdge("BC", "B", "C", true);
        Object CA = graph.addEdge("CA", "C", "A", false);
        Assert.assertFalse((boolean)AB.isDirected());
        Assert.assertTrue((boolean)BC.isDirected());
        Assert.assertFalse((boolean)CA.isDirected());
        Assert.assertEquals((long)2L, (long)A.getDegree());
        Assert.assertEquals((long)2L, (long)B.getDegree());
        Assert.assertEquals((long)2L, (long)C.getDegree());
        Assert.assertEquals((long)2L, (long)A.getInDegree());
        Assert.assertEquals((long)2L, (long)A.getOutDegree());
        Assert.assertEquals((long)1L, (long)B.getInDegree());
        Assert.assertEquals((long)2L, (long)B.getOutDegree());
        Assert.assertEquals((long)2L, (long)C.getInDegree());
        Assert.assertEquals((long)1L, (long)C.getOutDegree());
        Assert.assertEquals(AB, A.getEdgeFrom("B"));
        Assert.assertEquals(CA, A.getEdgeFrom("C"));
        Assert.assertEquals(AB, B.getEdgeFrom("A"));
        Assert.assertNull(B.getEdgeFrom("C"));
        Assert.assertEquals(CA, C.getEdgeFrom("A"));
        Assert.assertEquals(BC, C.getEdgeFrom("B"));
        Assert.assertEquals(AB, A.getEdgeToward("B"));
        Assert.assertEquals(CA, A.getEdgeToward("C"));
        Assert.assertEquals(AB, B.getEdgeToward("A"));
        Assert.assertEquals(BC, B.getEdgeToward("C"));
        Assert.assertEquals(CA, C.getEdgeToward("A"));
        Assert.assertNull(C.getEdgeToward("B"));
        graph.removeEdge("BC");
        BC = graph.addEdge("BC", "C", "B", true);
        graph.removeEdge("AB");
        AB = graph.addEdge("AB", "A", "B", true);
        Assert.assertTrue((boolean)AB.isDirected());
        Assert.assertTrue((boolean)BC.isDirected());
        Assert.assertFalse((boolean)CA.isDirected());
        Assert.assertEquals((long)2L, (long)A.getDegree());
        Assert.assertEquals((long)2L, (long)B.getDegree());
        Assert.assertEquals((long)2L, (long)C.getDegree());
        Assert.assertEquals((long)1L, (long)A.getInDegree());
        Assert.assertEquals((long)2L, (long)A.getOutDegree());
        Assert.assertEquals((long)2L, (long)B.getInDegree());
        Assert.assertEquals((long)0L, (long)B.getOutDegree());
        Assert.assertEquals((long)1L, (long)C.getInDegree());
        Assert.assertEquals((long)2L, (long)C.getOutDegree());
        Assert.assertNull(A.getEdgeFrom("B"));
        Assert.assertEquals(CA, A.getEdgeFrom("C"));
        Assert.assertEquals(AB, B.getEdgeFrom("A"));
        Assert.assertEquals(BC, B.getEdgeFrom("C"));
        Assert.assertEquals(CA, C.getEdgeFrom("A"));
        Assert.assertNull(C.getEdgeFrom("B"));
        Assert.assertEquals(AB, A.getEdgeToward("B"));
        Assert.assertEquals(CA, A.getEdgeToward("C"));
        Assert.assertNull(B.getEdgeToward("A"));
        Assert.assertNull(B.getEdgeToward("C"));
        Assert.assertEquals(CA, C.getEdgeToward("A"));
        Assert.assertEquals(BC, C.getEdgeToward("B"));
        Assert.assertFalse((boolean)A.hasEdgeBetween((Node)A));
        Assert.assertFalse((boolean)A.hasEdgeToward((Node)A));
        Assert.assertFalse((boolean)A.hasEdgeFrom((Node)A));
        Assert.assertNull(A.getEdgeBetween((Node)A));
        Assert.assertNull(A.getEdgeToward((Node)A));
        Assert.assertNull(A.getEdgeFrom((Node)A));
        Object AA = graph.addEdge("AA", "A", "A", true);
        Assert.assertEquals((long)4L, (long)graph.getEdgeCount());
        Assert.assertEquals((long)3L, (long)A.getDegree());
        Assert.assertEquals((long)2L, (long)A.getInDegree());
        Assert.assertEquals((long)3L, (long)A.getOutDegree());
        Assert.assertTrue((boolean)A.hasEdgeBetween((Node)A));
        Assert.assertTrue((boolean)A.hasEdgeToward((Node)A));
        Assert.assertTrue((boolean)A.hasEdgeFrom((Node)A));
        Assert.assertEquals(AA, A.getEdgeBetween((Node)A));
        Assert.assertEquals(AA, A.getEdgeToward((Node)A));
        Assert.assertEquals(AA, A.getEdgeFrom((Node)A));
        Assert.assertEquals(A, AA.getSourceNode());
        Assert.assertEquals(A, AA.getTargetNode());
    }

    @Test
    public void testMulti() {
        MultiGraph graph = new MultiGraph("g");
        MultiNode A = (MultiNode)graph.addNode("A");
        MultiNode B = (MultiNode)graph.addNode("B");
        graph.addEdge("AB1", "A", "B");
        graph.addEdge("AB2", "A", "B");
        Assert.assertEquals((long)2L, (long)A.getDegree());
        Assert.assertEquals((long)2L, (long)B.getDegree());
        graph.addEdge("AA1", "A", "B");
        graph.addEdge("AA2", "A", "B", true);
        Assert.assertEquals((long)4L, (long)A.getDegree());
    }

    @Test
    public void testSingle() {
        SingleGraph graph = new SingleGraph("g");
        Object A = graph.addNode("A");
        Object B = graph.addNode("B");
        graph.addEdge("AB1", "A", "B");
        try {
            graph.addEdge("AB2", "A", "B");
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)A.getDegree());
        Assert.assertEquals((long)1L, (long)B.getDegree());
    }

    @Test
    public void testIterables() {
        this.testIterables(new SingleGraph("sg"));
        this.testIterables(new MultiGraph("mg"));
        this.testIterables(new AdjacencyListGraph("AL"));
        this.testIterables(new SingleGraph("S"));
        this.testIterables(new MultiGraph("M"));
    }

    protected void testIterables(Graph graph) {
        Object A = graph.addNode("A");
        Object B = graph.addNode("B");
        Object C = graph.addNode("C");
        Object AB = graph.addEdge("AB", "A", "B");
        Object BC = graph.addEdge("BC", "B", "C");
        Object CA = graph.addEdge("CA", "C", "A");
        HashSet<Node> nodes = new HashSet<Node>();
        HashSet<Edge> edges = new HashSet<Edge>();
        for (Node node : graph) {
            nodes.add(node);
        }
        Assert.assertEquals((long)3L, (long)nodes.size());
        Assert.assertTrue((boolean)nodes.contains(A));
        Assert.assertTrue((boolean)nodes.contains(B));
        Assert.assertTrue((boolean)nodes.contains(C));
        nodes.clear();
        for (Node node : graph.getEachNode()) {
            nodes.add(node);
        }
        Assert.assertEquals((long)3L, (long)nodes.size());
        Assert.assertTrue((boolean)nodes.contains(A));
        Assert.assertTrue((boolean)nodes.contains(B));
        Assert.assertTrue((boolean)nodes.contains(C));
        nodes.clear();
        for (Edge edge : graph.getEachEdge()) {
            edges.add(edge);
        }
        Assert.assertEquals((long)3L, (long)edges.size());
        Assert.assertTrue((boolean)edges.contains(AB));
        Assert.assertTrue((boolean)edges.contains(BC));
        Assert.assertTrue((boolean)edges.contains(CA));
        edges.clear();
        for (Edge edge : A) {
            edges.add(edge);
        }
        Assert.assertEquals((long)2L, (long)edges.size());
        Assert.assertTrue((boolean)edges.contains(AB));
        Assert.assertTrue((boolean)edges.contains(CA));
        edges.clear();
        for (Edge edge : A.getEdgeSet()) {
            edges.add(edge);
        }
        Assert.assertEquals((long)2L, (long)edges.size());
        Assert.assertTrue((boolean)edges.contains(AB));
        Assert.assertTrue((boolean)edges.contains(CA));
        edges.clear();
        for (Edge edge : B.getEdgeSet()) {
            edges.add(edge);
        }
        Assert.assertEquals((long)2L, (long)edges.size());
        Assert.assertTrue((boolean)edges.contains(AB));
        Assert.assertTrue((boolean)edges.contains(BC));
        edges.clear();
        for (Edge edge : C.getEdgeSet()) {
            edges.add(edge);
        }
        Assert.assertEquals((long)2L, (long)edges.size());
        Assert.assertTrue((boolean)edges.contains(BC));
        Assert.assertTrue((boolean)edges.contains(CA));
        edges.clear();
        graph.removeEdge("AB");
        AB = graph.addEdge("AB", "A", "B", true);
        graph.removeEdge("BC");
        BC = graph.addEdge("BC", "B", "C", true);
        for (Edge edge : A.getEnteringEdgeSet()) {
            edges.add(edge);
        }
        Assert.assertEquals((long)1L, (long)edges.size());
        Assert.assertTrue((boolean)edges.contains(CA));
        edges.clear();
        for (Edge edge : B.getEnteringEdgeSet()) {
            edges.add(edge);
        }
        Assert.assertEquals((long)1L, (long)edges.size());
        Assert.assertTrue((boolean)edges.contains(AB));
        edges.clear();
        for (Edge edge : C.getEnteringEdgeSet()) {
            edges.add(edge);
        }
        Assert.assertEquals((long)2L, (long)edges.size());
        Assert.assertTrue((boolean)edges.contains(BC));
        Assert.assertTrue((boolean)edges.contains(CA));
        edges.clear();
        for (Edge edge : A.getLeavingEdgeSet()) {
            edges.add(edge);
        }
        Assert.assertEquals((long)2L, (long)edges.size());
        Assert.assertTrue((boolean)edges.contains(AB));
        Assert.assertTrue((boolean)edges.contains(CA));
        edges.clear();
        for (Edge edge : B.getLeavingEdgeSet()) {
            edges.add(edge);
        }
        Assert.assertEquals((long)1L, (long)edges.size());
        Assert.assertTrue((boolean)edges.contains(BC));
        edges.clear();
        for (Edge edge : C.getLeavingEdgeSet()) {
            edges.add(edge);
        }
        Assert.assertEquals((long)1L, (long)edges.size());
        Assert.assertTrue((boolean)edges.contains(CA));
        edges.clear();
    }

    @Test
    public void testRemoval() {
        this.testRemoval(new SingleGraph("sg"));
        this.testRemoval(new MultiGraph("mg"));
        this.testRemoval(new AdjacencyListGraph("AL"));
        this.testRemoval(new SingleGraph("S"));
        this.testRemoval(new MultiGraph("M"));
    }

    public void testRemoval(Graph graph) {
        Object A = graph.addNode("A");
        graph.addNode("B");
        graph.addNode("C");
        Object AB = graph.addEdge("AB", "A", "B");
        graph.addEdge("BC", "B", "C");
        Object CA = graph.addEdge("CA", "C", "A");
        Assert.assertEquals((long)3L, (long)graph.getNodeCount());
        Assert.assertEquals((long)3L, (long)graph.getEdgeCount());
        Object n = graph.removeNode("A");
        Assert.assertEquals((long)2L, (long)graph.getNodeCount());
        Assert.assertEquals((long)1L, (long)graph.getEdgeCount());
        Assert.assertEquals(n, A);
        Assert.assertNull(graph.getEdge("AB"));
        Assert.assertNull(graph.getEdge("CA"));
        Assert.assertNull(graph.getNode("A"));
        Assert.assertNotNull(graph.getEdge("BC"));
        Assert.assertNotNull(graph.getNode("B"));
        Assert.assertNotNull(graph.getNode("C"));
        A = graph.addNode("A");
        AB = graph.addEdge("AB", "A", "B");
        CA = graph.addEdge("CA", "C", "A");
        Assert.assertEquals((long)3L, (long)graph.getNodeCount());
        Assert.assertEquals((long)3L, (long)graph.getEdgeCount());
        Object e = graph.removeEdge("A", "B");
        Assert.assertEquals((long)3L, (long)graph.getNodeCount());
        Assert.assertEquals((long)2L, (long)graph.getEdgeCount());
        Assert.assertEquals(e, AB);
        Assert.assertNull(graph.getEdge("AB"));
        Assert.assertNotNull(graph.getNode("A"));
        Assert.assertNotNull(graph.getNode("B"));
        Assert.assertNotNull(graph.getNode("C"));
        Assert.assertNotNull(graph.getEdge("BC"));
        Assert.assertNotNull(graph.getEdge("CA"));
        e = graph.removeEdge("CA");
        Assert.assertEquals((long)3L, (long)graph.getNodeCount());
        Assert.assertEquals((long)1L, (long)graph.getEdgeCount());
        Assert.assertEquals(e, CA);
        Assert.assertNull(graph.getEdge("AB"));
        Assert.assertNull(graph.getEdge("CA"));
        Assert.assertNotNull(graph.getNode("A"));
        Assert.assertNotNull(graph.getNode("B"));
        Assert.assertNotNull(graph.getNode("C"));
        Assert.assertNotNull(graph.getEdge("BC"));
        Object AA = graph.addEdge("AA", "A", "A");
        Assert.assertEquals((long)2L, (long)graph.getEdgeCount());
        e = graph.removeEdge("AA");
        Assert.assertEquals((long)1L, (long)graph.getEdgeCount());
        Assert.assertEquals(AA, e);
        Assert.assertEquals((long)0L, (long)A.getDegree());
        Assert.assertNull(graph.getEdge("AA"));
        Object BB = graph.addEdge("BB", "B", "B", true);
        Assert.assertEquals((long)2L, (long)graph.getEdgeCount());
        e = graph.removeEdge("BB");
        Assert.assertEquals(BB, e);
        Assert.assertEquals((long)1L, (long)graph.getNode("B").getDegree());
        Assert.assertNull(graph.getEdge("BB"));
        BB = graph.addEdge("BB", "B", "B");
        graph.removeNode("B");
        Assert.assertNull(graph.getEdge("BB"));
        Assert.assertEquals((long)0L, (long)graph.getEdgeCount());
        graph.addEdge("AC", "A", "C");
        graph.addEdge("AA", "A", "A");
        graph.clear();
        Assert.assertEquals((long)0L, (long)graph.getNodeCount());
        Assert.assertEquals((long)0L, (long)graph.getEdgeCount());
    }

    @Test
    public void testGraphListener() {
        this.testGraphListener(new SingleGraph("sg"));
        this.testGraphListener(new MultiGraph("mg"));
        this.testGraphListener(new AdjacencyListGraph("AL"));
        this.testGraphListener(new SingleGraph("S"));
        this.testGraphListener(new MultiGraph("M"));
    }

    protected void testGraphListener(Graph input) {
        MultiGraph output = new MultiGraph("outout");
        input.addSink(output);
        Object A = input.addNode("A");
        input.addNode("B");
        input.addNode("C");
        input.addEdge("AB", "A", "B");
        Object BC = input.addEdge("BC", "B", "C");
        input.addEdge("CA", "C", "A");
        A.addAttribute("foo", "bar");
        BC.addAttribute("foo", "bar");
        Assert.assertEquals((long)3L, (long)input.getNodeCount());
        Assert.assertEquals((long)3L, (long)output.getNodeCount());
        Assert.assertEquals((long)3L, (long)input.getEdgeCount());
        Assert.assertEquals((long)3L, (long)output.getEdgeCount());
        Assert.assertNotNull(output.getNode("A"));
        Assert.assertNotNull(output.getNode("B"));
        Assert.assertNotNull(output.getNode("C"));
        Assert.assertNotNull(output.getEdge("AB"));
        Assert.assertNotNull(output.getEdge("BC"));
        Assert.assertNotNull(output.getEdge("CA"));
        Assert.assertEquals((Object)"bar", output.getNode("A").getAttribute("foo"));
        Assert.assertEquals((Object)"bar", output.getEdge("BC").getAttribute("foo"));
        A.removeAttribute("foo");
        Assert.assertFalse((boolean)output.hasAttribute("foo"));
        input.removeNode("A");
        Assert.assertEquals((long)2L, (long)input.getNodeCount());
        Assert.assertEquals((long)1L, (long)input.getEdgeCount());
        Assert.assertEquals((long)2L, (long)output.getNodeCount());
        Assert.assertEquals((long)1L, (long)output.getEdgeCount());
        BC.changeAttribute("foo", "truc");
        Assert.assertEquals((Object)"truc", BC.getAttribute("foo"));
        Assert.assertEquals((Object)"truc", output.getEdge("BC").getAttribute("foo"));
    }
}

