/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file.pajek.test;

import java.io.IOException;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.MultiGraph;
import org.graphstream.stream.file.FileSourcePajek;
import org.graphstream.ui.swingViewer.Viewer;
import org.junit.Ignore;

@Ignore
public class TestPajekParser {
    static TestEntry[] entries = new TestEntry[]{new TestEntry("1.NET", false, false, false), new TestEntry("1CRN.NET", false, false, false), new TestEntry("AHO1.NET", false, false, false), new TestEntry("AHO2.NET", true, false, false), new TestEntry("AHO3.NET", true, false, false), new TestEntry("AHO4.NET", true, false, false), new TestEntry("B.NET", false, false, false), new TestEntry("C.NET", false, false, false), new TestEntry("CC.NET", false, false, false), new TestEntry("CENPROD.NET", false, false, false), new TestEntry("CIRC.NET", false, false, false), new TestEntry("CITE.NET", true, false, false), new TestEntry("CP.NET", false, false, false), new TestEntry("CPM1.NET", false, false, false), new TestEntry("CPM2.NET", false, false, false), new TestEntry("CPM3.NET", true, false, false), new TestEntry("CVRML.NET", false, false, false), new TestEntry("CX.NET", false, false, false), new TestEntry("D.NET", false, false, false), new TestEntry("DNA.NET", false, false, false), new TestEntry("DREV1.NET", false, false, false), new TestEntry("DREVO.NET", false, false, false), new TestEntry("ETHANOL.NET", false, false, false), new TestEntry("FILE1.NET", true, false, false), new TestEntry("FLOW.NET", false, false, false), new TestEntry("FLOW3.NET", false, false, false), new TestEntry("FLOW4.NET", false, false, false), new TestEntry("FRAG1.NET", false, false, false), new TestEntry("FRAG1Y.NET", false, false, false), new TestEntry("FRAG2.NET", false, false, false), new TestEntry("FRAG3.NET", false, false, false), new TestEntry("FRAG4.NET", false, false, false), new TestEntry("FRAG5.NET", false, false, false), new TestEntry("GCD.NET", false, false, false), new TestEntry("GR3_44.NET", false, false, false), new TestEntry("GR3_53.NET", false, false, false), new TestEntry("GR3_60.NET", false, false, false), new TestEntry("GR3_81.NET", false, false, false), new TestEntry("GR344.NET", false, false, false), new TestEntry("H20.NET", false, false, false), new TestEntry("HEXANE.NET", false, false, false), new TestEntry("KOCKA.NET", true, false, false), new TestEntry("KOCKA1.NET", false, false, false), new TestEntry("KVADRAT.NET", false, false, false), new TestEntry("LINKS.NET", false, false, false), new TestEntry("LOND1.NET", false, false, false), new TestEntry("LONDON.NET", false, false, false), new TestEntry("MCCABE1.NET", false, false, false), new TestEntry("MCCABE1A.NET", false, false, false), new TestEntry("MCCABE2.NET", false, false, false), new TestEntry("MCCABE2A.NET", false, false, false), new TestEntry("MREZA.NET", false, false, false), new TestEntry("MREZA1.NET", false, false, false), new TestEntry("MREZA2.NET", false, false, false), new TestEntry("MREZA3.NET", false, false, false), new TestEntry("MREZAS1.NET", true, false, false), new TestEntry("MREZASHR.NET", false, false, false), new TestEntry("NEG.NET", false, false, false), new TestEntry("NEIG4.NET", false, false, false), new TestEntry("NOOY.NET", false, false, false), new TestEntry("OLDFILE.NET", false, false, false), new TestEntry("PATH4.NET", false, false, false), new TestEntry("PETER.NET", false, false, false), new TestEntry("PETRI1.NET", false, false, false), new TestEntry("PETRI2.NET", false, false, false), new TestEntry("PETRI3.NET", false, false, false), new TestEntry("PETRI4.NET", false, false, false), new TestEntry("PETRI5.NET", false, false, false), new TestEntry("PETRI5X.NET", false, false, false), new TestEntry("PETRI5Y.NET", false, false, false), new TestEntry("PETRI51.NET", false, false, false), new TestEntry("PETRI51X.NET", false, false, false), new TestEntry("PETRI51Y.NET", false, false, false), new TestEntry("PETRI52.NET", false, false, false), new TestEntry("PETRI52X.NET", false, false, false), new TestEntry("PETRI52Y.NET", false, false, false), new TestEntry("PETRI53.NET", false, false, false), new TestEntry("PITT.NET", false, false, false), new TestEntry("PRIME.NET", false, false, false), new TestEntry("PRIME1.NET", false, false, false), new TestEntry("PROT.NET", false, false, false), new TestEntry("PROTI.NET", true, false, false), new TestEntry("SAMPLE6.NET", false, false, false), new TestEntry("SAMPLE9.NET", false, false, false), new TestEntry("SAMPLE10.NET", false, false, false), new TestEntry("SHORT.NET", false, false, false), new TestEntry("SHR.NET", false, false, false), new TestEntry("SHRINK.NET", false, false, false), new TestEntry("SHRINK4.NET", false, false, false), new TestEntry("SHRINK2.NET", false, false, false), new TestEntry("SLOVEN.NET", false, false, false), new TestEntry("STROPIC.NET", false, false, false), new TestEntry("T.NET", false, false, false), new TestEntry("TEST1.NET", false, false, false), new TestEntry("TINA.NET", false, false, false), new TestEntry("TINAMATR.NET", false, false, false), new TestEntry("TRANS.NET", true, false, false), new TestEntry("WIRTH.NET", false, false, false), new TestEntry("WRITE.NET", false, false, false)};

    public static void main(String[] args) throws IOException {
        TestPajekParser test = new TestPajekParser();
        int i = 0;
        while (i < entries.length) {
            test.test(entries[i]);
            ++i;
        }
    }

    public void test(TestEntry entry) throws IOException {
        System.out.printf("> \"%s\"\n", entry.ressourceName);
        MultiGraph graph = new MultiGraph("foo");
        FileSourcePajek in = new FileSourcePajek();
        graph.addAttribute("ui.quality", new Object[0]);
        if (!entry.veryLarge) {
            graph.addAttribute("ui.antialias", new Object[0]);
        }
        if (entry.addLabels) {
            graph.addAttribute("ui.stylesheet", String.format("node { text-alignment: center; size: %dpx; fill-color: grey; %s } edge { fill-color: #333; }", entry.veryLarge ? 6 : 16, entry.veryLarge ? "" : "stroke-mode: plain; stroke-color: #333;"));
        } else {
            graph.addAttribute("ui.stylesheet", String.format("node { text-alignment: at-right; size: %dpx; fill-color: grey; %s text-background-mode: plain; text-offset: 2px, 0px; text-padding: 2px; text-background-color: #FFFFFFAA; } edge { fill-color: #333; }", entry.veryLarge ? 6 : 16, entry.veryLarge ? "" : "stroke-mode: plain; stroke-color: #333;"));
        }
        Viewer v = graph.display(entry.autoLayout);
        v.setCloseFramePolicy(Viewer.CloseFramePolicy.CLOSE_VIEWER);
        in.addSink(graph);
        in.readAll(TestPajekParser.class.getResourceAsStream(entry.ressourceName));
        if (entry.addLabels) {
            for (Node node : graph) {
                node.addAttribute("ui.label", node.getId());
            }
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        v.close();
    }

    static class TestEntry {
        String ressourceName;
        boolean autoLayout;
        boolean addLabels;
        boolean veryLarge;

        TestEntry(String name, boolean layout, boolean addLabels, boolean veryLarge) {
            this.ressourceName = name;
            this.autoLayout = layout;
            this.addLabels = addLabels;
            this.veryLarge = veryLarge;
        }
    }
}

