/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.util.cumulative;

import java.util.Collections;
import java.util.HashMap;
import org.graphstream.util.cumulative.CumulativeSpells;

public class CumulativeAttributes {
    boolean nullAttributesAreErrors;
    HashMap<String, CumulativeSpells> data = new HashMap();
    double date;

    public CumulativeAttributes(double date) {
    }

    public Object get(String key) {
        CumulativeSpells o = this.data.get(key);
        if (o != null) {
            CumulativeSpells.Spell s = o.getCurrentSpell();
            return s == null ? null : s.getAttachedData();
        }
        return null;
    }

    public Object getAny(String key) {
        CumulativeSpells o = this.data.get(key);
        if (o != null) {
            CumulativeSpells.Spell s = o.getSpell(0);
            return s == null ? null : s.getAttachedData();
        }
        return null;
    }

    public Iterable<String> getAttributes() {
        return this.data.keySet();
    }

    public Iterable<CumulativeSpells.Spell> getAttributeSpells(String key) {
        CumulativeSpells o = this.data.get(key);
        if (o != null) {
            return Collections.unmodifiableList(o.spells);
        }
        return Collections.EMPTY_LIST;
    }

    public int getAttributesCount() {
        return this.data.size();
    }

    public void set(String key, Object value) {
        CumulativeSpells.Spell s;
        CumulativeSpells spells = this.data.get(key);
        if (spells == null) {
            spells = new CumulativeSpells();
            this.data.put(key, spells);
        }
        if ((s = spells.closeSpell()) != null) {
            s.setEndOpen(true);
        }
        s = spells.startSpell(this.date);
        s.setAttachedData(value);
    }

    public void remove(String key) {
        CumulativeSpells spells = this.data.get(key);
        if (spells == null) {
            return;
        }
        spells.closeSpell();
    }

    public void remove() {
        for (CumulativeSpells spells : this.data.values()) {
            spells.closeSpell();
        }
    }

    public void updateDate(double date) {
        this.date = date;
        for (CumulativeSpells spells : this.data.values()) {
            spells.updateCurrentSpell(date);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("(");
        for (String key : this.data.keySet()) {
            buffer.append(key).append(":").append(this.data.get(key));
        }
        buffer.append(")");
        return buffer.toString();
    }
}

