/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.swingViewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import javax.swing.JFrame;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.graphicGraph.GraphicGraph;
import org.graphstream.ui.swingViewer.GraphRenderer;
import org.graphstream.ui.swingViewer.LayerRenderer;
import org.graphstream.ui.swingViewer.View;
import org.graphstream.ui.swingViewer.Viewer;
import org.graphstream.ui.swingViewer.util.Camera;
import org.graphstream.ui.swingViewer.util.DefaultMouseManager;
import org.graphstream.ui.swingViewer.util.DefaultShortcutManager;
import org.graphstream.ui.swingViewer.util.MouseManager;
import org.graphstream.ui.swingViewer.util.ShortcutManager;

public class DefaultView
extends View
implements WindowListener {
    private static final long serialVersionUID = -4489484861592064398L;
    protected Viewer viewer;
    protected GraphicGraph graph;
    protected JFrame frame;
    protected ShortcutManager shortcuts;
    protected MouseManager mouseClicks;
    protected GraphRenderer renderer;

    public DefaultView(Viewer viewer, String identifier, GraphRenderer renderer) {
        super(identifier);
        this.viewer = viewer;
        this.graph = viewer.getGraphicGraph();
        this.renderer = renderer;
        this.setOpaque(false);
        this.setDoubleBuffered(true);
        this.setMouseManager(null);
        this.setShortcutManager(null);
        renderer.open(this.graph, this);
    }

    @Override
    public Camera getCamera() {
        return this.renderer.getCamera();
    }

    @Override
    public void display(GraphicGraph graph, boolean graphChanged) {
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.checkTitle();
        Graphics2D g2 = (Graphics2D)g;
        this.render(g2);
    }

    protected void checkTitle() {
        if (this.frame != null) {
            String titleAttr = String.format("ui.%s.title", this.getId());
            String title = (String)this.graph.getLabel(titleAttr);
            if (title == null && (title = (String)this.graph.getLabel("ui.default.title")) == null) {
                title = (String)this.graph.getLabel("ui.title");
            }
            if (title != null) {
                this.frame.setTitle(title);
            }
        }
    }

    @Override
    public void close(GraphicGraph graph) {
        this.renderer.close();
        graph.addAttribute("ui.viewClosed", this.getId());
        this.removeKeyListener(this.shortcuts);
        this.shortcuts.release();
        this.mouseClicks.release();
        this.openInAFrame(false);
    }

    @Override
    public void resizeFrame(int width, int height) {
        if (this.frame != null) {
            this.frame.setSize(width, height);
        }
    }

    @Override
    public void openInAFrame(boolean on) {
        if (on) {
            if (this.frame == null) {
                this.frame = new JFrame("GraphStream");
                this.frame.setLayout(new BorderLayout());
                this.frame.add((Component)this, "Center");
                this.frame.setSize(800, 600);
                this.frame.setVisible(true);
                this.frame.addWindowListener(this);
                this.frame.addKeyListener(this.shortcuts);
            } else {
                this.frame.setVisible(true);
            }
        } else if (this.frame != null) {
            this.frame.removeWindowListener(this);
            this.frame.removeKeyListener(this.shortcuts);
            this.frame.remove(this);
            this.frame.setVisible(false);
            this.frame.dispose();
        }
    }

    public void render(Graphics2D g) {
        this.renderer.render(g, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        String screenshot = (String)this.graph.getLabel("ui.screenshot");
        if (screenshot != null) {
            this.graph.removeAttribute("ui.screenshot");
            this.renderer.screenshot(screenshot, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public void beginSelectionAt(double x1, double y1) {
        this.renderer.beginSelectionAt(x1, y1);
        this.repaint();
    }

    @Override
    public void selectionGrowsAt(double x, double y) {
        this.renderer.selectionGrowsAt(x, y);
        this.repaint();
    }

    @Override
    public void endSelectionAt(double x2, double y2) {
        this.renderer.endSelectionAt(x2, y2);
        this.repaint();
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.graph.addAttribute("ui.viewClosed", this.getId());
        switch (this.viewer.getCloseFramePolicy()) {
            case CLOSE_VIEWER: {
                this.viewer.removeView(this.getId());
                break;
            }
            case HIDE_ONLY: {
                if (this.frame == null) break;
                this.frame.setVisible(false);
                break;
            }
            case EXIT: {
                System.exit(0);
            }
            default: {
                throw new RuntimeException(String.format("The %s view is not up to date, do not know %s CloseFramePolicy.", new Object[]{this.getClass().getName(), this.viewer.getCloseFramePolicy()}));
            }
        }
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
        this.graph.removeAttribute("ui.viewClosed");
    }

    @Override
    public ArrayList<GraphicElement> allNodesOrSpritesIn(double x1, double y1, double x2, double y2) {
        return this.renderer.allNodesOrSpritesIn(x1, y1, x2, y2);
    }

    @Override
    public GraphicElement findNodeOrSpriteAt(double x, double y) {
        return this.renderer.findNodeOrSpriteAt(x, y);
    }

    @Override
    public void moveElementAtPx(GraphicElement element, double x, double y) {
        boolean on = this.graph.feedbackXYZ();
        this.graph.feedbackXYZ(true);
        this.renderer.moveElementAtPx(element, x, y);
        this.graph.feedbackXYZ(on);
    }

    @Override
    public void freezeElement(GraphicElement element, boolean frozen) {
        if (frozen) {
            element.addAttribute("layout.frozen", new Object[0]);
        } else {
            element.removeAttribute("layout.frozen");
        }
    }

    @Override
    public void setBackLayerRenderer(LayerRenderer renderer) {
        this.renderer.setBackLayerRenderer(renderer);
        this.repaint();
    }

    @Override
    public void setForeLayoutRenderer(LayerRenderer renderer) {
        this.renderer.setForeLayoutRenderer(renderer);
        this.repaint();
    }

    @Override
    public void setMouseManager(MouseManager manager) {
        if (this.mouseClicks != null) {
            this.mouseClicks.release();
        }
        if (manager == null) {
            manager = new DefaultMouseManager();
        }
        manager.init(this.graph, this);
        this.mouseClicks = manager;
    }

    @Override
    public void setShortcutManager(ShortcutManager manager) {
        if (this.shortcuts != null) {
            this.shortcuts.release();
        }
        if (manager == null) {
            manager = new DefaultShortcutManager();
        }
        manager.init(this.graph, this);
        this.shortcuts = manager;
    }
}

