
<!-- @import "[TOC]" {cmd="toc" depthFrom=1 depthTo=6 orderedList=false} -->

<!-- code_chunk_output -->

- [Purpose](#purpose)
- [Usage](#usage)
  - [Build](#build)
    - [Linux and Windows with OMDev MSYS](#linux-and-windows-with-omdev-msys)
    - [Windows with other/fresh MSYS2](#windows-with-otherfresh-msys2)
    - [Windows with Visual Studio Compiler](#windows-with-visual-studio-compiler)
    - [MacOS](#macos)
  - [Install](#install)
- [Benefits](#benefits)
- [Potential (Further improvement)](#potential-further-improvement)
- [Progress](#progress)

<!-- /code_chunk_output -->

# Purpose
This is an attempt to have a CMake configuration support for OMC. Right now the focus is in getting OMCompiler working.
This is **half way done**. It is here just for early discussion. If it is deemed unnecessary it might be removed completely.

The idea is to aim for recent versions of cmake. (a.k.a "modern" CMake). This means it is intended to work only with **CMake > 3.14**. It should be easy to get this (or later) versions of CMake on most platforms. On _MinGW_ you can use the **Windows** version of CMake which is, right now, at 3.17.2 (stable) .

However, this does not mean that you will need CMake > 3.14 to compile and use OpenModelica as you do now. You should **still be able to compile OpenModelica using the current Makefile based and/or auto-tools based build system** that we are using at the moment even if you have CMake 2.6.

# Usage
**NOTE**: **_This does not yet support bootstrapping AND it also needs an omc with an UPDATED scripting API from this branch itself. This means, after you switch to this branch, you will have to **COMPILE omc ONCE** with the build method that you are currently using. Afterwards you can use the omc generated by this for further MetaModelica compilations._**

## Build
### Linux and Windows with OMDev MSYS
It is pretty straightforward cmake stuff.


```sh
$ cd OMCompiler
$ mkdir build_cmake && cd build_cmake

# Wno-dev to hide some cmake warnings from 3rdParty
# Generator, e.g. -G "MSYS Makefiles" for OMDev MSYS
# set install_dir to where you want files to be installed.
$ cmake ../ -Wno-dev -G <your_generator> -DCMAKE_INSTALL_PREFIX=<install_dir>

# -Oline for GNU Makefiles on MinGW/MSYS/OMDev so that your colors do not get messed up.
$ make -j<N> -Oline omc
# $ cmake --build ./ --target omc --parallel <N> # If you want to be generic (other configurations)

# omc will be generated in <build_dir>/Compiler/
$ <build_dir>/Compiler/omc --help
```

**If you are on Linux like systems omc will check if it is in a folder whose path includes `/bin` or `/lib`. If it is not, it will tell you to update your OPENMODELICAHOME env variable.  Instead, you can just INSTALL the files as shown below or copy or move the generated omc into a folder called <something>/bin for now.**

### Windows with other/fresh MSYS2
If you are using windows you can also use your own MSYS (non-OMDev) installation to build omc.  You can also use a fresh MSYS2 from https://www.msys2.org/.

Open a MINGW64 shell and install the dependencies needed to build omc.


```sh
# Install dependencies using pacman
$ pacman -S make bison flex mingw-w64-x86_64-curl mingw-w64-x86_64-openblas
```

*Note that we install the MSYS version of `make`. The mingw32-make is not what you need here. Bison and flex are not strictly needed. They are only needed for building 3rdParty/lpsolve and that will be made optional soon*

Then follow the same instructions as Linux/OMDev above.


### Windows with Visual Studio Compiler
Coming soon. There are two things to be decided/done

  - Getting the needed Windows versions of OpenModelica dependencies to be used with VS.
    - I am using vcpkg to manage the dependencies now and it seems to work fine.
      However there will be discussions on if and which package manager OpenModelica chooses to use.

      If you would like to try out the vcpkg version let me know.

  - Fixing of compilation errors due to Linux/POSIX vs Windows differences in some system functions.

### MacOS
This will be next after Visual Studio.


## Install

CMake uses a separate script (cmake_install.cmake) to perform installation. Since we are used to issuing 'make install' by default, CMake provides a specific _built-in_ 'install' target. However, this target implies a **full build and full install**. That is, you have no control on which parts you want to install. If this is what you want to do you can use that.

If you are working on just omc and do not need the whole set of *simulation runtime* libraries built and installed, there is a custom target `install_omc` provided which will build and install what is needed to run omc.

```sh
# Build and Install just omc
$ make install_omc # For makefile generators
# $ cmake --build <build_dir> --target install_omc # Generic usage.
# $ cmake -DCOMPONENT=compiler -P cmake_install.cmake # The equivalent cmake_install invocation

# Build and Install everything
$ make install # NOTE: This will first build everything. Not just omc.
# $ cmake --build <build_dir> --target install # Generic usage.
# $ cmake -P cmake_install.cmake # The equivalent cmake_install invocation

# omc will be installed in <install_dir>/bin/
$ <install_dir>/bin/omc --help
```

# Benefits
- It forces us to have proper structure.
- Same build configuration on different platforms.
- _Modern_ CMake: automatic configuration propagation.
  - Cleanly specify for each library:
    - Where is is coming from?
    - Which libraries does it depend on?
    - Where do those libraries come from.
    - What header files does it need?
    - What header files should its dependents use?
    - What compilation flags and options does it need?
    - What compilation flags and options its dependents should use?
    - ...
- _Potentially_ use different build systems.
  - Ninja
  - MSBuild (one day, in the distant future)
- Clean out of source builds.
- ...

# Potential (Further improvement)
- Use CMake aware package manager, e.g., vcpkg, connan ...
- Use CMake's fetch_content (configure time downloading) to get anything that is not available through package manager or anything that needs patching and custom handling.

# Progress

- [x] OMCompiler/3rdParty/(most)
- [x] OMCompiler/Parser
- [x] OMCompiler/Compiler/runtime
- [x] OMCompiler/Compiler/Template
- [x] OMCompiler/SimulationRuntime/c/{OpenModelicaRuntime, OpenModelicaFMIRuntime}
- [x] Figure out a way to cleanly handle the `MetaModelica` source files to build `libOpenModelica`.
  - This is the big one. To simplify things, the idea is to aim for no bootstrapping support yet. Just compilation using installed OMC.
  [ ] Make sure bootstrapping sources can be updated cleanly.
- [x] Add a header only interface library for all the common include files. e.g. `openmodelica.h`, `revision.h`
- [x] Handle all libraries in OMCompiler/SimulationRuntime/c. Some are left for later.
- [x] Handle all libraries in OMCompiler/SimulationRuntime/cpp. Some are left for later.
- [x] Handle FMUs. Binary and source code.
- [ ] No free standing "outside" include directories. All includes should come from dependency targets.

- [ ] ... (Many more if this goes on)