//
// Copyright (c) 2002--2010
// Toon Knapen, Karl Meerbergen, Kresimir Fresl,
// Thomas Klimpel and Rutger ter Borg
//
// Distributed under the Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)
//
// THIS FILE IS AUTOMATICALLY GENERATED
// PLEASE DO NOT EDIT!
//

#ifndef BOOST_NUMERIC_BINDINGS_LAPACK_COMPUTATIONAL_SBGST_HPP
#define BOOST_NUMERIC_BINDINGS_LAPACK_COMPUTATIONAL_SBGST_HPP

#include <boost/assert.hpp>
#include <Core/Utils/numeric/bindings/bandwidth.hpp>
#include <Core/Utils/numeric/bindings/begin.hpp>
#include <Core/Utils/numeric/bindings/detail/array.hpp>
#include <Core/Utils/numeric/bindings/is_column_major.hpp>
#include <Core/Utils/numeric/bindings/is_mutable.hpp>
#include <Core/Utils/numeric/bindings/lapack/workspace.hpp>
#include <Core/Utils/numeric/bindings/remove_imaginary.hpp>
#include <Core/Utils/numeric/bindings/size.hpp>
#include <Core/Utils/numeric/bindings/stride.hpp>
#include <Core/Utils/numeric/bindings/uplo_tag.hpp>
#include <Core/Utils/numeric/bindings/value_type.hpp>
#include <boost/static_assert.hpp>
#include <boost/type_traits/is_same.hpp>
#include <boost/type_traits/remove_const.hpp>

//
// The LAPACK-backend for sbgst is the netlib-compatible backend.
//
#include <Core/Utils/numeric/bindings/lapack/detail/lapack.h>
#include <Core/Utils/numeric/bindings/lapack/detail/lapack_option.hpp>

namespace boost
{
    namespace numeric
    {
        namespace bindings
        {
            namespace lapack
            {
                //
                // The detail namespace contains value-type-overloaded functions that
                // dispatch to the appropriate back-end LAPACK-routine.
                //
                namespace detail
                {
                    //
                    // Overloaded function for dispatching to
                    // * netlib-compatible LAPACK backend (the default), and
                    // * float value-type.
                    //
                    template <typename UpLo>
                    inline std::ptrdiff_t sbgst(const char vect, const UpLo,
                                                const fortran_int_t n, const fortran_int_t ka, const fortran_int_t kb,
                                                float* ab, const fortran_int_t ldab, const float* bb,
                                                const fortran_int_t ldbb, float* x, const fortran_int_t ldx,
                                                float* work)
                    {
                        fortran_int_t info(0);
                        LAPACK_SSBGST(&vect, &lapack_option<UpLo>::value, &n, &ka, &kb, ab,
                                      &ldab, bb, &ldbb, x, &ldx, work, &info);
                        return info;
                    }

                    //
                    // Overloaded function for dispatching to
                    // * netlib-compatible LAPACK backend (the default), and
                    // * double value-type.
                    //
                    template <typename UpLo>
                    inline std::ptrdiff_t sbgst(const char vect, const UpLo,
                                                const fortran_int_t n, const fortran_int_t ka, const fortran_int_t kb,
                                                double* ab, const fortran_int_t ldab, const double* bb,
                                                const fortran_int_t ldbb, double* x, const fortran_int_t ldx,
                                                double* work)
                    {
                        fortran_int_t info(0);
                        LAPACK_DSBGST(&vect, &lapack_option<UpLo>::value, &n, &ka, &kb, ab,
                                      &ldab, bb, &ldbb, x, &ldx, work, &info);
                        return info;
                    }
                } // namespace detail

                //
                // Value-type based template class. Use this class if you need a type
                // for dispatching to sbgst.
                //
                template <typename Value>
                struct sbgst_impl
                {
                    typedef Value value_type;
                    typedef typename remove_imaginary<Value>::type real_type;

                    //
                    // Static member function for user-defined workspaces, that
                    // * Deduces the required arguments for dispatching to LAPACK, and
                    // * Asserts that most arguments make sense.
                    //
                    template <typename MatrixAB, typename MatrixBB, typename MatrixX,
                              typename WORK>
                    static std::ptrdiff_t invoke(const char vect, MatrixAB& ab,
                                                 const MatrixBB& bb, MatrixX& x, detail::workspace1<WORK> work)
                    {
                        namespace bindings = ::boost::numeric::bindings;
                        typedef typename result_of::uplo_tag<MatrixAB>::type uplo;
                        BOOST_STATIC_ASSERT((bindings::is_column_major<MatrixAB>::value));
                        BOOST_STATIC_ASSERT((bindings::is_column_major<MatrixBB>::value));
                        BOOST_STATIC_ASSERT((bindings::is_column_major<MatrixX>::value));
                        BOOST_STATIC_ASSERT((boost::is_same<typename remove_const<
                                                                typename bindings::value_type<MatrixAB>::type>::type,
                                                            typename remove_const<typename bindings::value_type<
                                                                MatrixBB>::type>::type>::value));
                        BOOST_STATIC_ASSERT((boost::is_same<typename remove_const<
                                                                typename bindings::value_type<MatrixAB>::type>::type,
                                                            typename remove_const<typename bindings::value_type<
                                                                MatrixX>::type>::type>::value));
                        BOOST_STATIC_ASSERT((bindings::is_mutable<MatrixAB>::value));
                        BOOST_STATIC_ASSERT((bindings::is_mutable<MatrixX>::value));
                        BOOST_ASSERT(bindings::bandwidth(ab, uplo()) >= 0);
                        BOOST_ASSERT(bindings::size(work.select(real_type())) >=
                            min_size_work(bindings::size_column(ab)));
                        BOOST_ASSERT(bindings::size_column(ab) >= 0);
                        BOOST_ASSERT(bindings::size_minor(ab) == 1 ||
                            bindings::stride_minor(ab) == 1);
                        BOOST_ASSERT(bindings::size_minor(bb) == 1 ||
                            bindings::stride_minor(bb) == 1);
                        BOOST_ASSERT(bindings::size_minor(x) == 1 ||
                            bindings::stride_minor(x) == 1);
                        BOOST_ASSERT(bindings::stride_major(ab) >= bindings::bandwidth(ab,
                                                                                       uplo()) + 1);
                        BOOST_ASSERT(bindings::stride_major(bb) >= bindings::bandwidth(bb,
                                                                                       uplo()) + 1);
                        BOOST_ASSERT(vect == 'N' || vect == 'V');
                        return detail::sbgst(vect, uplo(), bindings::size_column(ab),
                                             bindings::bandwidth(ab, uplo()), bindings::bandwidth(bb,
                                                                                                  uplo()),
                                             bindings::begin_value(ab),
                                             bindings::stride_major(ab), bindings::begin_value(bb),
                                             bindings::stride_major(bb), bindings::begin_value(x),
                                             bindings::stride_major(x),
                                             bindings::begin_value(work.select(real_type())));
                    }

                    //
                    // Static member function that
                    // * Figures out the minimal workspace requirements, and passes
                    //   the results to the user-defined workspace overload of the
                    //   invoke static member function
                    // * Enables the unblocked algorithm (BLAS level 2)
                    //
                    template <typename MatrixAB, typename MatrixBB, typename MatrixX>
                    static std::ptrdiff_t invoke(const char vect, MatrixAB& ab,
                                                 const MatrixBB& bb, MatrixX& x, minimal_workspace)
                    {
                        namespace bindings = ::boost::numeric::bindings;
                        typedef typename result_of::uplo_tag<MatrixAB>::type uplo;
                        bindings::detail::array<real_type> tmp_work(min_size_work(
                            bindings::size_column(ab)));
                        return invoke(vect, ab, bb, x, workspace(tmp_work));
                    }

                    //
                    // Static member function that
                    // * Figures out the optimal workspace requirements, and passes
                    //   the results to the user-defined workspace overload of the
                    //   invoke static member
                    // * Enables the blocked algorithm (BLAS level 3)
                    //
                    template <typename MatrixAB, typename MatrixBB, typename MatrixX>
                    static std::ptrdiff_t invoke(const char vect, MatrixAB& ab,
                                                 const MatrixBB& bb, MatrixX& x, optimal_workspace)
                    {
                        namespace bindings = ::boost::numeric::bindings;
                        typedef typename result_of::uplo_tag<MatrixAB>::type uplo;
                        return invoke(vect, ab, bb, x, minimal_workspace());
                    }

                    //
                    // Static member function that returns the minimum size of
                    // workspace-array work.
                    //
                    static std::ptrdiff_t min_size_work(const std::ptrdiff_t n)
                    {
                        return 2 * n;
                    }
                };


                //
                // Functions for direct use. These functions are overloaded for temporaries,
                // so that wrapped types can still be passed and used for write-access. In
                // addition, if applicable, they are overloaded for user-defined workspaces.
                // Calls to these functions are passed to the sbgst_impl classes. In the
                // documentation, most overloads are collapsed to avoid a large number of
                // prototypes which are very similar.
                //

                //
                // Overloaded function for sbgst. Its overload differs for
                // * User-defined workspace
                //
                template <typename MatrixAB, typename MatrixBB, typename MatrixX,
                          typename Workspace>
                inline typename boost::enable_if<detail::is_workspace<Workspace>,
                                                 std::ptrdiff_t>::type
                sbgst(const char vect, MatrixAB& ab, const MatrixBB& bb, MatrixX& x,
                      Workspace work)
                {
                    return sbgst_impl<typename bindings::value_type<
                        MatrixAB>::type>::invoke(vect, ab, bb, x, work);
                }

                //
                // Overloaded function for sbgst. Its overload differs for
                // * Default workspace-type (optimal)
                //
                template <typename MatrixAB, typename MatrixBB, typename MatrixX>
                inline typename boost::disable_if<detail::is_workspace<MatrixX>,
                                                  std::ptrdiff_t>::type
                sbgst(const char vect, MatrixAB& ab, const MatrixBB& bb, MatrixX& x)
                {
                    return sbgst_impl<typename bindings::value_type<
                        MatrixAB>::type>::invoke(vect, ab, bb, x, optimal_workspace());
                }
            } // namespace lapack
        } // namespace bindings
    } // namespace numeric
} // namespace boost

#endif
