/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath.xml;

import java.util.EmptyStackException;

public final class BoolStack {
    private boolean[] m_values;
    private int m_allocatedSize;
    private int m_index;

    public BoolStack() {
        this(32);
    }

    public BoolStack(int n) {
        this.m_allocatedSize = n;
        this.m_values = new boolean[n];
        this.m_index = -1;
    }

    private void grow() {
        this.m_allocatedSize *= 2;
        boolean[] blArray = new boolean[this.m_allocatedSize];
        System.arraycopy(this.m_values, 0, blArray, 0, this.m_index + 1);
        this.m_values = blArray;
    }

    public boolean isEmpty() {
        return this.m_index == -1;
    }

    public boolean peek() {
        try {
            return this.m_values[this.m_index];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new EmptyStackException();
        }
    }

    public boolean pop() {
        try {
            return this.m_values[this.m_index--];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new EmptyStackException();
        }
    }

    public boolean push(boolean bl) {
        if (this.m_index == this.m_allocatedSize - 1) {
            this.grow();
        }
        boolean bl2 = bl;
        this.m_values[++this.m_index] = bl2;
        return bl2;
    }

    public int size() {
        return this.m_index + 1;
    }
}

