/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.test;

import junit.framework.Assert;
import org.graphstream.graph.implementations.AdjacencyListGraph;
import org.graphstream.stream.AnnotatedSink;
import org.graphstream.stream.SourceBase;
import org.junit.Test;

public class TestAnnotatedSink {
    public static final String GRAPH_BINDING_ATTR = "test.object.eventA";
    public static final String NODE_BINDING_ATTR = "test.object.eventB";
    public static final String EDGE_BINDING_ATTR = "test.object.eventC";
    public static final Object GRAPH_BINDING_VALUE = "stringValue";
    public static final Object NODE_BINDING_VALUE = 100.0;
    public static final Object EDGE_BINDING_VALUE = 200;
    public static final String NODE_ID = "nodeB";
    public static final String EDGE_ID = "edgeC";

    @Test
    public void check() {
        AdjacencyListGraph g = new AdjacencyListGraph("test");
        g.addSink(new TestObject());
        g.addAttribute(GRAPH_BINDING_ATTR, GRAPH_BINDING_VALUE);
        g.addNode(NODE_ID).addAttribute(NODE_BINDING_ATTR, NODE_BINDING_VALUE);
        g.addNode("otherNode");
        g.addEdge(EDGE_ID, NODE_ID, "otherNode").addAttribute(EDGE_BINDING_ATTR, EDGE_BINDING_VALUE);
    }

    public static class TestObject
    extends AnnotatedSink {
        @AnnotatedSink.Bind(value="test.object.eventA")
        public void graphBinding(String attribute, Object value) {
            Assert.assertEquals((String)TestAnnotatedSink.GRAPH_BINDING_ATTR, (String)attribute);
            Assert.assertEquals((Object)GRAPH_BINDING_VALUE, (Object)value);
        }

        @AnnotatedSink.Bind(value="test.object.eventB", type=SourceBase.ElementType.NODE)
        public void nodeBinding(String nodeId, String attribute, Object value) {
            Assert.assertEquals((String)TestAnnotatedSink.NODE_BINDING_ATTR, (String)attribute);
            Assert.assertEquals((String)TestAnnotatedSink.NODE_ID, (String)nodeId);
            Assert.assertEquals((Object)NODE_BINDING_VALUE, (Object)value);
        }

        @AnnotatedSink.Bind(value="test.object.eventC", type=SourceBase.ElementType.EDGE)
        public void edgeBinding(String edgeId, String attribute, Object value) {
            Assert.assertEquals((String)TestAnnotatedSink.EDGE_BINDING_ATTR, (String)attribute);
            Assert.assertEquals((String)TestAnnotatedSink.EDGE_ID, (String)edgeId);
            Assert.assertEquals((Object)EDGE_BINDING_VALUE, (Object)value);
        }
    }
}

